/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.gef.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.EventListenerList;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.wb.gef.core.IEditPartFactory;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.gef.core.EditDomain;

public abstract class AbstractEditPartViewer
extends org.eclipse.gef.ui.parts.AbstractEditPartViewer
implements IEditPartViewer {
    private EditDomain m_domain;
    private IEditPartFactory m_factory;
    private MenuManager m_contextMenu;
    private List<org.eclipse.wb.gef.core.EditPart> m_selectionList = new ArrayList<org.eclipse.wb.gef.core.EditPart>();
    private EventListenerList m_eventTable;
    private org.eclipse.wb.gef.core.EditPart m_selecting;

    @Override
    public IEditPartFactory getEditPartFactory() {
        return this.m_factory;
    }

    public void setEditPartFactory(IEditPartFactory factory) {
        this.m_factory = factory;
    }

    @Override
    public void registerEditPart(org.eclipse.wb.gef.core.EditPart editPart) {
        this.getEditPartRegistry().put(editPart.getModel(), editPart);
    }

    @Override
    public void unregisterEditPart(org.eclipse.wb.gef.core.EditPart editPart) {
        Object model = editPart.getModel();
        Object registerPart = this.getEditPartRegistry().get(model);
        if (registerPart == editPart) {
            this.getEditPartRegistry().remove(model);
        }
    }

    @Override
    public EditDomain getEditDomain() {
        return this.m_domain;
    }

    public void setEditDomain(EditDomain domain) {
        this.m_domain = domain;
    }

    public void setInput(Object model) {
        RootEditPart rootEditPart = this.getRootEditPart();
        org.eclipse.wb.gef.core.EditPart contentEditPart = this.m_factory.createEditPart((org.eclipse.wb.gef.core.EditPart)rootEditPart, model);
        rootEditPart.setContents((EditPart)contentEditPart);
    }

    @Override
    public MenuManager getContextMenu() {
        return this.m_contextMenu;
    }

    @Override
    public void setContextMenu(MenuManager menu) {
        if (this.m_contextMenu != null && this.m_contextMenu != menu) {
            this.m_contextMenu.dispose();
        }
        this.m_contextMenu = menu;
        Control control = this.getControl();
        Menu menuWidget = this.m_contextMenu.createContextMenu(control);
        if (menuWidget.getShell() == control.getShell()) {
            control.setMenu(menuWidget);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.getEnsureEventTable().addListener(ISelectionChangedListener.class, (Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.getEnsureEventTable().removeListener(ISelectionChangedListener.class, (Object)listener);
    }

    public ISelection getSelection() {
        org.eclipse.wb.gef.core.EditPart content;
        if (this.m_selectionList.isEmpty() && (content = (org.eclipse.wb.gef.core.EditPart)this.getRootEditPart().getContents()) != null) {
            return new StructuredSelection((Object)content);
        }
        return new StructuredSelection(this.m_selectionList);
    }

    /*
     * WARNING - void declaration
     */
    public void setSelection(ISelection selection) {
        ISelection iSelection = selection;
        if (iSelection instanceof IStructuredSelection) {
            void structuredSelection;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            IStructuredSelection cfr_ignored_0 = (IStructuredSelection)iSelection;
            this.setSelection(structuredSelection.toList());
        }
    }

    protected void fireSelectionChanged() {
        Iterator<ISelectionChangedListener> listeners = this.getListeners(ISelectionChangedListener.class);
        if (listeners != null) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            listeners.forEachRemaining(listener -> listener.selectionChanged(event));
        }
    }

    @Override
    public void appendSelection(org.eclipse.wb.gef.core.EditPart part) {
        org.eclipse.wb.gef.core.EditPart primary;
        Assert.isNotNull((Object)((Object)part));
        if (!this.m_selectionList.isEmpty() && (primary = this.m_selectionList.get(this.m_selectionList.size() - 1)) != part) {
            try {
                this.m_selecting = part;
                primary.setSelected(1);
            }
            finally {
                this.m_selecting = null;
            }
        }
        try {
            this.m_selecting = part;
            this.m_selectionList.remove((Object)part);
            this.m_selectionList.add(part);
            part.setSelected(2);
        }
        finally {
            this.m_selecting = null;
        }
        this.fireSelectionChanged();
    }

    @Override
    public void setSelection(List<org.eclipse.wb.gef.core.EditPart> editParts) {
        try {
            if (!editParts.isEmpty()) {
                this.m_selecting = editParts.get(0);
            }
            this.internalDeselectAll();
            Iterator<org.eclipse.wb.gef.core.EditPart> I = editParts.iterator();
            while (I.hasNext()) {
                org.eclipse.wb.gef.core.EditPart part = I.next();
                if (part == null) continue;
                this.m_selectionList.add(part);
                this.m_selecting = part;
                if (I.hasNext()) {
                    part.setSelected(1);
                    continue;
                }
                part.setSelected(2);
            }
        }
        finally {
            this.m_selecting = null;
        }
        this.fireSelectionChanged();
    }

    @Override
    public void select(org.eclipse.wb.gef.core.EditPart part) {
        Assert.isNotNull((Object)((Object)part));
        if (this.m_selectionList.size() != 1 || this.m_selectionList.get(0) != part) {
            try {
                this.m_selectionList.add(part);
                this.m_selecting = part;
                this.internalDeselectAll();
                this.appendSelection(part);
            }
            finally {
                this.m_selecting = null;
            }
        }
    }

    @Override
    public void deselect(org.eclipse.wb.gef.core.EditPart part) {
        Assert.isNotNull((Object)((Object)part));
        this.m_selectionList.remove((Object)part);
        part.setSelected(0);
        if (!this.m_selectionList.isEmpty()) {
            org.eclipse.wb.gef.core.EditPart primary = this.m_selectionList.get(this.m_selectionList.size() - 1);
            primary.setSelected(2);
        }
        this.fireSelectionChanged();
    }

    @Override
    public void deselect(List<org.eclipse.wb.gef.core.EditPart> editParts) {
        for (org.eclipse.wb.gef.core.EditPart part : editParts) {
            Assert.isNotNull((Object)((Object)part));
            this.m_selectionList.remove((Object)part);
            part.setSelected(0);
        }
        if (!this.m_selectionList.isEmpty()) {
            org.eclipse.wb.gef.core.EditPart primary = this.m_selectionList.get(this.m_selectionList.size() - 1);
            primary.setSelected(2);
        }
        this.fireSelectionChanged();
    }

    @Override
    public void deselectAll() {
        this.internalDeselectAll();
        this.fireSelectionChanged();
    }

    private void internalDeselectAll() {
        List<org.eclipse.wb.gef.core.EditPart> selectionList = this.m_selectionList;
        this.m_selectionList = new ArrayList<org.eclipse.wb.gef.core.EditPart>();
        for (org.eclipse.wb.gef.core.EditPart part : selectionList) {
            part.setSelected(0);
        }
    }

    @Override
    public List<org.eclipse.wb.gef.core.EditPart> getSelectedEditParts() {
        return this.m_selectionList;
    }

    @Override
    public org.eclipse.wb.gef.core.EditPart getSelectingEditPart() {
        return this.m_selecting;
    }

    private EventListenerList getEnsureEventTable() {
        if (this.m_eventTable == null) {
            this.m_eventTable = new EventListenerList();
        }
        return this.m_eventTable;
    }

    private <T> Iterator<T> getListeners(Class<T> listenerClass) {
        return this.m_eventTable == null ? null : this.m_eventTable.getListeners(listenerClass);
    }

    public org.eclipse.wb.gef.core.EditPart findObjectAtExcluding(Point location, Collection<IFigure> exclusionSet, EditPartViewer.Conditional conditional) {
        return null;
    }

    public Control createControl(Composite parent) {
        return null;
    }
}

