/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.draw2d;

import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.draw2d.EventManager;
import org.eclipse.wb.internal.draw2d.RootFigure;

public class FigureCanvas
extends org.eclipse.draw2d.FigureCanvas {
    private RootFigure m_rootFigure;
    private final Dimension m_rootPreferredSize = new Dimension();
    @Deprecated
    private Image m_bufferedImage;
    private boolean m_drawCached;

    public FigureCanvas(Composite parent, int style) {
        super(parent, style | 0x40000 | 0x100000, FigureCanvas.createLightweightSystem());
        this.hookControlEvents();
        this.createRootFigure();
    }

    private void createRootFigure() {
        this.m_rootFigure = new RootFigure(this);
        this.m_rootFigure.setBackgroundColor(this.getBackground());
        this.m_rootFigure.setForegroundColor(this.getForeground());
        this.m_rootFigure.setFont(this.getFont());
        this.setDefaultEventManager();
        this.setContents((IFigure)this.m_rootFigure);
    }

    private static LightweightSystem createLightweightSystem() {
        return new LightweightSystem(){

            private FigureCanvas getFigureCanvas() {
                return (FigureCanvas)((Object)ReflectionUtils.getFieldObject((Object)this, "canvas"));
            }

            protected void controlResized() {
                this.getFigureCanvas().disposeBufferedImage();
                super.controlResized();
            }

            public void paint(GC gc) {
                Rectangle bounds = gc.getClipping();
                this.getFigureCanvas().handlePaint(gc, bounds.x, bounds.y, bounds.width, bounds.height);
            }
        };
    }

    protected void setDefaultEventManager() {
        this.m_rootFigure.getFigureCanvas().getLightweightSystem().setEventDispatcher((EventDispatcher)new EventManager(this));
    }

    private void disposeBufferedImage() {
        if (this.m_bufferedImage != null) {
            this.m_bufferedImage.dispose();
            this.m_bufferedImage = null;
        }
    }

    public RootFigure getRootFigure() {
        return this.m_rootFigure;
    }

    public void setDrawCached(boolean value) {
        this.m_drawCached = value;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Dimension size = this.m_rootFigure.getPreferredSize().getUnioned(wHint, hHint);
        return new Point(size.width, size.height);
    }

    private void hookControlEvents() {
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                FigureCanvas.this.disposeBufferedImage();
            }
        });
    }

    private void handlePaint(GC paintGC, int x, int y, int width, int height) {
        if (this.m_drawCached) {
            if (this.m_bufferedImage == null) {
                paintGC.fillRectangle(x, y, width, height);
            } else {
                paintGC.drawImage(this.m_bufferedImage, 0, 0);
            }
            return;
        }
        if (this.m_bufferedImage == null) {
            Point size = this.getSize();
            this.m_bufferedImage = new Image(null, size.x, size.y);
        }
        GC bufferedGC = new GC((Drawable)this.m_bufferedImage);
        try {
            bufferedGC.setClipping(x, y, width, height);
            bufferedGC.setBackground(paintGC.getBackground());
            bufferedGC.setForeground(paintGC.getForeground());
            bufferedGC.setFont(paintGC.getFont());
            bufferedGC.setLineStyle(paintGC.getLineStyle());
            bufferedGC.setLineWidth(paintGC.getLineWidth());
            bufferedGC.setXORMode(paintGC.getXORMode());
            SWTGraphics graphics = new SWTGraphics(bufferedGC);
            int dx = -this.getViewport().getHorizontalRangeModel().getValue();
            int dy = -this.getViewport().getVerticalRangeModel().getValue();
            graphics.translate(dx, dy);
            this.m_rootFigure.paint((Graphics)graphics);
        }
        finally {
            bufferedGC.dispose();
        }
        paintGC.drawImage(this.m_bufferedImage, 0, 0);
    }

    public void handleRefresh(int x, int y, int width, int height) {
        if (this.m_rootPreferredSize.equals((Object)this.m_rootFigure.getPreferredSize())) {
            Point size = this.getSize();
            org.eclipse.draw2d.geometry.Rectangle paintArea = new org.eclipse.draw2d.geometry.Rectangle(0, 0, size.x, size.y);
            paintArea.intersect(new org.eclipse.draw2d.geometry.Rectangle(x, y, width, height));
            this.redraw(paintArea.x, paintArea.y, paintArea.width, paintArea.height, true);
        } else {
            Rectangle clientArea = this.getClientArea();
            org.eclipse.draw2d.geometry.Rectangle bounds = new org.eclipse.draw2d.geometry.Rectangle(clientArea).setLocation(0, 0);
            this.m_rootFigure.setBounds(bounds);
            this.getViewport().setBounds(bounds);
            this.getViewport().revalidate();
            this.redraw();
        }
    }
}

