/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.actions.errors;

import java.util.List;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.actions.errors.IErrorPage;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public final class WarningsErrorPage
implements IErrorPage {
    private AstEditor m_editor;
    private List<EditorWarning> m_collection;
    private org.eclipse.swt.widgets.List m_nodesList;
    private Browser m_browser;

    public String getTitle() {
        return Messages.WarningsErrorPage_title;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRoot(ObjectInfo rootObject) {
        ObjectInfo objectInfo = rootObject;
        if (objectInfo instanceof JavaInfo) {
            void javaInfo;
            JavaInfo javaInfo2 = (JavaInfo)objectInfo;
            JavaInfo cfr_ignored_0 = (JavaInfo)objectInfo;
            this.m_editor = javaInfo.getEditor();
            EditorState editorState = EditorState.get(this.m_editor);
            this.m_collection = editorState.getWarnings();
        } else {
            this.m_collection = null;
        }
    }

    public final boolean hasErrors() {
        return this.m_collection != null && !this.m_collection.isEmpty();
    }

    public final Control create(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.create((Composite)container);
        Group group = new Group(container, 0);
        GridDataFactory.create((Control)group).grabH().fill();
        GridLayoutFactory.create((Composite)group);
        group.setText(Messages.WarningsErrorPage_listLabel);
        this.m_nodesList = new org.eclipse.swt.widgets.List((Composite)group, 2560);
        GridDataFactory.create((Control)this.m_nodesList).hintC(100, 10).grab().fill();
        if (this.m_collection != null) {
            for (EditorWarning warning : this.m_collection) {
                try {
                    this.m_nodesList.add(warning.getMessage());
                }
                catch (Throwable e) {
                    DesignerPlugin.log((Throwable)e);
                }
            }
        }
        this.m_nodesList.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                WarningsErrorPage.this.showException();
            }
        });
        group = new Group(container, 0);
        GridDataFactory.create((Control)group).grab().fill();
        GridLayoutFactory.create((Composite)group);
        group.setText(Messages.WarningsErrorPage_singleLabel);
        this.m_browser = new Browser((Composite)group, 2048);
        GridDataFactory.create((Control)this.m_browser).hintC(100, 15).grab().fill();
        if (this.m_nodesList.getItemCount() != 0) {
            this.m_nodesList.select(0);
            this.showException();
        }
        return container;
    }

    private void showException() {
        try {
            int index = this.m_nodesList.getSelectionIndex();
            EditorWarning warning = this.m_collection.get(index);
            String html = DesignerExceptionUtils.getExceptionHTML0((String)warning.getMessage(), (Throwable)warning.getException());
            this.m_browser.setText(html);
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
        }
    }
}

