
package org.eclipse.wb.core.databinding.xsd.component;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for PropertyCategory.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>
 * &lt;simpleType name="PropertyCategory"&gt;
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *     &lt;enumeration value="preferred"/&gt;
 *     &lt;enumeration value="normal"/&gt;
 *     &lt;enumeration value="advanced"/&gt;
 *     &lt;enumeration value="hidden"/&gt;
 *   &lt;/restriction&gt;
 * &lt;/simpleType&gt;
 * </pre>
 * 
 */
@XmlType(name = "PropertyCategory", namespace = "http://www.eclipse.org/wb/WBPComponent")
@XmlEnum
public enum PropertyCategory {

    @XmlEnumValue("preferred")
    PREFERRED("preferred"),
    @XmlEnumValue("normal")
    NORMAL("normal"),
    @XmlEnumValue("advanced")
    ADVANCED("advanced"),
    @XmlEnumValue("hidden")
    HIDDEN("hidden");
    private final String value;

    PropertyCategory(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static PropertyCategory fromValue(String v) {
        for (PropertyCategory c: PropertyCategory.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
