/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.theme;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.grammar.ScopeStack;
import org.eclipse.tm4e.core.internal.theme.ColorMap;
import org.eclipse.tm4e.core.internal.theme.ParsedThemeRule;
import org.eclipse.tm4e.core.internal.theme.StyleAttributes;
import org.eclipse.tm4e.core.internal.theme.ThemeTrieElement;
import org.eclipse.tm4e.core.internal.theme.ThemeTrieElementRule;
import org.eclipse.tm4e.core.internal.theme.raw.IRawTheme;
import org.eclipse.tm4e.core.internal.theme.raw.IRawThemeSetting;
import org.eclipse.tm4e.core.internal.theme.raw.IThemeSetting;
import org.eclipse.tm4e.core.internal.utils.MoreCollections;
import org.eclipse.tm4e.core.internal.utils.StringUtils;

public final class Theme {
    private final Map<String, List<ThemeTrieElementRule>> _cachedMatchRoot = new HashMap<String, List<ThemeTrieElementRule>>();
    private final ColorMap _colorMap;
    private final StyleAttributes _defaults;
    private final ThemeTrieElement _root;
    private Map<String, String> editorColors = Collections.emptyMap();

    public static Theme createFromRawTheme(@Nullable IRawTheme source, @Nullable List<String> colorMap) {
        Theme theme = Theme.createFromParsedTheme(Theme.parseTheme(source), colorMap);
        if (source != null) {
            theme.editorColors = source.getEditorColors();
        }
        return theme;
    }

    public static Theme createFromParsedTheme(List<ParsedThemeRule> source, @Nullable List<String> colorMap) {
        return Theme.resolveParsedThemeRules(source, colorMap);
    }

    public Theme(ColorMap colorMap, StyleAttributes defaults, ThemeTrieElement root) {
        this._colorMap = colorMap;
        this._root = root;
        this._defaults = defaults;
    }

    public List<String> getColorMap() {
        return this._colorMap.getColorMap();
    }

    public StyleAttributes getDefaults() {
        return this._defaults;
    }

    public Map<String, String> getEditorColors() {
        return this.editorColors;
    }

    public @Nullable StyleAttributes match(@Nullable ScopeStack scopePath) {
        if (scopePath == null) {
            return this._defaults;
        }
        String scopeName = scopePath.scopeName;
        List matchingTrieElements = this._cachedMatchRoot.computeIfAbsent(scopeName, this._root::match);
        ThemeTrieElementRule effectiveRule = MoreCollections.findFirstMatching(matchingTrieElements, v -> this._scopePathMatchesParentScopes(scopeStack.parent, v.parentScopes));
        if (effectiveRule == null) {
            return null;
        }
        return StyleAttributes.of(effectiveRule.fontStyle, effectiveRule.foreground, effectiveRule.background);
    }

    private boolean _scopePathMatchesParentScopes(@Nullable ScopeStack scopePath, @Nullable List<String> parentScopeNames) {
        if (parentScopeNames == null) {
            return true;
        }
        int index = 0;
        String scopePattern = parentScopeNames.get(index);
        while (scopePath != null) {
            if (this._matchesScope(scopePath.scopeName, scopePattern)) {
                if (++index == parentScopeNames.size()) {
                    return true;
                }
                scopePattern = parentScopeNames.get(index);
            }
            scopePath = scopePath.parent;
        }
        return false;
    }

    private boolean _matchesScope(String scopeName, String scopeNamePattern) {
        return scopeNamePattern.equals(scopeName) || scopeName.startsWith(scopeNamePattern) && scopeName.charAt(scopeNamePattern.length()) == '.';
    }

    /*
     * WARNING - void declaration
     */
    public static List<ParsedThemeRule> parseTheme(@Nullable IRawTheme source) {
        if (source == null) {
            return Collections.emptyList();
        }
        Collection<IRawThemeSetting> settings = source.getSettings();
        if (settings == null) {
            return Collections.emptyList();
        }
        ArrayList<ParsedThemeRule> result = new ArrayList<ParsedThemeRule>();
        int i = -1;
        for (IRawThemeSetting entry : settings) {
            int fontStyle;
            List<String> scopes;
            IThemeSetting entrySetting;
            block28: {
                String[] segments;
                entrySetting = entry.getSetting();
                if (entrySetting == null) continue;
                ++i;
                Object settingScope = entry.getScope();
                Object object = settingScope;
                if (object instanceof String) {
                    String _scope;
                    String cfr_ignored_0 = (String)object;
                    String cfr_ignored_1 = (String)object;
                    _scope = _scope.replaceAll("^,+", "");
                    _scope = _scope.replaceAll(",+$", "");
                    scopes = StringUtils.splitToList(_scope, ',');
                } else {
                    List<String> settingScopes;
                    scopes = settingScope instanceof List ? (settingScopes = (List<String>)settingScope) : List.of("");
                }
                fontStyle = -1;
                String settingsFontStyle = entrySetting.getFontStyle();
                if (settingsFontStyle == null) break block28;
                fontStyle = 0;
                String[] stringArray = segments = StringUtils.splitToArray(settingsFontStyle, ' ');
                int n = segments.length;
                int n2 = 0;
                while (n2 < n) {
                    String segment;
                    switch (segment = stringArray[n2]) {
                        case "italic": {
                            fontStyle |= 1;
                            break;
                        }
                        case "bold": {
                            fontStyle |= 2;
                            break;
                        }
                        case "underline": {
                            fontStyle |= 4;
                            break;
                        }
                        case "strikethrough": {
                            fontStyle |= 8;
                        }
                    }
                    ++n2;
                }
            }
            String foreground = null;
            String settingsForeground = entrySetting.getForeground();
            String string = settingsForeground;
            if (string instanceof String) {
                void stringSettingsForeground;
                if (StringUtils.isValidHexColor((CharSequence)stringSettingsForeground)) {
                    foreground = stringSettingsForeground;
                }
            }
            String background = null;
            String settingsBackground = entrySetting.getBackground();
            String string2 = settingsBackground;
            if (string2 instanceof String) {
                void stringSettingsBackground;
                if (StringUtils.isValidHexColor((CharSequence)stringSettingsBackground)) {
                    background = stringSettingsBackground;
                }
            }
            int j = 0;
            int lenJ = scopes.size();
            while (j < lenJ) {
                String _scope = scopes.get(j).trim();
                List<String> segments = StringUtils.splitToList(_scope, ' ');
                String scope = MoreCollections.getLastElement(segments);
                ArrayList<String> parentScopes = null;
                if (segments.size() > 1) {
                    parentScopes = new ArrayList<String>(segments.subList(0, segments.size() - 1));
                    Collections.reverse(parentScopes);
                }
                result.add(new ParsedThemeRule(scope, parentScopes, i, fontStyle, foreground, background));
                ++j;
            }
        }
        return result;
    }

    public static Theme resolveParsedThemeRules(List<ParsedThemeRule> _parsedThemeRules, @Nullable List<String> _colorMap) {
        ArrayList<ParsedThemeRule> parsedThemeRules = new ArrayList<ParsedThemeRule>(_parsedThemeRules);
        parsedThemeRules.sort((a, b) -> {
            int r = StringUtils.strcmp(a.scope, b.scope);
            if (r != 0) {
                return r;
            }
            r = StringUtils.strArrCmp(a.parentScopes, b.parentScopes);
            if (r != 0) {
                return r;
            }
            return a.index - b.index;
        });
        int defaultFontStyle = 0;
        String defaultForeground = "#000000";
        String defaultBackground = "#ffffff";
        while (!parsedThemeRules.isEmpty() && parsedThemeRules.get((int)0).scope.isEmpty()) {
            ParsedThemeRule incomingDefaults = parsedThemeRules.remove(0);
            if (incomingDefaults.fontStyle != -1) {
                defaultFontStyle = incomingDefaults.fontStyle;
            }
            if (incomingDefaults.foreground != null) {
                defaultForeground = incomingDefaults.foreground;
            }
            if (incomingDefaults.background == null) continue;
            defaultBackground = incomingDefaults.background;
        }
        ColorMap colorMap = new ColorMap(_colorMap);
        StyleAttributes defaults = StyleAttributes.of(defaultFontStyle, colorMap.getId(defaultForeground), colorMap.getId(defaultBackground));
        ThemeTrieElement root = new ThemeTrieElement(new ThemeTrieElementRule(0, null, -1, 0, 0), Collections.emptyList());
        int i = 0;
        int len = parsedThemeRules.size();
        while (i < len) {
            ParsedThemeRule rule = parsedThemeRules.get(i);
            root.insert(0, rule.scope, rule.parentScopes, rule.fontStyle, colorMap.getId(rule.foreground), colorMap.getId(rule.background));
            ++i;
        }
        return new Theme(colorMap, defaults, root);
    }

    public int hashCode() {
        int result = 31 + this._colorMap.hashCode();
        result = 31 * result + this._defaults.hashCode();
        return 31 * result + this._root.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        Object object = obj;
        if (object instanceof Theme) {
            void other;
            Theme theme = (Theme)object;
            Theme cfr_ignored_0 = (Theme)object;
            return Objects.equals(this._colorMap, other._colorMap) && Objects.equals(this._defaults, other._defaults) && Objects.equals(this._root, other._root);
        }
        return false;
    }
}

