/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.PerspectiveAction;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.SavePerspectiveDialog;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;

public class SavePerspectiveAction
extends PerspectiveAction {
    public SavePerspectiveAction(IWorkbenchWindow window) {
        super(window);
        this.setText(WorkbenchMessages.get().SavePerspective_text);
        this.setActionDefinitionId("org.eclipse.ui.window.savePerspective");
        this.setToolTipText(WorkbenchMessages.get().SavePerspective_toolTip);
        window.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.rap.ui.save_perspective_action_context");
    }

    @Override
    protected void run(IWorkbenchPage page, IPerspectiveDescriptor persp) {
        PerspectiveDescriptor desc = (PerspectiveDescriptor)persp;
        if (desc != null) {
            if (desc.isSingleton()) {
                this.saveSingleton(page);
            } else {
                this.saveNonSingleton(page, desc);
            }
        }
    }

    private void saveSingleton(IWorkbenchPage page) {
        String[] buttons = new String[]{IDialogConstants.get().OK_LABEL, IDialogConstants.get().CANCEL_LABEL};
        MessageDialog d = new MessageDialog(page.getWorkbenchWindow().getShell(), WorkbenchMessages.get().SavePerspective_overwriteTitle, null, WorkbenchMessages.get().SavePerspective_singletonQuestion, 3, buttons, 0);
        if (d.open() == 0) {
            page.savePerspective();
        }
    }

    private void saveNonSingleton(IWorkbenchPage page, PerspectiveDescriptor oldDesc) {
        String name;
        PerspectiveRegistry reg = (PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        SavePerspectiveDialog dlg = new SavePerspectiveDialog(page.getWorkbenchWindow().getShell(), reg);
        IPerspectiveDescriptor description = reg.findPerspectiveWithId(oldDesc.getId());
        dlg.setInitialSelection(description);
        if (dlg.open() != 0) {
            return;
        }
        PerspectiveDescriptor newDesc = (PerspectiveDescriptor)dlg.getPersp();
        if (newDesc == null && (newDesc = reg.createPerspective(name = dlg.getPerspName(), (PerspectiveDescriptor)description)) == null) {
            MessageDialog.openError((Shell)dlg.getShell(), (String)WorkbenchMessages.get().SavePerspective_errorTitle, (String)WorkbenchMessages.get().SavePerspective_errorMessage);
            return;
        }
        page.savePerspectiveAs(newDesc);
    }
}

