/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiBaselineManager;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiToolsLabelProvider;
import org.eclipse.pde.api.tools.ui.internal.IApiToolsHelpContextIds;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.preferences.ApiBaselinesConfigurationBlock;
import org.eclipse.pde.api.tools.ui.internal.preferences.PreferenceMessages;
import org.eclipse.pde.api.tools.ui.internal.wizards.ApiBaselineWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class ApiBaselinePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String DATA_SELECT_OPTION_KEY = "select_option_key";
    public static final String MISSING_BASELINE_OPTION = "MISSING_BASELINE_OPTION";
    public static final String MISSING_PLUGIN_IN_BASELINE_OPTION = "MISSING_PLUGIN_IN_BASELINE_OPTION";
    public static final String ID = "org.eclipse.pde.api.tools.ui.apiprofiles.prefpage";
    IApiBaselineManager manager = ApiPlugin.getDefault().getApiBaselineManager();
    private static HashSet<String> removed = new HashSet(8);
    CheckboxTableViewer tableviewer = null;
    ArrayList<IApiBaseline> backingcollection = new ArrayList(8);
    String newdefault = null;
    private Button newbutton = null;
    Button removebutton = null;
    Button editbutton = null;
    protected static int rebuildcount = 0;
    String origdefault = null;
    boolean dirty = false;
    private boolean defaultcontentchanged = false;
    boolean defaultchanged = false;
    private ApiBaselinesConfigurationBlock block = null;

    protected Control createContents(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 1808, 0, 0);
        SWTFactory.createWrapLabel(comp, PreferenceMessages.ApiProfilesPreferencePage_0, 2, 200);
        SWTFactory.createVerticalSpacer(comp, 1);
        Composite lcomp = SWTFactory.createComposite(comp, 2, 1, 1808, 0, 0);
        SWTFactory.createWrapLabel(lcomp, PreferenceMessages.ApiProfilesPreferencePage_1, 2);
        Table table = new Table(lcomp, 67618);
        table.setLayoutData((Object)new GridData(1808));
        table.addKeyListener(KeyListener.keyReleasedAdapter(e -> {
            if (e.stateMask == 0 && e.keyCode == 127) {
                this.doRemove();
            }
        }));
        this.tableviewer = new CheckboxTableViewer(table);
        this.tableviewer.setUseHashlookup(true);
        this.tableviewer.setLabelProvider((IBaseLabelProvider)new BaselineLabelProvider());
        this.tableviewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableviewer.addDoubleClickListener(event -> {
            IStructuredSelection ss = (IStructuredSelection)event.getSelection();
            this.doEdit((IApiBaseline)ss.getFirstElement());
        });
        this.tableviewer.addSelectionChangedListener(event -> {
            IApiBaseline[] state = this.getCurrentSelection();
            this.removebutton.setEnabled(state.length > 0);
            this.editbutton.setEnabled(state.length == 1);
        });
        this.tableviewer.addCheckStateListener(event -> {
            IApiBaseline baseline = (IApiBaseline)event.getElement();
            boolean checked = event.getChecked();
            if (checked) {
                this.tableviewer.setCheckedElements(new Object[]{baseline});
                this.newdefault = baseline.getName();
                this.defaultchanged = !this.newdefault.equals(this.origdefault);
            } else {
                this.tableviewer.setChecked((Object)baseline, checked);
                this.newdefault = null;
                this.manager.setDefaultApiBaseline(null);
                this.defaultchanged = true;
            }
            rebuildcount = 0;
            this.tableviewer.refresh(true);
            this.dirty = true;
        });
        this.tableviewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((IApiBaseline)e1).getName().compareTo(((IApiBaseline)e2).getName());
            }
        });
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), () -> {
            this.backingcollection.addAll(Arrays.asList(this.manager.getApiBaselines()));
            this.tableviewer.setInput(this.backingcollection);
        });
        Composite bcomp = SWTFactory.createComposite(lcomp, 1, 1, 1042, 0, 0);
        this.newbutton = SWTFactory.createPushButton(bcomp, PreferenceMessages.ApiProfilesPreferencePage_2, null);
        this.newbutton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            IApiBaseline profile;
            ApiBaselineWizard wizard = new ApiBaselineWizard(null);
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            if (dialog.open() == 0 && (profile = wizard.getProfile()) != null) {
                this.backingcollection.add(profile);
                this.tableviewer.refresh();
                this.tableviewer.setSelection((ISelection)new StructuredSelection((Object)profile), true);
                if (this.backingcollection.size() == 1) {
                    this.newdefault = profile.getName();
                    this.tableviewer.setCheckedElements(new Object[]{profile});
                    this.tableviewer.refresh((Object)profile);
                    this.defaultchanged = true;
                    rebuildcount = 0;
                }
                this.dirty = true;
            }
        }));
        this.editbutton = SWTFactory.createPushButton(bcomp, PreferenceMessages.ApiProfilesPreferencePage_4, null);
        this.editbutton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.doEdit(this.getCurrentSelection()[0])));
        this.editbutton.setEnabled(false);
        this.removebutton = SWTFactory.createPushButton(bcomp, PreferenceMessages.ApiProfilesPreferencePage_3, null);
        this.removebutton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.doRemove()));
        this.removebutton.setEnabled(false);
        SWTFactory.createVerticalSpacer(bcomp, 1);
        IApiBaseline baseline = this.manager.getDefaultApiBaseline();
        if (baseline != null) {
            this.tableviewer.setCheckedElements(new Object[]{baseline});
        }
        this.newdefault = baseline == null ? null : baseline.getName();
        this.origdefault = this.newdefault;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IApiToolsHelpContextIds.APIBASELINE_PREF_PAGE);
        this.block = new ApiBaselinesConfigurationBlock((IWorkbenchPreferenceContainer)this.getContainer());
        this.block.createControl(comp);
        Dialog.applyDialogFont((Control)comp);
        return comp;
    }

    public static boolean isRemovedBaseline(String name) {
        return removed.contains(name);
    }

    protected void doRemove() {
        IApiBaseline[] states;
        IApiBaseline[] iApiBaselineArray = states = this.getCurrentSelection();
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            IApiBaseline state = iApiBaselineArray[n2];
            if (this.isDefault(state)) {
                this.newdefault = null;
                this.manager.setDefaultApiBaseline(null);
                this.defaultchanged = true;
                rebuildcount = 0;
            }
            removed.add(state.getName());
            ++n2;
        }
        if (this.backingcollection.removeAll(Arrays.asList(states))) {
            this.dirty = true;
        }
        this.tableviewer.refresh();
    }

    protected void doEdit(IApiBaseline baseline) {
        IApiBaseline newbaseline;
        ApiBaselineWizard wizard = new ApiBaselineWizard(baseline);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (dialog.open() == 0 && (newbaseline = wizard.getProfile()) != null) {
            removed.add(baseline.getName());
            this.backingcollection.remove(baseline);
            this.backingcollection.add(newbaseline);
            this.tableviewer.refresh();
            if (this.isDefault(baseline)) {
                this.tableviewer.setSelection((ISelection)new StructuredSelection((Object)newbaseline), true);
                this.tableviewer.setCheckedElements(new Object[]{newbaseline});
                this.newdefault = newbaseline.getName();
                rebuildcount = 0;
                this.defaultcontentchanged = wizard.contentChanged();
                this.tableviewer.refresh(true);
            }
            this.dirty = true;
        }
    }

    protected boolean isDefault(Object element) {
        if (element instanceof IApiBaseline) {
            IApiBaseline profile = (IApiBaseline)element;
            if (this.newdefault == null) {
                IApiBaseline def = ApiPlugin.getDefault().getApiBaselineManager().getDefaultApiBaseline();
                if (def != null) {
                    return profile.getName().equals(def.getName());
                }
            } else {
                return profile.getName().equals(this.newdefault);
            }
        }
        return false;
    }

    protected IApiBaseline[] getCurrentSelection() {
        IStructuredSelection ss = this.tableviewer.getStructuredSelection();
        if (ss.isEmpty()) {
            return new IApiBaseline[0];
        }
        return this.tableviewer.getStructuredSelection().toList().toArray(new IApiBaseline[ss.size()]);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performCancel() {
        this.manager.setDefaultApiBaseline(this.origdefault);
        this.backingcollection.clear();
        removed.clear();
        if (this.block != null) {
            this.block.performCancel();
        }
        return super.performCancel();
    }

    protected void applyChanges() {
        if (!this.dirty) {
            return;
        }
        for (String string : removed) {
            this.manager.removeApiBaseline(string);
        }
        for (IApiBaseline iApiBaseline : this.backingcollection) {
            this.manager.addApiBaseline(iApiBaseline);
        }
        this.manager.setDefaultApiBaseline(this.newdefault);
        if (this.defaultchanged && this.newdefault == null && this.origdefault != null) {
            this.findAndDeleteCompatibilityMarkers();
            Object[] checkedElements = this.tableviewer.getCheckedElements();
            this.block.setHasBaseline(checkedElements.length != 0);
            this.block.createMissingBaselineMarker();
            this.origdefault = this.newdefault;
            this.dirty = false;
            this.defaultcontentchanged = false;
            this.defaultchanged = false;
            removed.clear();
            return;
        }
        if ((this.defaultchanged || this.defaultcontentchanged) && rebuildcount < 1) {
            int open;
            ++rebuildcount;
            IProject[] projects = Util.getApiProjects();
            if (projects != null && (open = MessageDialog.open((int)3, (Shell)this.getShell(), (String)PreferenceMessages.ApiProfilesPreferencePage_QuestionDialog_Title, (String)PreferenceMessages.ApiProfilesPreferencePage_QuestionDialog_Text, (int)0, (String[])new String[]{PreferenceMessages.ApiProfilesPreferencePage_QuestionDialog_buildButtonLabel, PreferenceMessages.ApiProfilesPreferencePage_QuestionDialog_dontBuildButtonLabel})) == 0) {
                Util.getBuildJob((IProject[])projects).schedule();
            }
        }
        this.origdefault = this.newdefault;
        this.dirty = false;
        this.defaultcontentchanged = false;
        this.defaultchanged = false;
        removed.clear();
    }

    private void findAndDeleteCompatibilityMarkers() {
        IProject[] apiProjects = Util.getApiProjects();
        if (apiProjects == null) {
            return;
        }
        IProject[] iProjectArray = apiProjects;
        int n = apiProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            this.cleanupCompatibilityMarkers((IResource)iProject);
            try {
                iProject.deleteMarkers("org.eclipse.pde.api.tools.unused_filters", false, 2);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
    }

    void cleanupCompatibilityMarkers(IResource resource) {
        try {
            if (resource != null && resource.isAccessible()) {
                resource.deleteMarkers("org.eclipse.pde.api.tools.compatibility", false, 2);
                resource.deleteMarkers("org.eclipse.pde.api.tools.marker.sincetags", false, 2);
                if (resource.getType() == 4) {
                    resource.deleteMarkers("org.eclipse.pde.api.tools.version_numbering", false, 2);
                    resource.deleteMarkers("org.eclipse.pde.api.tools.api_profile", true, 0);
                    resource.deleteMarkers("org.eclipse.pde.api.tools.api_component_resolution", true, 0);
                }
            }
        }
        catch (CoreException e) {
            ApiPlugin.log((IStatus)e.getStatus());
        }
    }

    public boolean performOk() {
        Object[] checkedElements = this.tableviewer.getCheckedElements();
        this.block.setHasBaseline(checkedElements.length != 0);
        this.block.performOK();
        this.applyChanges();
        return true;
    }

    protected void performApply() {
        this.block.performApply();
        this.applyChanges();
    }

    protected void performDefaults() {
        this.block.performDefaults();
        this.applyChanges();
    }

    public void applyData(Object data) {
        Map pageData;
        Object key;
        if (data instanceof Map && (key = (pageData = (Map)data).get(DATA_SELECT_OPTION_KEY)) instanceof String) {
            String option = (String)key;
            if (option.equals(MISSING_BASELINE_OPTION)) {
                this.block.selectOption(0);
            }
            if (option.equals(MISSING_PLUGIN_IN_BASELINE_OPTION)) {
                this.block.selectOption(1);
            }
        }
    }

    class BaselineLabelProvider
    extends ApiToolsLabelProvider {
        BaselineLabelProvider() {
        }

        @Override
        protected boolean isDefaultBaseline(Object element) {
            return ApiBaselinePreferencePage.this.isDefault(element);
        }
    }
}

