/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.function.BiConsumer;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;

public class OpenViewRequest
extends CDOClientRequest<CDOBranchPoint> {
    private final int viewID;
    private final boolean readOnly;
    private final CDOBranchPoint branchPoint;
    private final String durableLockingID;
    private final BiConsumer<CDOID, IDurableLockingManager.LockGrade> consumer;

    public OpenViewRequest(CDOClientProtocol protocol, int viewID, boolean readOnly, CDOBranchPoint branchPoint) {
        super(protocol, (short)3);
        this.viewID = viewID;
        this.readOnly = readOnly;
        this.branchPoint = branchPoint;
        this.durableLockingID = null;
        this.consumer = null;
    }

    public OpenViewRequest(CDOClientProtocol protocol, int viewID, boolean readOnly, String durableLockingID, BiConsumer<CDOID, IDurableLockingManager.LockGrade> consumer) {
        super(protocol, (short)3);
        this.viewID = viewID;
        this.readOnly = readOnly;
        this.durableLockingID = durableLockingID;
        this.consumer = consumer;
        this.branchPoint = null;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeXInt(this.viewID);
        out.writeBoolean(this.readOnly);
        if (this.branchPoint != null) {
            out.writeBoolean(true);
            out.writeCDOBranchPoint(this.branchPoint);
        } else {
            out.writeBoolean(false);
            out.writeString(this.durableLockingID);
            out.writeBoolean(this.consumer != null);
        }
    }

    @Override
    protected CDOBranchPoint confirming(CDODataInput in) throws IOException {
        if (in.readBoolean()) {
            CDOBranchPoint branchPoint = in.readCDOBranchPoint();
            if (this.consumer != null) {
                CDOID id;
                while (!CDOIDUtil.isNull((CDOID)(id = in.readCDOID()))) {
                    IDurableLockingManager.LockGrade lockGrade = (IDurableLockingManager.LockGrade)in.readEnum(IDurableLockingManager.LockGrade.class);
                    this.consumer.accept(id, lockGrade);
                }
            }
            return branchPoint;
        }
        if (this.durableLockingID != null) {
            String message = in.readString();
            if (message != null) {
                throw new IllegalStateException(message);
            }
            throw new IDurableLockingManager.LockAreaNotFoundException(this.durableLockingID);
        }
        return null;
    }

    protected String getAdditionalInfo() {
        String info = "readOnly=" + this.readOnly + ", branchPoint=" + this.branchPoint;
        if (this.durableLockingID != null) {
            info = String.valueOf(info) + ", durableLockingID=" + this.durableLockingID;
        }
        return info;
    }
}

