/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.parsers.sql;

import java.util.ArrayList;
import java.util.List;
import lpg.lpgjavaruntime.BadParseException;
import lpg.lpgjavaruntime.DiagnoseParser;
import lpg.lpgjavaruntime.ParseTable;
import lpg.lpgjavaruntime.PrsStream;
import lpg.lpgjavaruntime.Token;
import lpg.lpgjavaruntime.TokenStream;
import org.eclipse.datatools.sqltools.parsers.sql.AbstractSQLParser;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParseErrorInfo;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserLogger;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserMessages;

public class SQLParserException
extends Exception {
    private List errorInfoList;
    private int m_errorToken;
    private AbstractSQLParser m_parser;
    private ParseTable m_table;
    private static final String GENERAL_MESSAGE_KEY = "SQLParserException.GENERAL_MESSAGE";
    private static final String GENERAL_ERROR_CODE = "TODO: compute SQL error code";

    SQLParserException() {
    }

    public SQLParserException(String message, Throwable cause) {
        super(message, cause);
    }

    public SQLParserException(BadParseException e, AbstractSQLParser p_parser, ParseTable p_table) {
        super(SQLParserException.generateMessage(p_parser), (Throwable)e);
        this.m_errorToken = e.error_token;
        this.m_parser = p_parser;
        this.m_table = p_table;
        this.errorInfoList = this.m_parser.errorInfoList;
        if (this.errorInfoList == null) {
            this.errorInfoList = new ArrayList();
        }
        if (this.errorInfoList.isEmpty()) {
            int lineNumberStart = this.m_parser.getLine(this.error_token());
            int lineNumberEnd = this.m_parser.getEndLine(this.error_token());
            int columnNumberStart = this.m_parser.getColumn(this.error_token());
            int columnNumberEnd = this.m_parser.getEndColumn(this.error_token());
            String errorSourceText = this.m_parser.getTokenText(this.error_token());
            String expectedText = SQLParseErrorInfo.NO_CORRECTION_AVAILABLE;
            String errorMessage = SQLParserException.generateMessage(p_parser);
            SQLParseErrorInfo errorInfo = new SQLParseErrorInfo(lineNumberStart, columnNumberStart, lineNumberEnd, columnNumberEnd, errorSourceText, expectedText, errorMessage, GENERAL_ERROR_CODE);
            this.errorInfoList.add(0, errorInfo);
        }
    }

    private static String generateMessage(AbstractSQLParser p_parser) {
        String input = String.valueOf(p_parser.getInputChars());
        String message = SQLParserMessages.getString(GENERAL_MESSAGE_KEY, new String[]{input});
        return message;
    }

    protected int error_token() {
        return this.m_errorToken;
    }

    protected PrsStream getParseStream() {
        return this.m_parser;
    }

    protected ParseTable getParseTable() {
        return this.m_table;
    }

    public List getErrorInfoList() {
        return this.errorInfoList;
    }

    public void setErrorInfoList(List errorInfoList) {
        this.errorInfoList = errorInfoList;
    }

    public void printParseRuntimeException() {
        PrsStream prsStream = this.getParseStream();
        Token tok = (Token)prsStream.getTokens().get(this.error_token());
        SQLParserLogger.getLogger().writeInfo("Problem Token: kind=" + tok.getKind() + " val=" + tok.getValue(prsStream.getInputChars()));
        if (prsStream.getSize() - 2 > 0) {
            SQLParserLogger.getLogger().writeInfo("There were " + (prsStream.getSize() - 2) + " token(s).");
            prsStream.reset(this.error_token());
            DiagnoseParser diagnoseParser = new DiagnoseParser((TokenStream)prsStream, this.getParseTable());
            diagnoseParser.diagnose(this.error_token());
        }
        SQLParserLogger.getLogger().writeInfo("Parse error on: ");
        prsStream.dumpToken(this.error_token());
        this.printStackTrace();
        SQLParserLogger.getLogger().writeInfo("\n");
    }
}

