/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.cdt.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.internal.ui.actions.SelectionConverter;
import org.eclipse.cdt.internal.ui.cview.CView;
import org.eclipse.cdt.internal.ui.cview.ToggleLinkingAction;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.context.ui.AbstractAutoFocusViewAction;
import org.eclipse.mylyn.context.ui.InterestFilter;
import org.eclipse.mylyn.internal.cdt.ui.CDTDeclarationsFilter;
import org.eclipse.mylyn.internal.cdt.ui.CDTUiBridge;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;

public class FocusCViewAction
extends AbstractAutoFocusViewAction {
    public FocusCViewAction() {
        super(new InterestFilter(), true, true, true);
    }

    protected ISelection resolveSelection(IEditorPart part, ITextSelection changedSelection, StructuredViewer viewer) throws CoreException {
        ICElement element;
        ICElement elementToSelect = null;
        if (changedSelection instanceof TextSelection && part instanceof CEditor && (element = CDTUiBridge.getInputCElement((CEditor)part)) != null) {
            ICElement cdtElement;
            elementToSelect = cdtElement = SelectionConverter.getElementAtOffset((ICElement)element, (ITextSelection)changedSelection);
        }
        if (elementToSelect != null) {
            StructuredSelection currentSelection = (StructuredSelection)viewer.getSelection();
            if (currentSelection.size() <= 1) {
                for (ViewerFilter filter : Arrays.asList(viewer.getFilters())) {
                    if (!(filter instanceof CDTDeclarationsFilter) || !(elementToSelect instanceof IMethod)) continue;
                    elementToSelect = ((IMethod)elementToSelect).getTranslationUnit();
                }
            }
            return new StructuredSelection(elementToSelect);
        }
        return null;
    }

    protected void setManualFilteringAndLinkingEnabled(boolean enabled) {
        IViewPart part = super.getPartForAction();
        if (part instanceof CView) {
            ActionContributionItem actionItem;
            IContributionItem iContributionItem;
            IContributionItem item;
            IContributionItem[] iContributionItemArray = ((CView)part).getViewSite().getActionBars().getToolBarManager().getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                item = iContributionItemArray[n2];
                iContributionItem = item;
                if (iContributionItem instanceof ActionContributionItem) {
                    ActionContributionItem cfr_ignored_0 = (ActionContributionItem)iContributionItem;
                    ActionContributionItem cfr_ignored_1 = (ActionContributionItem)iContributionItem;
                    if (actionItem.getAction() instanceof ToggleLinkingAction) {
                        actionItem.getAction().setEnabled(enabled);
                    }
                }
                ++n2;
            }
            iContributionItemArray = ((CView)part).getViewSite().getActionBars().getMenuManager().getItems();
            n = iContributionItemArray.length;
            n2 = 0;
            while (n2 < n) {
                item = iContributionItemArray[n2];
                iContributionItem = item;
                if (iContributionItem instanceof ActionContributionItem) {
                    ActionContributionItem cfr_ignored_2 = (ActionContributionItem)iContributionItem;
                    ActionContributionItem cfr_ignored_3 = (ActionContributionItem)iContributionItem;
                    if (actionItem.getAction().getClass().getSimpleName().equals("ShowFilterDialogAction")) {
                        actionItem.getAction().setEnabled(enabled);
                    }
                }
                ++n2;
            }
        }
    }

    protected void setDefaultLinkingEnabled(boolean on) {
        IViewPart part = super.getPartForAction();
        if (part instanceof CView) {
            ((CView)part).setLinkingEnabled(on);
        }
    }

    protected boolean isDefaultLinkingEnabled() {
        IViewPart part = super.getPartForAction();
        if (part instanceof CView) {
            return ((CView)part).isLinkingEnabled();
        }
        return false;
    }

    public List<StructuredViewer> getViewers() {
        ArrayList<StructuredViewer> viewers = new ArrayList<StructuredViewer>();
        IViewPart part = super.getPartForAction();
        if (part instanceof CView) {
            viewers.add((StructuredViewer)((CView)part).getViewer());
        }
        return viewers;
    }
}

