/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.debug.application;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;

public class DebugRemoteExecutable {
    public static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public static ILaunchConfiguration createLaunchConfig(IProgressMonitor monitor, String buildLog, String executable, String address, String port, boolean attach) throws CoreException, InterruptedException {
        ILaunchConfiguration config = null;
        config = DebugRemoteExecutable.createConfiguration(executable, address, port, attach, true);
        monitor.worked(1);
        return config;
    }

    protected static ILaunchConfigurationType getLaunchConfigType(boolean attach) {
        return DebugRemoteExecutable.getLaunchManager().getLaunchConfigurationType(attach ? "org.eclipse.cdt.launch.attachLaunchType" : "org.eclipse.cdt.launch.remoteApplicationLaunchType");
    }

    protected static ILaunchConfiguration createConfiguration(String exePath, String address, String port, boolean attach, boolean save) {
        Object config = null;
        try {
            ILaunchConfigurationType configType = DebugRemoteExecutable.getLaunchConfigType(attach);
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, DebugRemoteExecutable.getLaunchManager().generateLaunchConfigurationName(attach ? "CDT_REMOTE_ATTACH" : "CDT_REMOTE"));
            wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", attach ? "remote_attach" : "remote");
            if (exePath != null && exePath.length() > 0) {
                wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", exePath);
            } else assert (attach);
            wc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "Executables");
            wc.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
            wc.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TCP", true);
            wc.setAttribute("org.eclipse.cdt.dsf.gdb.HOST", address);
            wc.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", port);
            config = save ? wc.doSave() : wc;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return config;
    }
}

