/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.views.actions;

import java.util.Iterator;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchShortcut;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.AntTargetNode;
import org.eclipse.ant.internal.ui.model.AntTaskNode;
import org.eclipse.ant.internal.ui.views.AntView;
import org.eclipse.ant.internal.ui.views.actions.AntViewActionMessages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IUpdate;

public class RunTargetAction
extends Action
implements IUpdate {
    private final AntView fView;

    public RunTargetAction(AntView view) {
        this.setText(AntViewActionMessages.RunTargetAction_Run_1);
        this.setImageDescriptor(AntUIImages.getImageDescriptor("org.eclipse.ant.ui.run"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ant.ui.run_target_action_context");
        this.setToolTipText(AntViewActionMessages.RunTargetAction_3);
        this.fView = view;
    }

    public void run() {
        this.run(this.getSelectedElement());
    }

    public void run(final AntElementNode selectedElement) {
        UIJob job = new UIJob(AntViewActionMessages.RunTargetAction_2){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                RunTargetAction.this.launch(selectedElement);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void launch(AntElementNode node) {
        AntLaunchShortcut shortcut = new AntLaunchShortcut();
        shortcut.setShowDialog(false);
        shortcut.launch(node, "run");
    }

    public void update() {
        AntElementNode selection = this.getSelectedElement();
        boolean enabled = false;
        if (selection instanceof AntTargetNode) {
            if (!((AntTargetNode)selection).isErrorNode()) {
                this.setToolTipText(AntViewActionMessages.RunTargetAction_4);
                enabled = true;
            }
        } else if (selection instanceof AntProjectNode) {
            if (!((AntProjectNode)selection).isErrorNode()) {
                enabled = true;
                this.setToolTipText(AntViewActionMessages.RunTargetAction_3);
            }
        } else if (selection instanceof AntTaskNode && !((AntTaskNode)selection).isErrorNode()) {
            enabled = true;
            this.setToolTipText(AntViewActionMessages.RunTargetAction_0);
        }
        this.setEnabled(enabled);
    }

    private AntElementNode getSelectedElement() {
        IStructuredSelection selection = (IStructuredSelection)this.fView.getViewer().getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        Iterator iter = selection.iterator();
        Object data = iter.next();
        if (iter.hasNext()) {
            return null;
        }
        return (AntElementNode)data;
    }
}

