/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.order;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.order.MethodOrder;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public abstract class MethodOrderChildren
extends MethodOrder {
    private final String[] m_childrenTypeNames;

    public MethodOrderChildren(String childrenTypeNames) {
        this.m_childrenTypeNames = "*".equals(childrenTypeNames) || StringUtils.isEmpty((String)childrenTypeNames) ? null : StringUtils.split((String)childrenTypeNames);
    }

    @Override
    public boolean canReference(JavaInfo javaInfo) {
        return true;
    }

    protected JavaInfo getLastChild(JavaInfo javaInfo) throws Exception {
        return (JavaInfo)((Object)GenericsUtils.getLastOrNull(this.getTargetChildren(javaInfo)));
    }

    protected List<JavaInfo> getTargetChildren(JavaInfo javaInfo) throws Exception {
        ArrayList<JavaInfo> list = new ArrayList<JavaInfo>();
        for (JavaInfo child : javaInfo.getChildrenJava()) {
            if (!this.isTargetChild(child)) continue;
            list.add(child);
        }
        return list;
    }

    public boolean isTargetChild(JavaInfo child) {
        if (this.m_childrenTypeNames == null) {
            return true;
        }
        Class<?> componentClass = child.getDescription().getComponentClass();
        String[] stringArray = this.m_childrenTypeNames;
        int n = this.m_childrenTypeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String childTypeName = stringArray[n2];
            if (ReflectionUtils.isSuccessorOf(componentClass, (String)childTypeName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

