/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.palette.model.entry;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.entry.ToolEntryInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.core.editor.palette.model.entry.AttributesProvider;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.ComponentPresentation;
import org.eclipse.wb.internal.core.model.description.factory.FactoryMethodDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentPresentationHelper;
import org.eclipse.wb.internal.core.model.description.helpers.FactoryDescriptionHelper;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;

public abstract class FactoryEntryInfo
extends ToolEntryInfo {
    protected String m_factoryClassName;
    protected String m_methodSignature;
    private ImageDescriptor m_icon;
    protected Class<?> m_factoryClass;
    protected FactoryMethodDescription m_methodDescription;
    private ComponentPresentation m_presentation;
    private ComponentDescription m_componentDescription;

    public FactoryEntryInfo() {
    }

    public FactoryEntryInfo(CategoryInfo categoryInfo, String factoryClassName, AttributesProvider attributes) {
        this.m_factoryClassName = factoryClassName;
        Assert.isNotNull((Object)this.m_factoryClassName);
        this.m_methodSignature = attributes.getAttribute("signature");
        Assert.isNotNull((Object)this.m_methodSignature, (String)"Factory method must have 'signature' attribute.");
        Object id = attributes.getAttribute("id");
        if (id == null) {
            id = categoryInfo.getId() + " " + this.m_factoryClassName + " " + this.m_methodSignature;
        }
        this.setId((String)id);
        String name = attributes.getAttribute("name");
        this.setName(name);
        this.setDescription(attributes.getAttribute("description"));
        this.setVisible(FactoryEntryInfo.getBoolean(attributes, "visible", true));
    }

    public final String getFactoryClassName() {
        return this.m_factoryClassName;
    }

    public final void setFactoryClassName(String factoryClassName) {
        this.m_factoryClassName = factoryClassName;
    }

    public final String getMethodSignature() {
        return this.m_methodSignature;
    }

    public final void setMethodSignature(String methodSignature) {
        this.m_methodSignature = methodSignature;
    }

    public FactoryMethodDescription getMethodDescription() {
        return this.m_methodDescription;
    }

    protected abstract boolean isStaticFactory();

    @Override
    public final boolean initialize(IEditPartViewer editPartViewer, JavaInfo rootJavaInfo) {
        String description;
        String presentationName;
        block9: {
            super.initialize(editPartViewer, rootJavaInfo);
            if (!ProjectUtils.hasType(this.m_javaProject, this.m_factoryClassName)) {
                return false;
            }
            this.m_factoryClass = this.m_state.getEditorLoader().loadClass(this.m_factoryClassName);
            this.m_methodDescription = FactoryDescriptionHelper.getDescription(this.m_editor, this.m_factoryClass, this.m_methodSignature, this.isStaticFactory());
            if (this.m_methodDescription != null) break block9;
            return false;
        }
        try {
            Class<?> componentClass = this.m_methodDescription.getReturnClass();
            this.m_presentation = ComponentPresentationHelper.getPresentation(this.m_editor, componentClass.getCanonicalName(), null);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (Throwable e) {
            String message = "Palette: can not load factory method " + this.toString();
            this.m_state.addWarning(new EditorWarning(message, e));
            return false;
        }
        this.m_icon = this.m_methodDescription.getIcon() != null ? this.m_methodDescription.getIcon() : this.m_presentation.getIcon();
        String name = this.getNameRaw();
        if ((StringUtils.isEmpty((String)name) || name.equals(this.m_methodSignature)) && (presentationName = this.m_methodDescription.getPresentationName()) != null) {
            this.setName(presentationName);
        }
        if (this.getNameRaw() == null) {
            this.setName(this.m_methodSignature);
        }
        if (StringUtils.isEmpty((String)(description = this.getDescription())) || description.startsWith("Class: ")) {
            this.setDescription(this.m_methodDescription.getDescription());
        }
        if (this.getDescription() == null) {
            this.setDescription("Class: " + this.m_factoryClassName + "<br/>Method: " + this.m_methodSignature);
        }
        return true;
    }

    protected final boolean ensureComponentDescription() {
        if (this.m_componentDescription == null) {
            try {
                this.m_componentDescription = ComponentDescriptionHelper.getDescription(this.m_editor, this.m_methodDescription);
            }
            catch (Throwable e) {
                String message = "Palette: can not load factory method " + this.toString();
                this.m_state.addWarning(new EditorWarning(message, e));
                return false;
            }
        }
        return true;
    }

    @Override
    public final ImageDescriptor getIcon() {
        return this.m_icon;
    }

    protected final JavaInfo createJavaInfo(CreationSupport creationSupport) throws Exception {
        JavaInfo javaInfo = JavaInfoUtils.createJavaInfo(this.m_editor, this.m_componentDescription, creationSupport);
        return JavaInfoUtils.getWrapped(javaInfo);
    }
}

