/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.intro.quicklinks;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.SerializationException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPartImplementation;
import org.eclipse.ui.internal.intro.impl.model.IntroTheme;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.eclipse.ui.internal.menus.MenuHelper;
import org.eclipse.ui.intro.config.IIntroContentProvider;
import org.eclipse.ui.intro.config.IIntroContentProviderSite;
import org.eclipse.ui.intro.quicklinks.URLLabelProvider;
import org.eclipse.ui.services.IServiceLocator;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class QuicklinksViewer
implements IIntroContentProvider {
    private static final int MAX_URL_LENGTH = 2083;
    private IIntroContentProviderSite site;
    private IServiceLocator locator;
    private CommandManager manager;
    private ICommandImageService images;
    private Supplier<List<Quicklink>> model;

    public void init(IIntroContentProviderSite site) {
        this.site = site;
        this.locator = site instanceof IServiceLocator ? (IServiceLocator)site : (site instanceof AbstractIntroPartImplementation ? ((AbstractIntroPartImplementation)site).getIntroPart().getIntroSite() : PlatformUI.getWorkbench());
        this.manager = (CommandManager)this.locator.getService(CommandManager.class);
        this.images = (ICommandImageService)this.locator.getService(ICommandImageService.class);
        this.model = new ModelReader();
    }

    protected String getCurrentThemeId() {
        if (this.site instanceof AbstractIntroPartImplementation) {
            IntroTheme theme = ((AbstractIntroPartImplementation)this.site).getModel().getTheme();
            return theme.getId();
        }
        return null;
    }

    public void createContent(String id, PrintWriter out) {
        this.getQuicklinks().forEach(ql -> {
            String urlEncodedCommand = this.asEmbeddedURL((Quicklink)ql);
            out.append("<a class='content-link'");
            if (ql.commandSpec != null) {
                out.append(" id='").append(this.asCSSId(ql.commandSpec)).append("' ");
            }
            out.append(" href='");
            out.append(urlEncodedCommand);
            out.append("'>");
            if (ql.iconUrl != null) {
                out.append("<img class='background-image' src='").append(ql.iconUrl).append("'>");
            }
            out.append("\n<div class='link-extra-div'></div>\n");
            out.append("<span class='link-label'>");
            out.append(ql.label);
            out.append("</span>");
            if (ql.description != null) {
                out.append("\n<p><span class='text'>");
                out.append(ql.description);
                out.append("</span></p>");
            }
            out.append("</a>");
        });
    }

    private String asEmbeddedURL(Quicklink ql) {
        if (ql.url != null) {
            return ql.url;
        }
        Object encoded = URLEncoder.encode(ql.commandSpec, StandardCharsets.UTF_8);
        if (ql.resolution != null) {
            encoded = (String)encoded + "&standby=" + ql.resolution;
        }
        return "http://org.eclipse.ui.intro/execute?command=" + (String)encoded;
    }

    private String asCSSId(String commandSpec) {
        int indexOf = commandSpec.indexOf(40);
        if (indexOf > 0) {
            commandSpec = commandSpec.substring(0, indexOf);
        }
        return commandSpec.replace('.', '_');
    }

    private String asBrowserURL(String iconURL) {
        if (iconURL.startsWith("file:") || iconURL.startsWith("http:")) {
            return iconURL;
        }
        try {
            URL original = new URL(iconURL);
            URL toLocal = FileLocator.toFileURL((URL)original);
            if (!toLocal.sameFile(original)) {
                return toLocal.toString();
            }
        }
        catch (IOException iOException) {}
        try {
            return this.asDataURL(ImageDescriptor.createFromURL((URL)new URL(iconURL)));
        }
        catch (MalformedURLException malformedURLException) {
            return iconURL;
        }
    }

    private String asDataURL(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        ImageData data = descriptor.getImageData();
        if (data == null) {
            return null;
        }
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{data};
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        loader.save((OutputStream)output, 5);
        if (output.size() * 4 / 3 < 2083) {
            return "data:image/png;base64," + Base64.getEncoder().encodeToString(output.toByteArray());
        }
        try {
            File tempFile = File.createTempFile("qlink", "png");
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileOutputStream fos = new FileOutputStream(tempFile);){
                fos.write(output.toByteArray());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            tempFile.deleteOnExit();
            return tempFile.toURI().toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void createContent(String id, Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 64);
        TableViewer tableViewer = new TableViewer(toolkit.createTable((Composite)section, 65536));
        tableViewer.setLabelProvider((IBaseLabelProvider)new URLLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element instanceof Quicklink) {
                    return ((Quicklink)element).label;
                }
                return super.getText(element);
            }

            @Override
            public Image getImage(Object element) {
                if (element instanceof Quicklink) {
                    return super.getImage(((Quicklink)element).iconUrl);
                }
                return super.getImage(element);
            }
        });
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tableViewer.setInput((Object)this.getQuicklinks().toArray());
    }

    private List<Quicklink> getQuicklinks() {
        List<Quicklink> links = this.model.get();
        if (links.isEmpty()) {
            links = this.generateDefaultQuicklinks();
        }
        return links.stream().filter(this::populateQuicklink).sorted(Quicklink::compareTo).collect(Collectors.toList());
    }

    private boolean populateQuicklink(Quicklink ql) {
        ParameterizedCommand pc;
        block7: {
            if (ql.commandSpec == null) {
                return true;
            }
            pc = this.manager.deserialize(ql.commandSpec);
            if (pc.getCommand().isDefined() && pc.getCommand().isHandled() && pc.getCommand().isEnabled()) break block7;
            return false;
        }
        try {
            ImageDescriptor descriptor;
            if (ql.label == null) {
                ql.label = pc.getCommand().getName();
            }
            if (ql.description == null) {
                ql.description = pc.getCommand().getDescription();
            }
            if (ql.iconUrl == null && this.images != null && (descriptor = this.images.getImageDescriptor(pc.getId())) != null) {
                String iconUrl = MenuHelper.getImageUrl((ImageDescriptor)descriptor);
                ql.iconUrl = iconUrl != null ? this.asBrowserURL(iconUrl) : this.asDataURL(descriptor);
            }
            return true;
        }
        catch (SerializationException | NotDefinedException throwable) {
            return false;
        }
    }

    private Quicklink forCommand(String commandSpec) {
        Quicklink ql = new Quicklink();
        ql.commandSpec = commandSpec;
        return ql;
    }

    private Quicklink forCommand(String commandSpec, Importance importance) {
        Quicklink ql = new Quicklink();
        ql.commandSpec = commandSpec;
        ql.importance = importance;
        return ql;
    }

    private List<Quicklink> generateDefaultQuicklinks() {
        return Arrays.asList(this.forCommand("org.eclipse.oomph.setup.ui.questionnaire", Importance.HIGH), this.forCommand("org.eclipse.ui.cheatsheets.openCheatSheet"), this.forCommand("org.eclipse.ui.newWizard"), this.forCommand("org.eclipse.ui.file.import"), this.forCommand("org.eclipse.epp.mpc.ui.command.showMarketplaceWizard"), this.forCommand("org.eclipse.ui.edit.text.openLocalFile", Importance.LOW));
    }

    public void dispose() {
    }

    static enum Importance {
        HIGH("high", 0),
        MEDIUM("medium", 1),
        LOW("low", 2);

        String id;
        int level;

        private Importance(String text, int importance) {
            this.id = text;
            this.level = importance;
        }

        public static Importance forId(String id) {
            Importance[] importanceArray = Importance.values();
            int n = importanceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Importance i = importanceArray[n2];
                if (i.id.equals(id)) {
                    return i;
                }
                ++n2;
            }
            return LOW;
        }
    }

    class ModelReader
    implements Supplier<List<Quicklink>> {
        private static final String QL_EXT_PT = "org.eclipse.ui.intro.quicklinks";
        private static final String ELMT_COMMAND = "command";
        private static final String ATT_ID = "id";
        private static final String ELMT_URL = "url";
        private static final String ATT_LOCATION = "location";
        private static final String ELMT_OVERRIDE = "override";
        private static final String ATT_COMMANDID = "command";
        private static final String ATT_THEME = "theme";
        private static final String ATT_LABEL = "label";
        private static final String ATT_DESCRIPTION = "description";
        private static final String ATT_ICON = "icon";
        private static final String ATT_IMPORTANCE = "importance";
        private static final String ATT_RESOLUTION = "resolution";
        private final Map<String, Quicklink> quicklinks = new LinkedHashMap<String, Quicklink>();
        private Map<String, Long> bundleIds;
        private Bundle[] bundles;

        ModelReader() {
        }

        @Override
        public List<Quicklink> get() {
            IConfigurationElement ce;
            int n;
            int n2;
            IConfigurationElement[] iConfigurationElementArray;
            IExtension ext;
            int n3;
            int n4;
            IExtension[] iExtensionArray;
            IExtension[] extensions = this.getExtensions(QL_EXT_PT);
            Bundle productBundle = Platform.getProduct().getDefiningBundle();
            if (productBundle != null) {
                iExtensionArray = extensions;
                n4 = extensions.length;
                n3 = 0;
                while (n3 < n4) {
                    ext = iExtensionArray[n3];
                    if (productBundle.getSymbolicName().equals(ext.getContributor().getName())) {
                        iConfigurationElementArray = ext.getConfigurationElements();
                        n2 = iConfigurationElementArray.length;
                        n = 0;
                        while (n < n2) {
                            ce = iConfigurationElementArray[n];
                            this.processDefinition(ce);
                            ++n;
                        }
                    }
                    ++n3;
                }
            }
            iExtensionArray = extensions;
            n4 = extensions.length;
            n3 = 0;
            while (n3 < n4) {
                ext = iExtensionArray[n3];
                if (productBundle == null || !productBundle.getSymbolicName().equals(ext.getContributor().getName())) {
                    iConfigurationElementArray = ext.getConfigurationElements();
                    n2 = iConfigurationElementArray.length;
                    n = 0;
                    while (n < n2) {
                        ce = iConfigurationElementArray[n];
                        this.processDefinition(ce);
                        ++n;
                    }
                }
                ++n3;
            }
            iExtensionArray = extensions;
            n4 = extensions.length;
            n3 = 0;
            while (n3 < n4) {
                ext = iExtensionArray[n3];
                iConfigurationElementArray = ext.getConfigurationElements();
                n2 = iConfigurationElementArray.length;
                n = 0;
                while (n < n2) {
                    ce = iConfigurationElementArray[n];
                    if (ELMT_OVERRIDE.equals(ce.getName())) {
                        String theme = ce.getAttribute(ATT_THEME);
                        String commandSpecPattern = ce.getAttribute("command");
                        String icon = ce.getAttribute(ATT_ICON);
                        if (theme != null && icon != null && Objects.equals(theme, QuicklinksViewer.this.getCurrentThemeId()) && commandSpecPattern != null) {
                            this.findMatchingQuicklinks(commandSpecPattern).forEach(ql -> {
                                String string = ql.iconUrl = this.getImageURL(ce, ATT_ICON);
                            });
                        }
                    }
                    ++n;
                }
                ++n3;
            }
            return new ArrayList<Quicklink>(this.quicklinks.values());
        }

        private void processDefinition(IConfigurationElement ce) {
            if (!"command".equals(ce.getName()) && !ELMT_URL.equals(ce.getName())) {
                return;
            }
            String key = null;
            Quicklink ql = new Quicklink();
            if ("command".equals(ce.getName())) {
                key = ce.getAttribute(ATT_ID);
                if (key == null) {
                    Log.warning((String)NLS.bind((String)"Skipping '{0}': missing {1}", (Object)ce.getName(), (Object)ATT_ID));
                    return;
                }
                ql.commandSpec = key;
                ql.label = ce.getAttribute(ATT_LABEL);
                ql.description = ce.getAttribute(ATT_DESCRIPTION);
                ql.iconUrl = this.getImageURL(ce, ATT_ICON);
            } else if (ELMT_URL.equals(ce.getName())) {
                key = ce.getAttribute(ATT_LOCATION);
                if (key == null) {
                    Log.warning((String)NLS.bind((String)"Skipping '{0}': missing {1}", (Object)ELMT_URL, (Object)ATT_LOCATION));
                    return;
                }
                ql.url = key;
                ql.label = ce.getAttribute(ATT_LABEL);
                ql.description = ce.getAttribute(ATT_DESCRIPTION);
                ql.iconUrl = this.getImageURL(ce, ATT_ICON);
            }
            ql.rank = this.getRank(ce.getContributor().getName());
            if (ce.getAttribute(ATT_IMPORTANCE) != null) {
                ql.importance = Importance.forId(ce.getAttribute(ATT_IMPORTANCE));
            }
            if (ce.getAttribute(ATT_RESOLUTION) != null) {
                ql.resolution = ce.getAttribute(ATT_RESOLUTION);
            }
            this.quicklinks.putIfAbsent(key, ql);
        }

        private Stream<Quicklink> findMatchingQuicklinks(String commandSpecPattern) {
            String regexp = commandSpecPattern.replace(".", "\\.").replace("(", "\\(").replace(")", "\\)").replace("*", ".*");
            Pattern pattern = Pattern.compile(regexp);
            return this.quicklinks.values().stream().filter(ql -> ql.commandSpec != null && (commandSpecPattern.equals(ql.commandSpec) || pattern.matcher(ql.commandSpec).matches()));
        }

        private IExtension[] getExtensions(String extPtId) {
            IExtensionRegistry registry = (IExtensionRegistry)QuicklinksViewer.this.locator.getService(IExtensionRegistry.class);
            IExtensionPoint extPt = registry.getExtensionPoint(extPtId);
            return extPt == null ? new IExtension[]{} : extPt.getExtensions();
        }

        private long getRank(String bundleSymbolicName) {
            if (this.bundleIds == null) {
                Bundle bundle = FrameworkUtil.getBundle(this.getClass());
                this.bundleIds = new HashMap<String, Long>();
                this.bundles = bundle.getBundleContext().getBundles();
            }
            return this.bundleIds.computeIfAbsent(bundleSymbolicName, bsn -> {
                Bundle[] bundleArray = this.bundles;
                int n = this.bundles.length;
                int n2 = 0;
                while (n2 < n) {
                    Bundle b = bundleArray[n2];
                    if (bsn.equals(b.getSymbolicName()) && (b.getState() & 3) == 0) {
                        return b.getBundleId();
                    }
                    ++n2;
                }
                return Long.MAX_VALUE;
            });
        }

        private String getImageURL(IConfigurationElement ce, String attr) {
            String iconURL = MenuHelper.getIconURI((IConfigurationElement)ce, (String)attr);
            if (iconURL != null) {
                return QuicklinksViewer.this.asBrowserURL(iconURL);
            }
            return null;
        }
    }

    static class Quicklink
    implements Comparable<Quicklink> {
        String commandSpec;
        String url;
        String label;
        String description;
        String iconUrl;
        Importance importance = Importance.MEDIUM;
        long rank;
        String resolution;

        @Override
        public int compareTo(Quicklink b) {
            int impA = this.importance.level;
            int impB = b.importance.level;
            if (impA != impB) {
                return impA - impB;
            }
            long diff = this.rank - b.rank;
            if (diff > 0L) {
                return 1;
            }
            if (diff < 0L) {
                return -1;
            }
            return 0;
        }
    }
}

