/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.format;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.eclipse.jdt.annotation.NonNull;

public class LongToPercentFormat
extends Format {
    public static final long MAX_PERCENT_VALUE = 1000000000L;
    private static final long serialVersionUID = -5576403724759807115L;
    private static final @NonNull Format INSTANCE = new LongToPercentFormat();
    private static final Format FORMAT = new DecimalFormat("##.######%");

    private LongToPercentFormat() {
    }

    public static @NonNull Format getInstance() {
        return INSTANCE;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof Number) {
            Number num = (Number)obj;
            double value = num.doubleValue();
            return toAppendTo.append(FORMAT.format(value / 1.0E9));
        }
        return toAppendTo.append(obj);
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        Number number = NumberFormat.getInstance().parse(source, pos);
        if (number == null) {
            return null;
        }
        return number.doubleValue() * 1.0E9;
    }
}

