/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.theme.raw;

import java.io.Reader;
import org.eclipse.tm4e.core.internal.parser.PListParser;
import org.eclipse.tm4e.core.internal.parser.PListParserJSON;
import org.eclipse.tm4e.core.internal.parser.PListParserXML;
import org.eclipse.tm4e.core.internal.parser.PListParserYAML;
import org.eclipse.tm4e.core.internal.parser.PListPath;
import org.eclipse.tm4e.core.internal.parser.PropertySettable;
import org.eclipse.tm4e.core.internal.theme.raw.IRawTheme;
import org.eclipse.tm4e.core.internal.theme.raw.RawTheme;
import org.eclipse.tm4e.core.registry.IThemeSource;

public final class RawThemeReader {
    private static final PropertySettable.Factory<PListPath> OBJECT_FACTORY = path -> new RawTheme();
    private static final PListParser<RawTheme> JSON_PARSER = new PListParserJSON<RawTheme>(OBJECT_FACTORY);
    private static final PListParser<RawTheme> XML_PARSER = new PListParserXML<RawTheme>(OBJECT_FACTORY);
    private static final PListParser<RawTheme> YAML_PARSER = new PListParserYAML<RawTheme>(OBJECT_FACTORY);

    public static IRawTheme readTheme(IThemeSource source) throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Reader reader = source.getReader();){
            switch (source.getContentType()) {
                case JSON: {
                    return JSON_PARSER.parse(reader);
                }
                case YAML: {
                    return YAML_PARSER.parse(reader);
                }
            }
            return XML_PARSER.parse(reader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private RawThemeReader() {
    }
}

