/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.mapping;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ResourceMarkAsMergedHandler;
import org.eclipse.team.internal.ui.mapping.ResourceMergeHandler;
import org.eclipse.team.ui.mapping.SaveableComparison;
import org.eclipse.team.ui.mapping.SynchronizationOperation;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public abstract class MergeActionHandler
extends AbstractHandler {
    private final ISynchronizePageConfiguration configuration;
    private boolean enabled = false;
    private IStructuredSelection selection;
    private final ISelectionChangedListener listener = this::updatedEnablement;

    public static IHandler getDefaultHandler(String mergeActionId, ISynchronizePageConfiguration configuration) {
        if (mergeActionId == "org.eclipse.team.ui.mergeAction") {
            ResourceMergeHandler resourceMergeHandler = new ResourceMergeHandler(configuration, false);
            resourceMergeHandler.updateEnablement((IStructuredSelection)configuration.getSite().getSelectionProvider().getSelection());
            return resourceMergeHandler;
        }
        if (mergeActionId == "org.eclipse.team.ui.overwriteAction") {
            ResourceMergeHandler resourceMergeHandler = new ResourceMergeHandler(configuration, true);
            resourceMergeHandler.updateEnablement((IStructuredSelection)configuration.getSite().getSelectionProvider().getSelection());
            return resourceMergeHandler;
        }
        if (mergeActionId == "org.eclipse.team.ui.markAsMergeAction") {
            ResourceMarkAsMergedHandler resourceMarkAsMergedHandler = new ResourceMarkAsMergedHandler(configuration);
            resourceMarkAsMergedHandler.updateEnablement((IStructuredSelection)configuration.getSite().getSelectionProvider().getSelection());
            return resourceMarkAsMergedHandler;
        }
        return null;
    }

    public MergeActionHandler(ISynchronizePageConfiguration configuration) {
        this.configuration = configuration;
        ISelectionProvider selectionProvider = this.getConfiguration().getSite().getSelectionProvider();
        selectionProvider.addSelectionChangedListener(this.listener);
        this.updateEnablement((IStructuredSelection)selectionProvider.getSelection());
    }

    public void dispose() {
        this.getConfiguration().getSite().getSelectionProvider().removeSelectionChangedListener(this.listener);
    }

    void updatedEnablement(SelectionChangedEvent event) {
        this.updateEnablement(event.getStructuredSelection());
    }

    protected void updateEnablement(IStructuredSelection selection) {
        this.selection = selection;
        boolean isEnabled = this.getOperation().shouldRun();
        this.setEnabled(isEnabled);
    }

    protected final ISynchronizePageConfiguration getConfiguration() {
        return this.configuration;
    }

    protected final IStructuredSelection getStructuredSelection() {
        return this.selection;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected void setEnabled(boolean isEnabled) {
        if (this.enabled != isEnabled) {
            this.enabled = isEnabled;
            this.fireHandlerChanged(new HandlerEvent((IHandler)this, true, false));
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            SynchronizationOperation operation = this.getOperation();
            IRunnableContext context = this.getConfiguration().getRunnableContext();
            if (context != null) {
                context.run(true, true, (IRunnableWithProgress)operation);
            } else {
                operation.run();
            }
        }
        catch (InvocationTargetException e) {
            Utils.handle(e);
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    protected abstract SynchronizationOperation getOperation();

    public SaveableComparison getSaveable() {
        return this.getOperation().getSaveable();
    }
}

