/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class OpenMessageDialogHandler
extends AbstractHandler {
    private static final String PARAM_ID_TITLE = "title";
    private static final String PARAM_ID_MESSAGE = "message";
    private static final String PARAM_ID_IMAGE_TYPE = "imageType";
    private static final String PARAM_ID_DEFAULT_INDEX = "defaultIndex";
    private static final String PARAM_ID_BUTTON_LABEL_PREFIX = "buttonLabel";
    private static final int BUTTON_LABEL_COUNT = 4;
    private static final String PARAM_ID_CANCEL_RETURNS = "cancelReturns";
    private static final int CANCEL_RETURN_CODE = -1;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String title = event.getParameter(PARAM_ID_TITLE);
        String message = event.getParameter(PARAM_ID_MESSAGE);
        int imageType = 0;
        if (event.getParameter(PARAM_ID_IMAGE_TYPE) != null) {
            Integer imageTypeInteger = (Integer)event.getObjectParameterForExecution(PARAM_ID_IMAGE_TYPE);
            imageType = imageTypeInteger;
        }
        int defaultValue = 0;
        if (event.getParameter(PARAM_ID_DEFAULT_INDEX) != null) {
            Integer defaultValueInteger = (Integer)event.getObjectParameterForExecution(PARAM_ID_DEFAULT_INDEX);
            defaultValue = defaultValueInteger;
        }
        String[] buttonLabels = this.collectButtonLabels(event);
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = activeWindow != null ? activeWindow.getShell() : null;
        MessageDialog dialog = new MessageDialog(shell, title, null, message, imageType, buttonLabels, defaultValue);
        int returnCode = dialog.open();
        if (returnCode == -1) {
            String cancelReturns = event.getParameter(PARAM_ID_CANCEL_RETURNS);
            if (cancelReturns != null) {
                return cancelReturns;
            }
            throw new ExecutionException("dialog canceled");
        }
        return buttonLabels[returnCode];
    }

    private String[] collectButtonLabels(ExecutionEvent event) {
        ArrayList<String> buttonLabelList = new ArrayList<String>();
        int i = 0;
        while (i < 4) {
            String buttonLabelParamId = PARAM_ID_BUTTON_LABEL_PREFIX + Integer.toString(i);
            String buttonLabel = event.getParameter(buttonLabelParamId);
            if (buttonLabel == null) break;
            buttonLabelList.add(buttonLabel);
            ++i;
        }
        return buttonLabelList.toArray(new String[buttonLabelList.size()]);
    }
}

