/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.search.ManifestEditorOpener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.ISearchEditorAccess;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class SearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter {
    protected ISearchQuery fQuery;

    public SearchResult(ISearchQuery query) {
        this.fQuery = query;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public String getLabel() {
        int numMatches = this.getMatchCount();
        return this.fQuery.getLabel() + " - " + numMatches + " " + (numMatches == 1 ? PDEUIMessages.SearchResult_match : PDEUIMessages.SearchResult_matches);
    }

    public String getTooltip() {
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        return PDEPluginImages.DESC_PSEARCH_OBJ;
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        Object element = match.getElement();
        if (element instanceof IPluginObject) {
            return this.isMatchContained(editor, (IPluginObject)element);
        }
        if (element instanceof IFeaturePlugin) {
            return this.isMatchContained(editor, (IFeaturePlugin)element);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        Object[] objects;
        ArrayList<Match> list = new ArrayList<Match>();
        Object[] objectArray = objects = result.getElements();
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object;
            Object o = objectArray[n2];
            Object object2 = o;
            if (object2 instanceof IPluginObject) {
                void object3;
                IPluginObject cfr_ignored_0 = (IPluginObject)object2;
                IPluginObject cfr_ignored_1 = (IPluginObject)object2;
                if (this.isMatchContained(editor, (IPluginObject)object3)) {
                    Match[] matches;
                    Match[] matchArray = matches = this.getMatches(object3);
                    int n3 = matches.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Match matche = matchArray[n4];
                        IDocument document = this.getDocument(editor, matche);
                        if (document != null) {
                            list.add(ManifestEditorOpener.findExactMatch(document, matche, editor));
                        }
                        ++n4;
                    }
                }
            }
            if ((object = o) instanceof IFeaturePlugin) {
                void object4;
                Match[] cfr_ignored_2 = (Match[])object;
                IFeaturePlugin cfr_ignored_3 = (IFeaturePlugin)object;
                if (this.isMatchContained(editor, (IFeaturePlugin)object4)) {
                    Collections.addAll(list, this.getMatches(object4));
                }
            }
            ++n2;
        }
        return list.toArray(new Match[list.size()]);
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return null;
    }

    protected boolean isMatchContained(IEditorPart editor, IPluginObject object) {
        return this.isMatchContained(editor, object.getModel().getUnderlyingResource(), object.getModel().getInstallLocation());
    }

    protected boolean isMatchContained(IEditorPart editor, IFeaturePlugin object) {
        return this.isMatchContained(editor, object.getModel().getUnderlyingResource(), object.getModel().getInstallLocation());
    }

    protected boolean isMatchContained(IEditorPart editor, IResource underlyingResource, String installLocation) {
        IResource objectResource;
        IFile resource = (IFile)editor.getEditorInput().getAdapter(IFile.class);
        if (resource != null && (objectResource = underlyingResource) != null) {
            return resource.getProject().equals((Object)objectResource.getProject());
        }
        File file = (File)editor.getEditorInput().getAdapter(File.class);
        if (file != null) {
            IPath path = IPath.fromOSString((String)installLocation);
            IPath filePath = null;
            filePath = "MANIFEST.MF".equals(file.getName()) ? IPath.fromOSString((String)file.getParentFile().getParent()) : (file.getName().endsWith("jar") ? IPath.fromOSString((String)file.getPath()) : IPath.fromOSString((String)file.getParent()));
            return path.equals((Object)filePath);
        }
        return false;
    }

    protected IDocument getDocument(IEditorPart editor, Match match) {
        IDocument document = null;
        if (editor instanceof ISearchEditorAccess) {
            document = ((ISearchEditorAccess)editor).getDocument(match);
        } else if (editor instanceof ITextEditor) {
            document = ((ITextEditor)editor).getDocumentProvider().getDocument((Object)editor.getEditorInput());
        }
        return document;
    }
}

