/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.pde.internal.ui.editor.text.ChangeAwareSourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;

public class PDEProjectionViewer
extends ProjectionViewer {
    public static final int QUICK_OUTLINE = 513;
    private IInformationPresenter fOutlinePresenter;
    private final boolean fIsQuickOutlineEnabled;

    public PDEProjectionViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showsAnnotationOverview, int styles, boolean isQuickOutlineEnabled) {
        super(parent, ruler, overviewRuler, showsAnnotationOverview, styles);
        this.fIsQuickOutlineEnabled = isQuickOutlineEnabled;
    }

    public void doOperation(int operation) {
        if (this.getTextWidget() == null || this.getTextWidget().isDisposed()) {
            return;
        }
        if (operation == 513) {
            if (this.fOutlinePresenter != null) {
                this.fOutlinePresenter.showInformation();
            }
            return;
        }
        super.doOperation(operation);
    }

    public boolean canDoOperation(int operation) {
        if (operation == 513) {
            return this.fOutlinePresenter != null;
        }
        return super.canDoOperation(operation);
    }

    /*
     * WARNING - void declaration
     */
    public void configure(SourceViewerConfiguration configuration) {
        SourceViewerConfiguration sourceViewerConfiguration;
        if (this.getTextWidget() == null || this.getTextWidget().isDisposed()) {
            return;
        }
        super.configure(configuration);
        if (this.fIsQuickOutlineEnabled && (sourceViewerConfiguration = configuration) instanceof ChangeAwareSourceViewerConfiguration) {
            void sourceConfiguration;
            ChangeAwareSourceViewerConfiguration changeAwareSourceViewerConfiguration = (ChangeAwareSourceViewerConfiguration)sourceViewerConfiguration;
            ChangeAwareSourceViewerConfiguration cfr_ignored_0 = (ChangeAwareSourceViewerConfiguration)sourceViewerConfiguration;
            this.fOutlinePresenter = sourceConfiguration.getOutlinePresenter((ISourceViewer)this);
            if (this.fOutlinePresenter != null) {
                this.fOutlinePresenter.install((ITextViewer)this);
            }
        }
    }

    public void unconfigure() {
        if (this.fOutlinePresenter != null) {
            this.fOutlinePresenter.uninstall();
            this.fOutlinePresenter = null;
        }
        super.unconfigure();
    }
}

