/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.bnd;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.RequiredPluginsClasspathContainer;
import org.eclipse.pde.internal.core.natures.BndProject;

public class BndResourceChangeListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            final HashSet<IProject> updateProjects = new HashSet<IProject>();
            try {
                delta.accept(new IResourceDeltaVisitor(){

                    /*
                     * WARNING - void declaration
                     */
                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        IResource iResource = resource;
                        if (iResource instanceof IFile) {
                            void file;
                            IFile iFile = (IFile)iResource;
                            IFile cfr_ignored_0 = (IFile)iResource;
                            if ("pde.bnd".equals(file.getName()) && BndProject.isBndProject(file.getProject())) {
                                updateProjects.add(file.getProject());
                            }
                        }
                        return true;
                    }
                });
                if (updateProjects.size() > 0) {
                    BndResourceChangeListener.performClasspathUpdate(updateProjects);
                }
            }
            catch (CoreException coreException) {}
        }
    }

    private static void performClasspathUpdate(final Collection<IProject> updateProjects) {
        Job.create((String)PDECoreMessages.PluginModelManager_1, (ICoreRunnable)new ICoreRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)PDECore.REQUIRED_PLUGINS_CONTAINER_PATH.segment(0));
                if (initializer == null) {
                    return;
                }
                for (IProject project : updateProjects) {
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    if (!initializer.canUpdateClasspathContainer(PDECore.REQUIRED_PLUGINS_CONTAINER_PATH, javaProject)) continue;
                    initializer.requestClasspathContainerUpdate(PDECore.REQUIRED_PLUGINS_CONTAINER_PATH, javaProject, (IClasspathContainer)new RequiredPluginsClasspathContainer(null, null, project));
                }
            }
        }).schedule();
    }
}

