/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.builder.BuildState;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IRequiredComponentDescription;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaVisitor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.search.SkippedComponent;
import org.eclipse.pde.api.tools.internal.util.FileManager;
import org.eclipse.pde.api.tools.internal.util.FilteredElements;
import org.eclipse.pde.api.tools.internal.util.Signatures;
import org.eclipse.pde.api.tools.internal.util.SinceTagVersion;
import org.eclipse.pde.api.tools.internal.util.TarEntry;
import org.eclipse.pde.api.tools.internal.util.TarException;
import org.eclipse.pde.api.tools.internal.util.TarFile;
import org.eclipse.pde.api.tools.internal.util.UtilMessages;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.osgi.framework.Version;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class Util {
    public static final String DOT_TGZ = ".tgz";
    public static final String DOT_TAR_GZ = ".tar.gz";
    public static final String DOT_JAR = ".jar";
    public static final String DOT_ZIP = ".zip";
    public static final char VERSION_SEPARATOR = '(';
    public static final String EMPTY_STRING = "";
    public static final String DEFAULT_PACKAGE_NAME = "";
    public static final String MANIFEST_NAME = "MANIFEST.MF";
    public static final String DOT_CLASS_SUFFIX = ".class";
    public static final String DOT_JAVA_SUFFIX = ".java";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String JAVA_LANG_RUNTIMEEXCEPTION = "java.lang.RuntimeException";
    public static final String LINE_DELIMITER = System.lineSeparator();
    public static final String UNKNOWN_ELEMENT_KIND = "UNKNOWN_ELEMENT_KIND";
    public static final String UNKNOWN_FLAGS = "UNKNOWN_FLAGS";
    public static final String UNKNOWN_KIND = "UNKNOWN_KIND";
    public static final String UNKNOWN_VISIBILITY = "UNKNOWN_VISIBILITY";
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static final String REGULAR_EXPRESSION_START = "R:";
    private static int DELETE_MAX_TIME = 0;
    private static boolean DELETE_DEBUG = false;
    private static int DELETE_MAX_WAIT = 10000;
    public static final IPath MANIFEST_PROJECT_RELATIVE_PATH = IPath.fromOSString((String)"META-INF/MANIFEST.MF");
    public static final String ORG_ECLIPSE_SWT = "org.eclipse.swt";
    public static final int LATEST_OPCODES_ASM = 589824;
    public static final Comparator<Object> componentsorter = (o1, o2) -> {
        if (o1 instanceof IApiComponent && o2 instanceof IApiComponent) {
            return ((IApiComponent)o1).getSymbolicName().compareTo(((IApiComponent)o2).getSymbolicName());
        }
        if (o1 instanceof SkippedComponent && o2 instanceof SkippedComponent) {
            return ((SkippedComponent)o1).getComponentId().compareTo(((SkippedComponent)o2).getComponentId());
        }
        if (o1 instanceof String && o2 instanceof String) {
            return ((String)o1).compareTo((String)o2);
        }
        return -1;
    };
    public static final Comparator<Object> filesorter = (o1, o2) -> {
        if (o1 instanceof File && o2 instanceof File) {
            return ((File)o1).getName().compareTo(((File)o2).getName());
        }
        return 0;
    };

    private static void appendProperty(StringBuilder buffer, String key, String value) {
        buffer.append(key);
        buffer.append('=');
        buffer.append(value);
        buffer.append('\n');
    }

    public static List<IDelta> collectAllDeltas(IDelta delta) {
        final ArrayList<IDelta> list = new ArrayList<IDelta>();
        delta.accept(new DeltaVisitor(){

            @Override
            public void endVisit(IDelta localDelta) {
                if (localDelta.getChildren().length == 0) {
                    list.add(localDelta);
                }
                super.endVisit(localDelta);
            }
        });
        return list;
    }

    private static void collectAllFiles(File root, ArrayList<File> collector, FileFilter fileFilter) {
        File[] files;
        File[] fileArray = files = root.listFiles(fileFilter);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File currentFile = fileArray[n2];
            if (currentFile.isDirectory()) {
                Util.collectAllFiles(currentFile, collector, fileFilter);
            } else {
                collector.add(currentFile);
            }
            ++n2;
        }
    }

    public static IProject[] getApiProjects() {
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> temp = new ArrayList<IProject>();
        IProject project = null;
        IProject[] iProjectArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject allProject = iProjectArray[n2];
            project = allProject;
            if (project.isAccessible()) {
                try {
                    if (project.hasNature("org.eclipse.pde.api.tools.apiAnalysisNature")) {
                        temp.add(project);
                    }
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
        IProject[] projects = null;
        if (temp.size() != 0) {
            projects = new IProject[temp.size()];
            temp.toArray(projects);
        }
        return projects;
    }

    public static IProject[] getApiProjectsMinSourceLevel(String sourcelevel) {
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> temp = new ArrayList<IProject>();
        IProject project = null;
        IProject[] iProjectArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject allProject = iProjectArray[n2];
            project = allProject;
            if (project.isAccessible()) {
                try {
                    IJavaProject jp;
                    String src;
                    if (project.hasNature("org.eclipse.pde.api.tools.apiAnalysisNature") && (src = (jp = JavaCore.create((IProject)project)).getOption("org.eclipse.jdt.core.compiler.source", true)) != null && src.compareTo(sourcelevel) >= 0) {
                        temp.add(project);
                    }
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
        IProject[] projects = null;
        if (temp.size() != 0) {
            projects = new IProject[temp.size()];
            temp.toArray(projects);
        }
        return projects;
    }

    public static boolean copy(File file, File newFile) {
        try {
            Files.copy(file.toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (IOException e) {
            ApiPlugin.log(e);
            return false;
        }
    }

    public static File createEEFile(IVMInstall jre, String eeid) throws IOException {
        String string = Util.generateEEContents(jre, eeid);
        File eeFile = Util.createTempFile("eed", ".ee");
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream outputStream = new FileOutputStream(eeFile);){
            outputStream.write(string.getBytes(StandardCharsets.UTF_8));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return eeFile;
    }

    public static boolean equalsOrNull(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static String generateEEContents(IVMInstall vm, String eeId) throws IOException {
        StringBuilder buffer = new StringBuilder();
        Util.appendProperty(buffer, "-Djava.home", vm.getInstallLocation().getCanonicalPath());
        StringBuilder paths = new StringBuilder();
        LibraryLocation[] libraryLocations = JavaRuntime.getLibraryLocations((IVMInstall)vm);
        int i = 0;
        while (i < libraryLocations.length) {
            LibraryLocation lib = libraryLocations[i];
            paths.append(lib.getSystemLibraryPath().toOSString());
            if (i < libraryLocations.length - 1) {
                paths.append(File.pathSeparatorChar);
            }
            ++i;
        }
        Util.appendProperty(buffer, "-Dee.bootclasspath", paths.toString());
        Util.appendProperty(buffer, "-Dee.class.library.level", eeId);
        return buffer.toString();
    }

    public static File[] getAllFiles(File root, FileFilter fileFilter) {
        ArrayList<File> files = new ArrayList<File>();
        if (root.isDirectory()) {
            Util.collectAllFiles(root, files, fileFilter);
            File[] result = new File[files.size()];
            files.toArray(result);
            return result;
        }
        return null;
    }

    public static Job getBuildJob(IProject[] projects) {
        Assert.isNotNull((Object)projects);
        BuildJob buildJob = new BuildJob(UtilMessages.Util_4, projects);
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.setUser(true);
        return buildJob;
    }

    public static Job getBuildJob(IProject[] projects, int buildKind) {
        Assert.isNotNull((Object)projects);
        BuildJob buildJob = new BuildJob(UtilMessages.Util_4, projects, buildKind);
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.setUser(true);
        return buildJob;
    }

    public static IApiTypeRoot getClassFile(IApiComponent[] components, String typeName) {
        if (components == null) {
            return null;
        }
        CoreException ex = null;
        IApiElement component = null;
        IApiComponent[] iApiComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                IApiComponent apiComponent = iApiComponentArray[n2];
                if (apiComponent != null) {
                    try {
                        IApiTypeRoot classFile = apiComponent.findTypeRoot(typeName);
                        if (classFile != null) {
                            return classFile;
                        }
                    }
                    catch (CoreException e) {
                        if (ex != null) break block7;
                        ex = e;
                        component = apiComponent;
                    }
                }
            }
            ++n2;
        }
        if (ex != null) {
            ApiPlugin.log("Error while resolving class file for: " + typeName + " via " + component.getName(), ex);
        }
        return null;
    }

    public static String getDeltaElementType(IDelta delta) {
        return Util.getDeltaElementType(delta.getElementType());
    }

    public static String getSeverity(int severity) {
        switch (severity) {
            case 2: {
                return "ERROR";
            }
            case 0: {
                return "INFO";
            }
            case 1: {
                return "WARNING";
            }
        }
        return "UNKNOWN_SEVERITY";
    }

    public static int getDeltaElementTypeValue(String elementType) {
        Class<IDelta> IDeltaClass = IDelta.class;
        try {
            Field field = IDeltaClass.getField(elementType);
            return field.getInt(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            return -1;
        }
    }

    public static String getDeltaElementType(int elementType) {
        switch (elementType) {
            case 1: {
                return "ANNOTATION_ELEMENT_TYPE";
            }
            case 8: {
                return "INTERFACE_ELEMENT_TYPE";
            }
            case 6: {
                return "ENUM_ELEMENT_TYPE";
            }
            case 2: {
                return "API_COMPONENT_ELEMENT_TYPE";
            }
            case 3: {
                return "API_BASELINE_ELEMENT_TYPE";
            }
            case 5: {
                return "CONSTRUCTOR_ELEMENT_TYPE";
            }
            case 9: {
                return "METHOD_ELEMENT_TYPE";
            }
            case 7: {
                return "FIELD_ELEMENT_TYPE";
            }
            case 4: {
                return "CLASS_ELEMENT_TYPE";
            }
            case 10: {
                return "TYPE_PARAMETER_ELEMENT_TYPE";
            }
        }
        return UNKNOWN_ELEMENT_KIND;
    }

    public static String getDeltaFlagsName(int flags) {
        switch (flags) {
            case 1: {
                return "ABSTRACT_TO_NON_ABSTRACT";
            }
            case 2: {
                return "ANNOTATION_DEFAULT_VALUE";
            }
            case 3: {
                return "API_COMPONENT";
            }
            case 4: {
                return "ARRAY_TO_VARARGS";
            }
            case 5: {
                return "CHECKED_EXCEPTION";
            }
            case 6: {
                return "CLASS_BOUND";
            }
            case 7: {
                return "CLINIT";
            }
            case 8: {
                return "CONSTRUCTOR";
            }
            case 10: {
                return "CONTRACTED_SUPERINTERFACES_SET";
            }
            case 11: {
                return "DECREASE_ACCESS";
            }
            case 12: {
                return "ENUM_CONSTANT";
            }
            case 13: {
                return "EXECUTION_ENVIRONMENT";
            }
            case 15: {
                return "EXPANDED_SUPERINTERFACES_SET";
            }
            case 42: {
                return "EXPANDED_SUPERINTERFACES_SET_BREAKING";
            }
            case 16: {
                return "FIELD";
            }
            case 17: {
                return "FIELD_MOVED_UP";
            }
            case 18: {
                return "FINAL_TO_NON_FINAL";
            }
            case 19: {
                return "FINAL_TO_NON_FINAL_NON_STATIC";
            }
            case 20: {
                return "FINAL_TO_NON_FINAL_STATIC_CONSTANT";
            }
            case 21: {
                return "FINAL_TO_NON_FINAL_STATIC_NON_CONSTANT";
            }
            case 22: {
                return "INCREASE_ACCESS";
            }
            case 23: {
                return "INTERFACE_BOUND";
            }
            case 25: {
                return "METHOD";
            }
            case 73: 
            case 74: {
                return "DEFAULT_METHOD";
            }
            case 26: {
                return "METHOD_MOVED_UP";
            }
            case 27: {
                return "METHOD_WITH_DEFAULT_VALUE";
            }
            case 28: {
                return "METHOD_WITHOUT_DEFAULT_VALUE";
            }
            case 29: {
                return "NATIVE_TO_NON_NATIVE";
            }
            case 30: {
                return "NON_ABSTRACT_TO_ABSTRACT";
            }
            case 31: {
                return "NON_FINAL_TO_FINAL";
            }
            case 32: {
                return "NON_NATIVE_TO_NATIVE";
            }
            case 33: {
                return "NON_STATIC_TO_STATIC";
            }
            case 34: {
                return "NON_SYNCHRONIZED_TO_SYNCHRONIZED";
            }
            case 35: {
                return "NON_TRANSIENT_TO_TRANSIENT";
            }
            case 36: {
                return "OVERRIDEN_METHOD";
            }
            case 38: {
                return "STATIC_TO_NON_STATIC";
            }
            case 39: {
                return "SUPERCLASS";
            }
            case 40: {
                return "SYNCHRONIZED_TO_NON_SYNCHRONIZED";
            }
            case 41: {
                return "TYPE_CONVERSION";
            }
            case 45: {
                return "TRANSIENT_TO_NON_TRANSIENT";
            }
            case 46: {
                return "TYPE";
            }
            case 47: {
                return "TYPE_ARGUMENTS";
            }
            case 48: {
                return "TYPE_MEMBER";
            }
            case 49: {
                return "TYPE_PARAMETER";
            }
            case 50: {
                return "TYPE_PARAMETER_NAME";
            }
            case 51: {
                return "TYPE_PARAMETERS";
            }
            case 52: {
                return "TYPE_VISIBILITY";
            }
            case 53: {
                return "UNCHECKED_EXCEPTION";
            }
            case 54: {
                return "VALUE";
            }
            case 55: {
                return "VARARGS_TO_ARRAY";
            }
            case 37: {
                return "RESTRICTIONS";
            }
            case 56: {
                return "API_TYPE";
            }
            case 57: {
                return "NON_VOLATILE_TO_VOLATILE";
            }
            case 58: {
                return "VOLATILE_TO_NON_VOLATILE";
            }
            case 60: {
                return "MINOR_VERSION";
            }
            case 59: {
                return "MAJOR_VERSION";
            }
            case 61: {
                return "API_FIELD";
            }
            case 62: {
                return "API_METHOD";
            }
            case 63: {
                return "API_CONSTRUCTOR";
            }
            case 64: {
                return "API_ENUM_CONSTANT";
            }
            case 65: {
                return "API_METHOD_WITH_DEFAULT_VALUE";
            }
            case 66: {
                return "API_METHOD_WITHOUT_DEFAULT_VALUE";
            }
            case 68: {
                return "TYPE_ARGUMENT";
            }
            case 69: {
                return "SUPER_INTERFACE_WITH_METHODS";
            }
            case 71: {
                return "REEXPORTED_API_TYPE";
            }
            case 70: {
                return "REEXPORTED_TYPE";
            }
            case 67: {
                return "METHOD_MOVED_DOWN";
            }
            case 72: {
                return "DEPRECATION";
            }
        }
        return UNKNOWN_FLAGS;
    }

    public static String getDeltaKindName(IDelta delta) {
        return Util.getDeltaKindName(delta.getKind());
    }

    public static String getDeltaKindName(int kind) {
        switch (kind) {
            case 1: {
                return "ADDED";
            }
            case 2: {
                return "CHANGED";
            }
            case 3: {
                return "REMOVED";
            }
        }
        return UNKNOWN_KIND;
    }

    public static String getDeltaPrefererenceKey(int elementType, int kind, int flags) {
        StringBuilder buffer = new StringBuilder(Util.getDeltaElementType(elementType));
        buffer.append('_').append(Util.getDeltaKindName(kind));
        if (flags != -1) {
            buffer.append('_');
            switch (flags) {
                case 61: {
                    buffer.append(Util.getDeltaFlagsName(16));
                    break;
                }
                case 64: {
                    buffer.append(Util.getDeltaFlagsName(12));
                    break;
                }
                case 63: {
                    buffer.append(Util.getDeltaFlagsName(8));
                    break;
                }
                case 62: {
                    buffer.append(Util.getDeltaFlagsName(25));
                    break;
                }
                case 65: {
                    if (kind == 3) {
                        buffer.append(Util.getDeltaFlagsName(25));
                        break;
                    }
                    buffer.append(Util.getDeltaFlagsName(27));
                    break;
                }
                case 66: {
                    if (kind == 3) {
                        buffer.append(Util.getDeltaFlagsName(25));
                        break;
                    }
                    buffer.append(Util.getDeltaFlagsName(28));
                    break;
                }
                case 27: {
                    if (kind == 3) {
                        buffer.append(Util.getDeltaFlagsName(25));
                        break;
                    }
                    buffer.append(Util.getDeltaFlagsName(27));
                    break;
                }
                case 28: {
                    if (kind == 3) {
                        buffer.append(Util.getDeltaFlagsName(25));
                        break;
                    }
                    buffer.append(Util.getDeltaFlagsName(28));
                    break;
                }
                default: {
                    buffer.append(Util.getDeltaFlagsName(flags));
                }
            }
        }
        return String.valueOf(buffer);
    }

    public static String getDetail(IDelta delta) {
        StringBuilder buffer = new StringBuilder();
        switch (delta.getElementType()) {
            case 4: {
                buffer.append("class");
                break;
            }
            case 1: {
                buffer.append("annotation");
                break;
            }
            case 8: {
                buffer.append("interface");
                break;
            }
            case 2: {
                buffer.append("api component");
                break;
            }
            case 3: {
                buffer.append("api baseline");
                break;
            }
            case 9: {
                buffer.append("method");
                break;
            }
            case 5: {
                buffer.append("constructor");
                break;
            }
            case 6: {
                buffer.append("enum");
                break;
            }
            case 7: {
                buffer.append("field");
                break;
            }
        }
        buffer.append(' ');
        switch (delta.getKind()) {
            case 1: {
                buffer.append("added");
                break;
            }
            case 3: {
                buffer.append("removed");
                break;
            }
            case 2: {
                buffer.append("changed");
                break;
            }
            default: {
                buffer.append("unknown kind");
            }
        }
        buffer.append(' ').append(Util.getDeltaFlagsName(delta.getFlags())).append(' ').append(delta.getTypeName()).append("#").append(delta.getKey());
        return String.valueOf(buffer);
    }

    public static IDocument getDocument(ICompilationUnit cu) throws CoreException {
        IFile file;
        if (cu.getOwner() == null && (file = (IFile)cu.getResource()).exists()) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            IPath path = cu.getPath();
            bufferManager.connect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            try {
                IDocument iDocument = bufferManager.getTextFileBuffer(path, LocationKind.IFILE).getDocument();
                return iDocument;
            }
            finally {
                bufferManager.disconnect(path, LocationKind.IFILE, null);
            }
        }
        return new Document(cu.getSource());
    }

    public static Properties getEEProfile(String eeId) {
        String profileName = eeId + ".profile";
        InputStream stream = Util.class.getResourceAsStream("profiles/" + profileName);
        if (stream != null) {
            try {
                Properties profile = new Properties();
                profile.load(stream);
                Properties properties = profile;
                return properties;
            }
            catch (IOException e) {
                ApiPlugin.log(e);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                }
            }
        }
        return null;
    }

    public static final int getFragmentNumber(String version) {
        char[] charArray;
        int length;
        if (version == null) {
            throw new IllegalArgumentException("The given version should not be null");
        }
        int index = version.indexOf(32);
        if (index + 1 >= (length = (charArray = version.toCharArray()).length)) {
            return -1;
        }
        int counter = 1;
        int i = index + 1;
        while (i < length) {
            switch (charArray[i]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                case '.': {
                    ++counter;
                    break;
                }
                default: {
                    return -1;
                }
            }
            ++i;
        }
        return counter;
    }

    public static IMember getIMember(IDelta delta, IJavaProject javaProject) {
        IType sourceType;
        String typeName = delta.getTypeName();
        if (typeName == null) {
            return null;
        }
        IType type = null;
        try {
            type = javaProject.findType(typeName.replace('$', '.'));
        }
        catch (JavaModelException javaModelException) {}
        IType typeInProject = Util.getTypeInSameJavaProject(type, typeName, javaProject);
        if (typeInProject != null) {
            type = typeInProject;
        }
        if (type instanceof BinaryType && (sourceType = Util.findSourceTypeinJavaProject(javaProject, delta.getTypeName().replace('$', '.'))) != null) {
            type = sourceType;
        }
        if (type == null) {
            return null;
        }
        String key = delta.getKey();
        switch (delta.getElementType()) {
            case 7: {
                IField field = type.getField(key);
                if (!field.exists()) break;
                return field;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                block7 : switch (delta.getKind()) {
                    case 1: {
                        switch (delta.getFlags()) {
                            case 12: 
                            case 16: {
                                IField field = type.getField(key);
                                if (!field.exists()) break block7;
                                return field;
                            }
                            case 8: 
                            case 25: 
                            case 27: 
                            case 28: 
                            case 73: 
                            case 74: {
                                return Util.getMethod(type, key);
                            }
                            case 48: {
                                IType type2 = type.getType(key);
                                if (!type2.exists()) break block7;
                                return type2;
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (delta.getFlags()) {
                            case 61: 
                            case 64: {
                                IField field = type.getField(key);
                                if (!field.exists()) break block7;
                                return field;
                            }
                            case 62: 
                            case 63: 
                            case 65: 
                            case 66: {
                                return Util.getMethod(type, key);
                            }
                        }
                        break;
                    }
                }
                return type;
            }
            case 5: 
            case 9: {
                return Util.getMethod(type, key);
            }
            case 2: {
                return type;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static IType updateType(String typeName, IJavaProject javaProject) throws JavaModelException {
        String typeNameWithDot = typeName.replace('$', '.');
        String typeNameWithSeparator = typeNameWithDot.replace(".", "/");
        IPath path = IPath.fromOSString((String)typeNameWithSeparator);
        IPath pathExceptLastSegment = path.removeLastSegments(1);
        IJavaElement packFrag = javaProject.findElement(pathExceptLastSegment, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
        IJavaElement iJavaElement = packFrag;
        if (iJavaElement instanceof PackageFragment) {
            void pf;
            PackageFragment packageFragment = (PackageFragment)iJavaElement;
            PackageFragment cfr_ignored_0 = (PackageFragment)iJavaElement;
            ArrayList children = pf.getChildrenOfType(5);
            for (JavaElement object : children) {
                void compilationUn;
                JavaElement javaElement = object;
                if (!(javaElement instanceof CompilationUnit)) continue;
                CompilationUnit cfr_ignored_1 = (CompilationUnit)javaElement;
                CompilationUnit cfr_ignored_2 = (CompilationUnit)javaElement;
                ITypeRoot typeRoot = compilationUn.getTypeRoot();
                if (typeRoot.findPrimaryType() == null || !typeRoot.findPrimaryType().getFullyQualifiedName().equals(typeName.replace('$', '.'))) continue;
                return typeRoot.findPrimaryType();
            }
            ArrayList children2 = pf.getChildrenOfType(6);
            for (JavaElement object : children2) {
                void compilationUn;
                JavaElement javaElement = object;
                if (!(javaElement instanceof ClassFile)) continue;
                ClassFile cfr_ignored_3 = (ClassFile)javaElement;
                ClassFile cfr_ignored_4 = (ClassFile)javaElement;
                ITypeRoot typeRoot = compilationUn.getTypeRoot();
                if (typeRoot.findPrimaryType() == null || !typeRoot.findPrimaryType().getFullyQualifiedName().equals(typeName.replace('$', '.'))) continue;
                return typeRoot.findPrimaryType();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static IType getTypeInSameJavaProject(IType type, String typeName, IJavaProject javaProject) {
        if (type == null) {
            return null;
        }
        IJavaElement ancestor = type.getAncestor(2);
        IType newType = null;
        try {
            IJavaElement iJavaElement = ancestor;
            if (iJavaElement instanceof IJavaProject) {
                void pro;
                IJavaProject iJavaProject = (IJavaProject)iJavaElement;
                IJavaProject cfr_ignored_0 = (IJavaProject)iJavaElement;
                if (!pro.equals(javaProject) && (newType = Util.updateType(typeName, javaProject)) != null) {
                    return newType;
                }
            }
        }
        catch (Exception exception) {}
        return newType;
    }

    private static IMember getMethod(IType type, String key) {
        IMethod[] methods;
        String[] parameterTypes;
        String signature;
        IMethod method;
        String descriptor;
        String selector;
        block32: {
            boolean isGeneric = false;
            int indexOfTypeVariable = key.indexOf(60);
            int index = 0;
            if (indexOfTypeVariable == -1) {
                indexOfParen = key.indexOf(40);
                if (indexOfParen == -1) {
                    return null;
                }
                index = indexOfParen;
            } else {
                indexOfParen = key.indexOf(40);
                if (indexOfParen == -1) {
                    return null;
                }
                if (indexOfParen < indexOfTypeVariable) {
                    index = indexOfParen;
                } else {
                    index = indexOfTypeVariable;
                    isGeneric = true;
                }
            }
            selector = key.substring(0, index);
            descriptor = key.substring(index, key.length());
            method = null;
            signature = descriptor.replace('/', '.');
            parameterTypes = null;
            if (isGeneric) {
                signature = signature.substring(signature.indexOf(40));
                parameterTypes = Signature.getParameterTypes((String)signature);
            } else {
                parameterTypes = Signature.getParameterTypes((String)signature);
            }
            try {
                method = type.getMethod(selector, parameterTypes);
            }
            catch (IllegalArgumentException e) {
                ApiPlugin.log(e);
            }
            if (method == null) {
                return null;
            }
            if (method.exists()) {
                return method;
            }
            if (selector.equals(type.getElementName())) {
                String parentTypeSig;
                if (parameterTypes.length == 0) {
                    return null;
                }
                IJavaElement parent = type.getParent();
                if (parent instanceof IType && Signatures.matches(parentTypeSig = Signature.createTypeSignature((String)((IType)parent).getFullyQualifiedName(), (boolean)true), parameterTypes[0])) {
                    IMethod constructor = type.getMethod(selector, Arrays.copyOfRange(parameterTypes, 1, parameterTypes.length));
                    try {
                        if (constructor.exists() && constructor.isConstructor()) {
                            return constructor;
                        }
                        String contructorSig = Signature.createMethodSignature((String[])Arrays.copyOfRange(parameterTypes, 1, parameterTypes.length), (String)Signature.getReturnType((String)signature));
                        IMethod[] methods2 = type.findMethods(constructor);
                        if (methods2 == null) break block32;
                        if (methods2.length == 1 && methods2[0].isConstructor()) {
                            return methods2[0];
                        }
                        IMethod[] iMethodArray = methods2;
                        int n = methods2.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMethod m = iMethodArray[n2];
                            try {
                                if (m.isConstructor() && m.getNumberOfParameters() == parameterTypes.length - 1 && Signatures.matchesSignatures(Util.generateBinarySignature(m), contructorSig)) {
                                    return m;
                                }
                            }
                            catch (JavaModelException javaModelException) {}
                            ++n2;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
            }
        }
        if ((methods = type.findMethods(method)) != null && methods.length == 1) {
            return methods[0];
        }
        if (methods == null || methods.length == 0) {
            try {
                methods = type.getMethods();
            }
            catch (JavaModelException e) {
                ApiPlugin.log(Status.error((String)NLS.bind((String)"Unable to retrieve methods for {0}", (Object)type.getFullyQualifiedName()), (Throwable)e));
                return null;
            }
        }
        IMethod[] iMethodArray = methods;
        int n = methods.length;
        int constructor = 0;
        while (constructor < n) {
            IMethod m = iMethodArray[constructor];
            try {
                if (m.getElementName().equals(selector) && m.getNumberOfParameters() == parameterTypes.length && Signatures.matchesSignatures(Util.generateBinarySignature(m), signature)) {
                    return m;
                }
            }
            catch (JavaModelException javaModelException) {}
            ++constructor;
        }
        StringBuilder sb = new StringBuilder();
        IMethod[] iMethodArray2 = methods;
        int n3 = methods.length;
        n = 0;
        while (n < n3) {
            IMethod m = iMethodArray2[n];
            sb.append('\n').append(m.getHandleIdentifier());
            ++n;
        }
        ApiPlugin.log(Status.error((String)(NLS.bind((String)UtilMessages.Util_6, (Object)selector, (Object)descriptor) + String.valueOf(sb))));
        return null;
    }

    private static String generateBinarySignature(IMethod method) throws JavaModelException {
        ITypeParameter[] typeTPs = method.getDeclaringType().getTypeParameters();
        ITypeParameter[] methodTPs = method.getTypeParameters();
        if (typeTPs.length == 0 && methodTPs.length == 0) {
            return method.getSignature();
        }
        HashMap<String, String> lookup = new HashMap<String, String>();
        Stream.concat(Stream.of(typeTPs), Stream.of(methodTPs)).forEach(tp -> {
            try {
                String[] sigs = tp.getBoundsSignatures();
                lookup.put(tp.getElementName(), sigs.length == 1 ? sigs[0] : "Ljava.lang.Object;");
            }
            catch (JavaModelException javaModelException) {}
        });
        String[] parameterTypes = (String[])Stream.of(method.getParameterTypes()).map(p -> Util.expandParameterType(p, lookup)).toArray(String[]::new);
        return Signature.createMethodSignature((String[])parameterTypes, (String)Util.expandParameterType(method.getReturnType(), lookup));
    }

    private static String expandParameterType(String parameterTypeSig, Map<String, String> bounds) {
        String repl;
        String erased = Signature.getTypeErasure((String)parameterTypeSig);
        if ((erased.charAt(0) == 'Q' || erased.charAt(0) == 'T') && (repl = bounds.get(Signature.getSignatureSimpleName((String)erased))) != null) {
            return repl;
        }
        return erased;
    }

    public static char[] getInputStreamAsCharArray(InputStream stream, String encoding) throws IOException {
        Charset charset = null;
        try {
            charset = Charset.forName(encoding);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            System.err.println("Illegal charset name : " + encoding);
            return null;
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            System.err.println("Unsupported charset : " + encoding);
            return null;
        }
        return Util.getInputStreamAsCharArray(stream, charset);
    }

    public static char[] getInputStreamAsCharArray(InputStream stream, Charset charset) throws IOException {
        CharsetDecoder charsetDecoder = charset.newDecoder();
        charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        byte[] contents = stream.readAllBytes();
        ByteBuffer byteBuffer = ByteBuffer.allocate(contents.length);
        byteBuffer.put(contents);
        byteBuffer.flip();
        CharBuffer charBuffer = charsetDecoder.decode(byteBuffer);
        charBuffer.compact();
        char[] array = charBuffer.array();
        int lengthToBe = charBuffer.position();
        if (array.length > lengthToBe) {
            char[] cArray = array;
            array = new char[lengthToBe];
            System.arraycopy(cArray, 0, array, 0, lengthToBe);
        }
        return array;
    }

    public static IResource getManifestFile(IProject currentProject) {
        return currentProject.findMember("META-INF/MANIFEST.MF");
    }

    public static boolean isApiProblemMarker(IMarker marker) {
        return marker.getAttribute("apiMarkerID", -1) > 0;
    }

    public static IReferenceTypeDescriptor getType(String fullyQualifiedName) {
        int index = fullyQualifiedName.lastIndexOf(46);
        String pkg = index == -1 ? "" : fullyQualifiedName.substring(0, index);
        String type = index == -1 ? fullyQualifiedName : fullyQualifiedName.substring(index + 1);
        return Factory.packageDescriptor(pkg).getType(type);
    }

    public static boolean isApiProject(IProject project) {
        try {
            return project.hasNature("org.eclipse.pde.api.tools.apiAnalysisNature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean isJavaProject(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean isApiProject(IJavaProject project) {
        if (project != null) {
            return Util.isApiProject(project.getProject());
        }
        return false;
    }

    /*
     * Loose catch block
     */
    public static boolean isApiToolsComponent(IApiComponent apiComponent) {
        File file = new File(apiComponent.getLocation());
        if (file.exists()) {
            if (file.isDirectory()) {
                File apiDescription = new File(file, ".api_description");
                return apiDescription.exists();
            }
            ZipFile zipFile = null;
            zipFile = new ZipFile(file);
            boolean bl = zipFile.getEntry(".api_description") != null;
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {}
            return bl;
            catch (IOException iOException) {
                try {}
                catch (Throwable throwable) {
                    try {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException iOException3) {}
            }
        }
        return false;
    }

    public static boolean hasJavaPackages(IApiComponent apiComponent) {
        try {
            String[] packageNames = apiComponent.getPackageNames();
            return packageNames.length > 0;
        }
        catch (CoreException e) {
            ApiPlugin.log("Failed to check java packages for " + apiComponent.getName(), e);
            return true;
        }
    }

    public static boolean isArchive(String fileName) {
        return Util.isZipJarFile(fileName) || Util.isTGZFile(fileName);
    }

    public static boolean isZipJarFile(String fileName) {
        String normalizedFileName = fileName.toLowerCase();
        return normalizedFileName.endsWith(DOT_ZIP) || normalizedFileName.endsWith(DOT_JAR);
    }

    public static boolean isTGZFile(String fileName) {
        String normalizedFileName = fileName.toLowerCase();
        return normalizedFileName.endsWith(DOT_TAR_GZ) || normalizedFileName.endsWith(DOT_TGZ);
    }

    public static boolean isClass(int accessFlags) {
        return (accessFlags & 0x6200) == 0;
    }

    public static boolean isClassFile(String fileName) {
        return fileName.toLowerCase().endsWith(DOT_CLASS_SUFFIX);
    }

    public static boolean isDefault(int accessFlags) {
        return (accessFlags & 7) == 0;
    }

    public static final boolean isDifferentVersion(String versionToBeChecked, String referenceVersion) {
        SinceTagVersion sinceTagVersion1 = null;
        SinceTagVersion sinceTagVersion2 = null;
        try {
            sinceTagVersion1 = new SinceTagVersion(versionToBeChecked);
            sinceTagVersion2 = new SinceTagVersion(referenceVersion);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        Version version1 = sinceTagVersion1.getVersion();
        Version version2 = sinceTagVersion2.getVersion();
        if (version1.getMajor() != version2.getMajor()) {
            return true;
        }
        if (version1.getMinor() != version2.getMinor()) {
            return true;
        }
        return version1.getMicro() != version2.getMicro();
    }

    public static boolean isJavaFileName(String fileName) {
        return fileName.toLowerCase().endsWith(DOT_JAVA_SUFFIX);
    }

    public static boolean isJavaLangObject(String name) {
        return name != null && name.equals(JAVA_LANG_OBJECT);
    }

    public static boolean isJavaLangRuntimeException(String name) {
        return name != null && name.equals(JAVA_LANG_RUNTIMEEXCEPTION);
    }

    public static boolean isVisible(int modifiers) {
        return Flags.isProtected((int)modifiers) || Flags.isPublic((int)modifiers);
    }

    public static boolean isBinaryProject(IProject project) {
        return WorkspaceModelManager.isBinaryProject((IProject)project);
    }

    public static org.w3c.dom.Document newDocument() throws CoreException {
        try {
            return XmlProcessorFactory.newDocumentWithErrorOnDOCTYPE();
        }
        catch (ParserConfigurationException e) {
            throw new CoreException(Status.error((String)"Unable to create new XML document.", (Throwable)e));
        }
    }

    public static Element parseDocument(String document) throws CoreException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ByteArrayInputStream stream = new ByteArrayInputStream(document.getBytes(StandardCharsets.UTF_8));){
                DocumentBuilder parser = XmlProcessorFactory.createDocumentBuilderWithErrorOnDOCTYPE();
                parser.setErrorHandler(new DefaultHandler());
                return parser.parse(stream).getDocumentElement();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | FactoryConfigurationError | ParserConfigurationException | SAXException e) {
            throw new CoreException(Status.error((String)"Unable to parse XML document.", (Throwable)e));
        }
    }

    public static void saveFile(File file, String contents) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(contents);
            writer.flush();
        }
        catch (Throwable throwable) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String getFileContentAsString(File file) {
        String contents;
        block14: {
            contents = null;
            FileInputStream stream = null;
            try {
                try {
                    stream = new FileInputStream(file);
                    char[] array = Util.getInputStreamAsCharArray((InputStream)stream, StandardCharsets.UTF_8);
                    contents = new String(array);
                }
                catch (IOException ioe) {
                    ApiPlugin.log(ioe);
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return contents;
    }

    public static InputStream getInputStreamFromString(String string) {
        return new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
    }

    public static String serializeDocument(org.w3c.dom.Document document) throws CoreException {
        try {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            TransformerFactory factory = XmlProcessorFactory.createTransformerFactoryWithErrorOnDOCTYPE();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(document);
            StreamResult outputTarget = new StreamResult(s);
            transformer.transform(source, outputTarget);
            return s.toString("UTF-8");
        }
        catch (IOException | TransformerException e) {
            throw new CoreException(Status.error((String)"Unable to serialize XML document.", (Throwable)e));
        }
    }

    /*
     * Exception decompiling
     */
    public static void unzip(String zipPath, String destDirPath) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void guntar(String zipPath, String destDirPath) throws TarException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TarFile tarFile = new TarFile(new File(zipPath));){
            byte[] buf = new byte[8192];
            for (TarEntry zEntry : tarFile.entries()) {
                if (zEntry.getFileType() == 53) {
                    new File(destDirPath, zEntry.getName()).mkdirs();
                    continue;
                }
                String filePath = zEntry.getName();
                int lastSeparator = filePath.lastIndexOf("/");
                String fileDir = "";
                if (lastSeparator >= 0) {
                    fileDir = filePath.substring(0, lastSeparator);
                }
                new File(destDirPath, fileDir).mkdirs();
                File outFile = new File(destDirPath, filePath);
                Throwable throwable2 = null;
                Object var13_16 = null;
                try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outFile));){
                    int n = 0;
                    Throwable throwable3 = null;
                    Object var17_22 = null;
                    try (BufferedInputStream stream = new BufferedInputStream(tarFile.getInputStream(zEntry));){
                        while ((n = stream.read(buf)) >= 0) {
                            outputStream.write(buf, 0, n);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    public static File getEEDescriptionFile() {
        File fakeEEFile = null;
        try (PrintWriter writer = null;){
            try {
                fakeEEFile = Util.createTempFile("eefile", ".ee");
                writer = new PrintWriter(new BufferedWriter(new FileWriter(fakeEEFile)));
                writer.print("-Djava.home=");
                writer.println(System.getProperty("java.home"));
                writer.print("-Dee.bootclasspath=");
                writer.println(Util.getJavaClassLibsAsString());
                writer.println("-Dee.language.level=1.6");
                writer.println("-Dee.class.library.level=JavaSE-1.6");
                writer.flush();
            }
            catch (IOException iOException) {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        return fakeEEFile;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return Util.recordTempFile(Files.createTempFile(prefix, suffix, new FileAttribute[0]).toFile());
    }

    public static File createTempDirectory(String prefix) throws IOException {
        return Util.recordTempFile(Files.createTempDirectory(prefix, new FileAttribute[0]).toFile());
    }

    private static File recordTempFile(File file) throws IOException {
        file.deleteOnExit();
        FileManager.getManager().recordTempFileRoot(file.getCanonicalPath());
        return file;
    }

    public static String getJavaClassLibsAsString() {
        String[] libs = Util.getJavaClassLibs();
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        int max = libs.length;
        while (i < max) {
            if (i > 0) {
                buffer.append(File.pathSeparatorChar);
            }
            buffer.append(libs[i]);
            ++i;
        }
        return String.valueOf(buffer);
    }

    public static String[] getJavaClassLibs() {
        String bootclasspathProperty = System.getProperty("sun.boot.class.path");
        if (!(bootclasspathProperty != null && bootclasspathProperty.length() != 0 || (bootclasspathProperty = System.getProperty("vm.boot.class.path")) != null && bootclasspathProperty.length() != 0)) {
            bootclasspathProperty = System.getProperty("org.apache.harmony.boot.class.path");
        }
        String[] jars = null;
        if (bootclasspathProperty != null && bootclasspathProperty.length() != 0) {
            StringTokenizer tokenizer = new StringTokenizer(bootclasspathProperty, File.pathSeparator);
            int size = tokenizer.countTokens();
            jars = new String[size];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                String fileName = Util.toNativePath(tokenizer.nextToken());
                if (!new File(fileName).exists()) continue;
                jars[i] = fileName;
                ++i;
            }
            if (size != i) {
                String[] stringArray = jars;
                jars = new String[i];
                System.arraycopy(stringArray, 0, jars, 0, i);
            }
        } else {
            String jreDir = System.getProperty("java.home");
            String osName = System.getProperty("os.name");
            if (jreDir == null) {
                return new String[0];
            }
            if (osName.startsWith("Mac")) {
                return new String[]{Util.toNativePath(jreDir + "/../Classes/classes.jar")};
            }
            String vmName = System.getProperty("java.vm.name");
            if ("J9".equals(vmName)) {
                return new String[]{Util.toNativePath(jreDir + "/lib/jclMax/classes.zip")};
            }
            String[] jarsNames = null;
            ArrayList<String> paths = new ArrayList<String>();
            if ("DRLVM".equals(vmName)) {
                FilenameFilter jarFilter = (dir, name) -> name.endsWith(DOT_JAR) && !name.endsWith("-src.jar");
                jarsNames = new File(jreDir + "/lib/boot/").list(jarFilter);
                Util.addJarEntries(jreDir + "/lib/boot/", jarsNames, paths);
            } else {
                jarsNames = new String[]{"/lib/vm.jar", "/lib/rt.jar", "/lib/core.jar", "/lib/security.jar", "/lib/xml.jar", "/lib/graphics.jar"};
                Util.addJarEntries(jreDir, jarsNames, paths);
            }
            jars = new String[paths.size()];
            paths.toArray(jars);
        }
        return jars;
    }

    public static String toNativePath(String path) {
        String nativePath = path.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        return nativePath.endsWith("/") || nativePath.endsWith("\\") ? nativePath.substring(0, nativePath.length() - 1) : nativePath;
    }

    private static void addJarEntries(String jreDir, String[] jarNames, ArrayList<String> paths) {
        String[] stringArray = jarNames;
        int n = jarNames.length;
        int n2 = 0;
        while (n2 < n) {
            String jarName = stringArray[n2];
            String currentName = jreDir + jarName;
            File f = new File(currentName);
            if (f.exists()) {
                paths.add(Util.toNativePath(currentName));
            }
            ++n2;
        }
    }

    public static boolean delete(File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            Util.flushDirectoryContent(file);
        }
        file.delete();
        if (Util.isFileDeleted(file)) {
            return true;
        }
        return Util.waitUntilFileDeleted(file);
    }

    public static void flushDirectoryContent(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            Util.delete(file);
            ++n2;
        }
    }

    private static boolean waitUntilFileDeleted(File file) {
        int count = 0;
        int delay = 10;
        int maxRetry = DELETE_MAX_WAIT / delay;
        int time = 0;
        while (count < maxRetry) {
            block8: {
                block7: {
                    ++count;
                    Thread.sleep(delay);
                    if ((time += delay) > DELETE_MAX_TIME) {
                        DELETE_MAX_TIME = time;
                    }
                    if (DELETE_DEBUG) {
                        System.out.print('.');
                    }
                    if (!file.exists() || !file.delete()) break block7;
                    return true;
                }
                if (!Util.isFileDeleted(file)) break block8;
                return true;
            }
            try {
                if (count < 10 || delay > 100) continue;
                count = 1;
                maxRetry = DELETE_MAX_WAIT / (delay *= 10);
                if (DELETE_MAX_WAIT % delay == 0) continue;
                ++maxRetry;
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        System.err.println();
        System.err.println("\t!!! ERROR: " + String.valueOf(file) + " was never deleted even after having waited " + DELETE_MAX_TIME + "ms!!!");
        System.err.println();
        return false;
    }

    public static boolean isFileDeleted(File file) {
        return !file.exists() && Util.getParentChildFile(file) == null;
    }

    private static File getParentChildFile(File file) {
        int length;
        File parent = file.getParentFile();
        if (parent == null || !parent.exists()) {
            return null;
        }
        File[] files = parent.listFiles();
        if (files == null) {
            return null;
        }
        int n = length = files == null ? 0 : files.length;
        if (length > 0) {
            int i = 0;
            while (i < length) {
                if (files[i] == file) {
                    return files[i];
                }
                if (files[i].equals(file)) {
                    return files[i];
                }
                if (files[i].getPath().equals(file.getPath())) {
                    return files[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static Set<String> convertAsSet(String[] values) {
        HashSet<String> set = new HashSet<String>();
        if (values != null && values.length != 0) {
            Collections.addAll(set, values);
        }
        return set;
    }

    public static String getDeltaComponentVersionsId(IApiComponent component) {
        StringBuilder buffer = new StringBuilder(component.getSymbolicName());
        String version = component.getVersion();
        if (version != null) {
            buffer.append('(');
            try {
                Version version2 = new Version(version);
                buffer.append(version2.getMajor()).append('.').append(version2.getMinor()).append('.').append(version2.getMicro());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                buffer.append(version);
            }
            buffer.append(')');
        }
        return String.valueOf(buffer);
    }

    public static String getComponentVersionsId(IApiComponent component) {
        StringBuilder buffer = new StringBuilder(component.getSymbolicName());
        String version = component.getVersion();
        if (version != null) {
            buffer.append('_');
            try {
                Version version2 = new Version(version);
                buffer.append(version2.getMajor()).append('.').append(version2.getMinor()).append('.').append(version2.getMicro());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                buffer.append(version);
            }
        }
        return String.valueOf(buffer);
    }

    public static String getDescriptorName(IApiType descriptor) {
        String typeName = descriptor.getName();
        int index = typeName.lastIndexOf(36);
        if (index != -1) {
            return typeName.replace('$', '.');
        }
        return typeName;
    }

    public static String getDeltaArgumentString(IDelta delta) {
        String[] arguments = delta.getArguments();
        switch (delta.getFlags()) {
            case 46: 
            case 48: {
                return arguments[0];
            }
            case 8: 
            case 12: 
            case 16: 
            case 25: 
            case 27: 
            case 28: 
            case 73: 
            case 74: {
                return arguments[1];
            }
            case 22: {
                switch (delta.getElementType()) {
                    case 5: 
                    case 7: 
                    case 9: {
                        return arguments[1];
                    }
                }
                return arguments[0];
            }
        }
        return "";
    }

    public static String getApiElementType(int type) {
        switch (type) {
            case 3: {
                return "API_TYPE_CONTAINER";
            }
            case 7: {
                return "API_TYPE_ROOT";
            }
            case 4: {
                return "BASELINE";
            }
            case 1: {
                return "COMPONENT";
            }
            case 5: {
                return "FIELD";
            }
            case 6: {
                return "METHOD";
            }
            case 2: {
                return "TYPE";
            }
        }
        return "UNKNOWN";
    }

    public static boolean isConstructor(String referenceMemberName) {
        char[] init = ConstantPool.Init;
        return Arrays.equals(init, referenceMemberName.toCharArray());
    }

    public static boolean isManifest(IPath path) {
        return MANIFEST_PROJECT_RELATIVE_PATH.equals((Object)path);
    }

    public static void touchCorrespondingResource(IProject project, IResource resource, String typeName) {
        if (typeName != null && typeName != "!global!") {
            if (Util.isManifest(resource.getProjectRelativePath())) {
                try {
                    IResource cuResource;
                    ICompilationUnit compilationUnit;
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    IType findType = javaProject.findType(typeName);
                    IType typeInProject = Util.getTypeInSameJavaProject(findType, typeName, javaProject);
                    if (typeInProject != null) {
                        findType = typeInProject;
                    }
                    if (findType != null && (compilationUnit = findType.getCompilationUnit()) != null && (cuResource = compilationUnit.getResource()) != null) {
                        cuResource.touch(null);
                    }
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                }
            } else {
                try {
                    resource.touch(null);
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                }
            }
        }
    }

    public static String getTypeNameFromMarker(IMarker marker) {
        return marker.getAttribute("problemTypeName", null);
    }

    public static IApiComponent[] getReexportedComponents(IApiComponent component) {
        block6: {
            ArrayList<IApiComponent> reexportedComponents;
            block7: {
                IRequiredComponentDescription[] requiredComponents = component.getRequiredComponents();
                int length = requiredComponents.length;
                if (length == 0) break block6;
                reexportedComponents = null;
                IApiBaseline baseline = component.getBaseline();
                int i = 0;
                while (i < length) {
                    String id;
                    IApiComponent reexportedComponent;
                    IRequiredComponentDescription description = requiredComponents[i];
                    if (description.isExported() && (reexportedComponent = baseline.getApiComponent(id = description.getId())) != null) {
                        if (reexportedComponents == null) {
                            reexportedComponents = new ArrayList<IApiComponent>();
                        }
                        reexportedComponents.add(reexportedComponent);
                    }
                    ++i;
                }
                if (reexportedComponents != null && !reexportedComponents.isEmpty()) break block7;
                return null;
            }
            try {
                return reexportedComponents.toArray(new IApiComponent[reexportedComponents.size()]);
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
        }
        return null;
    }

    public static IResource getResource(IProject project, IType type) {
        try {
            IResource resource;
            ICompilationUnit unit;
            if (type != null && (unit = type.getCompilationUnit()) != null && (resource = unit.getCorrespondingResource()) != null && resource.exists()) {
                return resource;
            }
        }
        catch (JavaModelException e) {
            ApiPlugin.log(e);
        }
        return Util.getManifestFile(project);
    }

    public static FilteredElements initializeRegexFilterList(String location, IApiBaseline baseline, boolean debug) throws CoreException {
        FilteredElements excludedElements = new FilteredElements();
        if (location != null) {
            Object var7_12;
            File file = new File(location);
            char[] contents = null;
            try {
                Throwable throwable = null;
                var7_12 = null;
                try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
                    contents = Util.getInputStreamAsCharArray((InputStream)stream, StandardCharsets.ISO_8859_1);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                throw new CoreException(Status.error((String)NLS.bind((String)UtilMessages.Util_couldNotFindFilterFile, (Object)location), (Throwable)e));
            }
            catch (IOException e) {
                throw new CoreException(Status.error((String)NLS.bind((String)UtilMessages.Util_problemWithFilterFile, (Object)location), (Throwable)e));
            }
            if (contents != null) {
                try {
                    Throwable e = null;
                    var7_12 = null;
                    try (LineNumberReader reader = new LineNumberReader(new StringReader(new String(contents)));){
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                            if (line.startsWith(REGULAR_EXPRESSION_START)) {
                                if (baseline == null) continue;
                                Util.collectRegexIds(line, excludedElements, baseline.getApiComponents(), debug);
                                continue;
                            }
                            excludedElements.addExactMatch(line);
                        }
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (IOException e) {
                    throw new CoreException(Status.error((String)NLS.bind((String)UtilMessages.Util_problemWithFilterFile, (Object)location), (Throwable)e));
                }
            }
        }
        return excludedElements;
    }

    public static void collectRegexIds(String line, FilteredElements excludedElements, IApiComponent[] components, boolean debug) throws CoreException {
        if (line.startsWith(REGULAR_EXPRESSION_START)) {
            String componentname = line;
            componentname = componentname.substring(2);
            Pattern pattern = null;
            try {
                if (debug) {
                    System.out.println("Pattern to match : " + componentname);
                }
                pattern = Pattern.compile(componentname);
                String componentid = null;
                IApiComponent[] iApiComponentArray = components;
                int n = components.length;
                int n2 = 0;
                while (n2 < n) {
                    IApiComponent component = iApiComponentArray[n2];
                    componentid = component.getSymbolicName();
                    if (pattern.matcher(componentid).matches()) {
                        if (debug) {
                            System.out.println(componentid + " matched the pattern " + componentname);
                        }
                        excludedElements.addPartialMatch(componentid);
                    } else if (debug) {
                        System.out.println(componentid + " didn't match the pattern " + componentname);
                    }
                    ++n2;
                }
            }
            catch (PatternSyntaxException e) {
                throw new CoreException(Status.error((String)NLS.bind((String)UtilMessages.comparison_invalidRegularExpression, (Object)componentname), (Throwable)e));
            }
        }
    }

    public static boolean isAPI(int visibility, IApiType typeDescriptor) {
        int access = typeDescriptor.getModifiers();
        return VisibilityModifiers.isAPI(visibility) && (Flags.isPublic((int)access) || Flags.isProtected((int)access));
    }

    public static String deepToString(Object[] array) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < array.length) {
            buffer.append(array[i].toString());
            if (i < array.length - 1) {
                buffer.append(',');
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String getSinceVersionTagPrefererenceKey(int id) {
        int problemCategory = ApiProblemFactory.getProblemCategory(id);
        int problemKind = ApiProblemFactory.getProblemKind(id);
        switch (problemCategory) {
            case 0x40000000: {
                switch (problemKind) {
                    case 1: {
                        return "invalid_since_tag_version";
                    }
                    case 2: {
                        return "malformed_since_tag";
                    }
                    case 3: {
                        return "missing_since_tag";
                    }
                }
                break;
            }
            case 0x30000000: {
                switch (problemKind) {
                    case 3: {
                        return "incompatible_api_component_version_report_major_without_breaking_change";
                    }
                    case 4: 
                    case 8: 
                    case 9: {
                        return "incompatible_api_component_version_report_minor_without_api_change";
                    }
                    case 7: {
                        return "changed_execution_env";
                    }
                }
                return "incompatible_api_component_version";
            }
        }
        return null;
    }

    public static String getUsagePrefererenceKey(int id) {
        int problemKind = ApiProblemFactory.getProblemKind(id);
        int problemFlag = ApiProblemFactory.getProblemFlags(id);
        switch (problemKind) {
            case 4: {
                return "ILLEGAL_IMPLEMENT";
            }
            case 1: {
                return "ILLEGAL_EXTEND";
            }
            case 2: {
                return "ILLEGAL_INSTANTIATE";
            }
            case 5: {
                return "ILLEGAL_OVERRIDE";
            }
            case 3: {
                return "ILLEGAL_REFERENCE";
            }
            case 6: {
                switch (problemFlag) {
                    case 1: 
                    case 15: 
                    case 16: {
                        return "LEAK_EXTEND";
                    }
                    case 2: {
                        return "LEAK_IMPLEMENT";
                    }
                    case 3: {
                        return "LEAK_FIELD_DECL";
                    }
                    case 4: {
                        return "LEAK_METHOD_RETURN_TYPE";
                    }
                    case 5: 
                    case 6: {
                        return "LEAK_METHOD_PARAM";
                    }
                }
                break;
            }
            case 7: {
                return "INVALID_JAVADOC_TAG";
            }
            case 13: {
                return "INVALID_ANNOTATION";
            }
            case 9: {
                return "INVALID_REFERENCE_IN_SYSTEM_LIBRARIES";
            }
            case 10: {
                return "UNUSED_PROBLEM_FILTERS";
            }
        }
        return null;
    }

    public static String getComponentResolutionKey(int id) {
        int problemKind = ApiProblemFactory.getProblemKind(id);
        switch (problemKind) {
            case 1: {
                return "report_resolution_errors_api_component";
            }
            case 10: {
                return "UNUSED_PROBLEM_FILTERS";
            }
        }
        return null;
    }

    public static String getAPIUseScanKey(int id) {
        int problemKind = ApiProblemFactory.getProblemKind(id);
        switch (problemKind) {
            case 1: {
                return "API_USE_SCAN_TYPE_SEVERITY";
            }
            case 2: {
                return "API_USE_SCAN_METHOD_SEVERITY";
            }
            case 3: {
                return "API_USE_SCAN_FIELD_SEVERITY";
            }
        }
        return null;
    }

    public static String getAPIToolPreferenceKey(int id) {
        String key = null;
        int category = ApiProblemFactory.getProblemCategory(id);
        if (category == 0x20000000) {
            key = Util.getUsagePrefererenceKey(id);
        }
        if (category == 0x10000000) {
            key = Util.getDeltaPrefererenceKey(ApiProblemFactory.getProblemElementKind(id), ApiProblemFactory.getProblemKind(id), ApiProblemFactory.getProblemFlags(id));
        }
        if (category == 0x40000000 || category == 0x30000000) {
            key = Util.getSinceVersionTagPrefererenceKey(id);
        }
        if (category == 0x60000000) {
            key = Util.getComponentResolutionKey(id);
        }
        if (category == Integer.MIN_VALUE) {
            key = Util.getAPIUseScanKey(id);
        }
        return key;
    }

    public static int getAPIToolPreferenceTab(int id) {
        int category = ApiProblemFactory.getProblemCategory(id);
        int tab = -1;
        if (category == 0x20000000) {
            tab = 0;
            int problemKind = ApiProblemFactory.getProblemKind(id);
            switch (problemKind) {
                case 10: {
                    return 3;
                }
            }
        }
        if (category == 0x10000000) {
            tab = 1;
        }
        if (category == 0x40000000 || category == 0x30000000) {
            tab = 2;
        }
        if (category == 0x60000000) {
            tab = 3;
        }
        if (category == Integer.MIN_VALUE) {
            tab = 4;
        }
        return tab;
    }

    /*
     * WARNING - void declaration
     */
    public static IType findSourceTypeinJavaProject(IJavaProject javaProject, String typeName) {
        IType type;
        block6: {
            type = null;
            try {
                IPackageFragment[] findPackageFragment;
                String pkgName = typeName.substring(0, typeName.lastIndexOf(46));
                IJavaProject iJavaProject = javaProject;
                if (!(iJavaProject instanceof JavaProject)) break block6;
                JavaProject javaProject2 = (JavaProject)iJavaProject;
                JavaProject cfr_ignored_0 = (JavaProject)iJavaProject;
                NameLookup newNameLookup = null;
                try {
                    void jp;
                    newNameLookup = jp.newNameLookup((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
                }
                catch (JavaModelException e) {
                    ApiPlugin.log(e);
                }
                IPackageFragment[] iPackageFragmentArray = findPackageFragment = newNameLookup.findPackageFragments(pkgName, false);
                int n = findPackageFragment.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragment iJavaElement = iPackageFragmentArray[n2];
                    type = newNameLookup.findType(typeName.substring(typeName.lastIndexOf(46) + 1, typeName.length()), iJavaElement, false, 0x100001E);
                    if (!(type instanceof SourceType)) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {}
        }
        return type;
    }

    private static final class BuildJob
    extends Job {
        private final IProject[] fProjects;
        private final int fBuildType;

        BuildJob(String name, IProject[] projects) {
            this(name, projects, 6);
        }

        BuildJob(String name, IProject[] projects, int buildType) {
            super(name);
            this.fProjects = projects;
            this.fBuildType = buildType;
        }

        public boolean belongsTo(Object family) {
            return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
        }

        public boolean isCoveredBy(BuildJob other) {
            if (other.fProjects == null) {
                return true;
            }
            if (this.fProjects != null) {
                IProject[] iProjectArray = this.fProjects;
                int n = this.fProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject fProject = iProjectArray[n2];
                    if (!other.contains(fProject)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            return false;
        }

        public boolean contains(IProject project) {
            if (project == null) {
                return false;
            }
            IProject[] iProjectArray = this.fProjects;
            int n = this.fProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject fProject = iProjectArray[n2];
                if (project.equals((Object)fProject)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            synchronized (clazz) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                this.cancelBuild(ResourcesPlugin.FAMILY_MANUAL_BUILD);
            }
            try {
                try {
                    if (this.fProjects != null) {
                        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)UtilMessages.Util_0, (int)this.fProjects.length);
                        IProject[] iProjectArray = this.fProjects;
                        int n = this.fProjects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject currentProject = iProjectArray[n2];
                            if (this.fBuildType == 6) {
                                BuildState.setLastBuiltState(currentProject, null);
                            }
                            localmonitor.subTask(NLS.bind((String)UtilMessages.Util_5, (Object)currentProject.getName()));
                            if (ResourcesPlugin.getWorkspace().isAutoBuilding()) {
                                currentProject.touch(null);
                            } else {
                                currentProject.build(10, (IProgressMonitor)localmonitor.split(1));
                            }
                            ++n2;
                        }
                    }
                }
                catch (CoreException e) {
                    Status status = new Status(e.getStatus().getSeverity(), "org.eclipse.pde.api.tools", 120, UtilMessages.Util_builder_errorMessage, (Throwable)e);
                    monitor.done();
                    return status;
                }
                catch (OperationCanceledException operationCanceledException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    monitor.done();
                    return iStatus;
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - void declaration
         */
        private void cancelBuild(Object jobfamily) {
            Job[] buildJobs;
            Job[] jobArray = buildJobs = Job.getJobManager().find(jobfamily);
            int n = buildJobs.length;
            int n2 = 0;
            while (n2 < n) {
                Job job;
                Job curr = jobArray[n2];
                if (curr != this && (job = curr) instanceof BuildJob) {
                    void job2;
                    BuildJob cfr_ignored_0 = (BuildJob)job;
                    BuildJob cfr_ignored_1 = (BuildJob)job;
                    if (job2.isCoveredBy(this)) {
                        curr.cancel();
                    }
                }
                ++n2;
            }
        }
    }
}

