/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.mylyn.internal.tasks.ui.editors.TextAttributeEditor;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LabelsAttributeEditor
extends TextAttributeEditor {
    private static final String VALUE_SEPARATOR = ",";
    private final boolean isMultiSelect;

    public LabelsAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
        super(manager, taskAttribute);
        boolean bl = this.isMultiSelect = "multiSelect".equals(taskAttribute.getMetaData().getType()) || "multiLabel".equals(taskAttribute.getMetaData().getType());
        if (!this.isReadOnly() && this.isMultiSelect) {
            this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.MULTIPLE, LayoutHint.ColumnSpan.SINGLE));
        }
    }

    @Override
    public void createControl(Composite parent, FormToolkit toolkit) {
        super.createControl(parent, toolkit, this.getLayoutHint() != null && this.getLayoutHint().rowSpan == LayoutHint.RowSpan.MULTIPLE ? 64 : 0);
        if (!this.isReadOnly() && this.isMultiSelect) {
            this.getText().setToolTipText("Separate multiple values with a comma");
        }
    }

    @Override
    public String getValue() {
        if (this.isMultiSelect) {
            List values = this.getAttributeMapper().getValues(this.getTaskAttribute());
            return values.stream().filter(Objects::nonNull).collect(Collectors.joining(", "));
        }
        return this.getAttributeMapper().getValue(this.getTaskAttribute());
    }

    @Override
    public void setValue(String text) {
        if (this.isMultiSelect) {
            String[] values = text.split(VALUE_SEPARATOR);
            this.getAttributeMapper().setValues(this.getTaskAttribute(), LabelsAttributeEditor.getTrimmedValues(values));
        } else {
            this.getAttributeMapper().setValue(this.getTaskAttribute(), text);
        }
        this.attributeChanged();
    }

    public static List<String> getTrimmedValues(String[] values) {
        return Arrays.asList(values).stream().map(s -> StringUtils.defaultString((String)s).trim()).filter(f -> StringUtils.isNotEmpty((CharSequence)f)).collect(Collectors.toUnmodifiableList());
    }
}

