/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.massif;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifLaunchConstants;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifOutput;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifParser;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifPlugin;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifViewPart;
import org.eclipse.linuxtools.internal.valgrind.massif.Messages;
import org.eclipse.linuxtools.valgrind.launch.IValgrindLaunchDelegate;
import org.eclipse.linuxtools.valgrind.ui.IValgrindToolView;
import org.osgi.framework.Version;

public class MassifLaunchDelegate
implements IValgrindLaunchDelegate {
    protected static final String OUT_PREFIX = "massif_";
    protected static final String OUT_FILE = "massif_%p.txt";
    private static final FileFilter MASSIF_FILTER = pathname -> pathname.getName().startsWith(OUT_PREFIX);
    private static final String EQUALS = "=";
    private static final String NO = "no";
    private static final String YES = "yes";
    private static final Version VER_3_6_0 = new Version(3, 6, 0);
    private MassifOutput output;

    public void handleLaunch(ILaunchConfiguration config, ILaunch launch, IPath outDir, IProgressMonitor monitor) throws CoreException {
        MassifPlugin.getDefault().setSourceLocator(launch.getSourceLocator());
        try {
            try {
                monitor.beginTask(Messages.getString("MassifLaunchDelegate.Parsing_Massif_Output"), 3);
                File[] massifOutputs = outDir.toFile().listFiles(MASSIF_FILTER);
                if (massifOutputs.length > 0) {
                    this.parseOutput(massifOutputs, monitor);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.abort(Messages.getString("MassifLaunchDelegate.Error_parsing_output"), e, 150);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void parseOutput(File[] massifOutputs, IProgressMonitor monitor) throws IOException {
        this.output = new MassifOutput();
        File[] fileArray = massifOutputs;
        int n = massifOutputs.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            MassifParser parser = new MassifParser(file);
            this.output.putSnapshots(parser.getPid(), parser.getSnapshots());
            ++n2;
        }
        monitor.worked(2);
    }

    public String[] getCommandArray(ILaunchConfiguration config, Version ver, IPath logDir) throws CoreException {
        ArrayList<CallSite> opts = new ArrayList<CallSite>();
        opts.add((CallSite)((Object)("--massif-out-file=" + logDir.append(OUT_FILE).toPortableString())));
        opts.add((CallSite)((Object)("--heap=" + (config.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_HEAP", true) ? YES : NO))));
        opts.add((CallSite)((Object)("--heap-admin=" + config.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_HEAPADMIN", 8))));
        opts.add((CallSite)((Object)("--stacks=" + (config.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_STACKS", false) ? YES : NO))));
        opts.add((CallSite)((Object)("--depth=" + config.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_DEPTH", 30))));
        List allocFns = config.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_ALLOCFN", MassifLaunchConstants.DEFAULT_MASSIF_ALLOCFN);
        for (String func : allocFns) {
            opts.add((CallSite)((Object)("--alloc-fn=" + func)));
        }
        List ignoreFns = config.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_IGNOREFN", MassifLaunchConstants.DEFAULT_MASSIF_IGNOREFN);
        for (String func : ignoreFns) {
            opts.add((CallSite)((Object)("--ignore-fn=" + func)));
        }
        opts.add((CallSite)((Object)("--threshold=" + (double)config.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_THRESHOLD", 10) / 10.0)));
        opts.add((CallSite)((Object)("--peak-inaccuracy=" + (double)config.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_PEAKINACCURACY", 10) / 10.0)));
        opts.add((CallSite)((Object)("--time-unit=" + config.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_TIMEUNIT", "i"))));
        opts.add((CallSite)((Object)("--detailed-freq=" + config.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_DETAILEDFREQ", 10))));
        opts.add((CallSite)((Object)("--max-snapshots=" + config.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_MAXSNAPSHOTS", 100))));
        if (config.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_ALIGNMENT_BOOL", false)) {
            opts.add((CallSite)((Object)("--alignment=" + config.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_ALIGNMENT_VAL", 0))));
        }
        if (ver == null || ver.compareTo(VER_3_6_0) >= 0) {
            opts.add((CallSite)((Object)("--pages-as-heap=" + (config.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_PAGEASHEAP", false) ? YES : NO))));
        }
        return opts.toArray(new String[opts.size()]);
    }

    public void initializeView(IValgrindToolView view, String contentDescription, IProgressMonitor monitor) {
        if (this.output != null && view instanceof MassifViewPart) {
            ((MassifViewPart)view).setChartName(contentDescription);
            ((MassifViewPart)view).setOutput(this.output);
            ((MassifViewPart)view).setPid(this.output.getPids()[0]);
        }
        monitor.worked(1);
    }

    private void abort(String message, Throwable exception, int code) throws CoreException {
        Status status;
        if (exception != null) {
            MultiStatus multiStatus = new MultiStatus("org.eclipse.linuxtools.valgrind.massif", code, message, exception);
            multiStatus.add((IStatus)new Status(4, "org.eclipse.linuxtools.valgrind.massif", code, exception.getLocalizedMessage(), exception));
            status = multiStatus;
        } else {
            status = new Status(4, "org.eclipse.linuxtools.valgrind.massif", code, message, null);
        }
        throw new CoreException((IStatus)status);
    }
}

