/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher;

import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher.Messages;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.preferences.IDEPreferenceConstants;
import org.eclipse.linuxtools.systemtap.graphing.ui.widgets.ExceptionErrorDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SystemTapScriptOptionsTab
extends AbstractLaunchConfigurationTab {
    static final String MISC_COMMANDLINE_OPTIONS = "MiscComandLineOptions";
    private Button[] checkBox = new Button[IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS.length];
    private Text[] text = new Text[IDEPreferenceConstants.STAP_STRING_OPTIONS.length];
    private Text targetProgramText;
    private ModifyListener modifyListener = e -> this.updateLaunchConfigurationDialog();
    private FileDialog fileDialog;
    private Text miscCommandsText;
    private Button dyninstCheckBox;
    private Text targetPidText;

    public void createControl(Composite parent) {
        Label label;
        GridLayout singleColumnGridLayout = new GridLayout();
        singleColumnGridLayout.numColumns = 1;
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        comp.setLayout((Layout)singleColumnGridLayout);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fileDialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 4096);
        this.fileDialog.setText(Messages.SystemTapScriptOptionsTab_selectExec);
        this.fileDialog.setFilterPath(Platform.getLocation().toOSString());
        Group targetExecutableGroup = new Group(comp, 16);
        targetExecutableGroup.setText(Messages.SystemTapScriptOptionsTab_targetExec);
        targetExecutableGroup.setToolTipText(Messages.SystemTapScriptOptionsTab_targetToolTip);
        targetExecutableGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout twoColumnGridLayout = new GridLayout();
        twoColumnGridLayout.numColumns = 2;
        targetExecutableGroup.setLayout((Layout)twoColumnGridLayout);
        this.targetProgramText = new Text((Composite)targetExecutableGroup, 2052);
        this.targetProgramText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.targetProgramText.addModifyListener(this.modifyListener);
        Button selectTargetProgramButton = new Button((Composite)targetExecutableGroup, 0);
        GridData gridData = new GridData();
        selectTargetProgramButton.setLayoutData((Object)gridData);
        selectTargetProgramButton.setText(Messages.SystemTapScriptLaunchConfigurationTab_browse);
        selectTargetProgramButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String fileName = this.fileDialog.open();
            if (fileName != null) {
                this.targetProgramText.setText(fileName);
            }
        }));
        Composite cmpChkBoxes = new Composite(comp, 0);
        cmpChkBoxes.setLayout((Layout)twoColumnGridLayout);
        cmpChkBoxes.setLayoutData((Object)new GridData(4, 1, true, false));
        int i = 0;
        while (i < IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS.length) {
            this.checkBox[i] = new Button(cmpChkBoxes, 32);
            this.checkBox[i].setText(IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS[i][1] + " (" + IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS[i][0] + ")");
            this.checkBox[i].addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SystemTapScriptOptionsTab.this.updateLaunchConfigurationDialog();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    SystemTapScriptOptionsTab.this.updateLaunchConfigurationDialog();
                }
            });
            this.checkBox[i].setToolTipText(IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS[i][3]);
            if (IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS[i][0].contains(Messages.SystemTapScriptOptionsTab_dyninst)) {
                this.dyninstCheckBox = this.checkBox[i];
            }
            ++i;
        }
        Composite cmpTxtBoxes = new Composite(comp, 0);
        cmpTxtBoxes.setLayout((Layout)twoColumnGridLayout);
        cmpTxtBoxes.setLayoutData((Object)new GridData(4, 1, true, false));
        int i2 = 0;
        while (i2 < IDEPreferenceConstants.STAP_STRING_OPTIONS.length) {
            label = new Label(cmpTxtBoxes, 0);
            label.setText(IDEPreferenceConstants.STAP_STRING_OPTIONS[i2][1] + " (" + IDEPreferenceConstants.STAP_STRING_OPTIONS[i2][0] + ")");
            label.setToolTipText(IDEPreferenceConstants.STAP_STRING_OPTIONS[i2][3]);
            this.text[i2] = new Text(cmpTxtBoxes, 2048);
            this.text[i2].setLayoutData((Object)new GridData(4, 1, true, true));
            this.text[i2].addModifyListener(this.modifyListener);
            this.text[i2].setToolTipText(IDEPreferenceConstants.STAP_STRING_OPTIONS[i2][3]);
            if (IDEPreferenceConstants.STAP_STRING_OPTIONS[i2][0].contains("-x")) {
                this.targetPidText = this.text[i2];
            }
            ++i2;
        }
        label = new Label(cmpTxtBoxes, 0);
        label.setText(Messages.SystemTapScriptOptionsTab_otherOptions);
        this.miscCommandsText = new Text(cmpTxtBoxes, 2048);
        this.miscCommandsText.setLayoutData((Object)new GridData(4, 1, true, true));
        this.miscCommandsText.addModifyListener(this.modifyListener);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IPreferenceStore store = IDEPlugin.getDefault().getPreferenceStore();
        configuration.setAttribute(IDEPreferenceConstants.STAP_CMD_OPTION[2], store.getString(IDEPreferenceConstants.STAP_CMD_OPTION[2]));
        int i = 0;
        while (i < IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS.length) {
            configuration.setAttribute(IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS[i][2], store.getBoolean(IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS[i][2]));
            ++i;
        }
        i = 0;
        while (i < IDEPreferenceConstants.STAP_STRING_OPTIONS.length) {
            configuration.setAttribute(IDEPreferenceConstants.STAP_STRING_OPTIONS[i][2], store.getString(IDEPreferenceConstants.STAP_STRING_OPTIONS[i][2]));
            ++i;
        }
        configuration.setAttribute(MISC_COMMANDLINE_OPTIONS, store.getString(MISC_COMMANDLINE_OPTIONS));
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.targetProgramText.setText(configuration.getAttribute(IDEPreferenceConstants.STAP_CMD_OPTION[2], ""));
            int i = 0;
            while (i < IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS.length) {
                this.checkBox[i].setSelection(configuration.getAttribute(IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS[i][2], false));
                ++i;
            }
            i = 0;
            while (i < IDEPreferenceConstants.STAP_STRING_OPTIONS.length) {
                this.text[i].setText(configuration.getAttribute(IDEPreferenceConstants.STAP_STRING_OPTIONS[i][2], ""));
                ++i;
            }
            this.miscCommandsText.setText(configuration.getAttribute(MISC_COMMANDLINE_OPTIONS, ""));
        }
        catch (Exception e) {
            ExceptionErrorDialog.openError((String)Messages.SystemTapScriptOptionsTab_initializeConfigurationFailed, (Exception)e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IDEPreferenceConstants.STAP_CMD_OPTION[2], this.targetProgramText.getText());
        int i = 0;
        while (i < IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS.length) {
            configuration.setAttribute(IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS[i][2], this.checkBox[i].getSelection());
            ++i;
        }
        i = 0;
        while (i < IDEPreferenceConstants.STAP_STRING_OPTIONS.length) {
            configuration.setAttribute(IDEPreferenceConstants.STAP_STRING_OPTIONS[i][2], this.text[i].getText());
            ++i;
        }
        configuration.setAttribute(MISC_COMMANDLINE_OPTIONS, this.miscCommandsText.getText());
    }

    public String getName() {
        return Messages.SystemTapScriptLaunchConfigurationTab_tabName;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (this.dyninstCheckBox.getSelection() && this.targetProgramText.getText().isEmpty() && this.targetPidText.getText().isEmpty()) {
            this.setErrorMessage(Messages.SystemTapScriptOptionsTab_dyninstError);
            return false;
        }
        if (!this.targetPidText.getText().isEmpty() && !this.targetPidText.getText().matches("[0-9]*")) {
            this.setErrorMessage(Messages.SystemTapScriptOptionsTab_pidError);
            return false;
        }
        return true;
    }

    public Image getImage() {
        return ((ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.linuxtools.systemtap.ui.ide", (String)"icons/smileytap_small.gif").get()).createImage();
    }
}

