/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.rpm.ui.Activator;
import org.eclipse.linuxtools.internal.rpm.ui.Messages;
import org.eclipse.linuxtools.rpm.core.RPMProject;
import org.eclipse.linuxtools.rpm.core.RPMProjectLayout;
import org.eclipse.linuxtools.rpm.ui.RPMExportOperation;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.EditorPart;

public class SpecfileEditorRPMBuildHandler
extends AbstractHandler {
    private static final String BUILD_TYPE = "buildType";
    private static final String ON_EDITOR = "actOnEditor";
    protected RPMProject rpj;

    public Object execute(ExecutionEvent event) {
        IResource resource = SpecfileEditorRPMBuildHandler.getResource(event);
        this.rpj = SpecfileEditorRPMBuildHandler.getRPMProject(resource);
        if (this.rpj != null) {
            RPMExportOperation job = new RPMExportOperation(this.rpj, event.getParameter(BUILD_TYPE));
            job.setUser(true);
            job.schedule();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static IResource getResource(ExecutionEvent event) {
        boolean actOnEditor = Boolean.valueOf(event.getParameter(ON_EDITOR));
        if (actOnEditor) {
            IEditorInput input2;
            IEditorInput iEditorInput;
            IEditorPart epart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            if (epart != null && (iEditorInput = (input2 = epart.getEditorInput())) instanceof IFileEditorInput) {
                void fei;
                IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
                IFileEditorInput cfr_ignored_0 = (IFileEditorInput)iEditorInput;
                return fei.getFile();
            }
            return null;
        }
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part == null) {
            return null;
        }
        IWorkbenchPart iWorkbenchPart = part;
        if (iWorkbenchPart instanceof EditorPart) {
            void ePart;
            IEditorInput input;
            EditorPart input2 = (EditorPart)iWorkbenchPart;
            EditorPart cfr_ignored_1 = (EditorPart)iWorkbenchPart;
            IEditorInput iEditorInput = input = ePart.getEditorInput();
            if (iEditorInput instanceof IFileEditorInput) {
                void fei;
                IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
                IFileEditorInput cfr_ignored_2 = (IFileEditorInput)iEditorInput;
                return fei.getFile();
            }
            return null;
        }
        IWorkbenchPartSite site = part.getSite();
        if (site == null) {
            return null;
        }
        ISelectionProvider provider = site.getSelectionProvider();
        if (provider == null) {
            return null;
        }
        ISelection selection = provider.getSelection();
        ISelection iSelection = selection;
        if (iSelection instanceof IStructuredSelection) {
            void structured;
            Object element;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            IStructuredSelection cfr_ignored_3 = (IStructuredSelection)iSelection;
            Object object = element = structured.getFirstElement();
            if (object instanceof IResource) {
                void r;
                IResource iResource = (IResource)object;
                IResource cfr_ignored_4 = (IResource)object;
                return r;
            }
            Object object2 = element;
            if (object2 instanceof IAdaptable) {
                void a;
                IAdaptable iAdaptable = (IAdaptable)object2;
                IAdaptable cfr_ignored_5 = (IAdaptable)object2;
                void adaptable = a;
                return (IResource)adaptable.getAdapter(IResource.class);
            }
            return null;
        }
        return null;
    }

    private static RPMProject getRPMProject(IResource resource) {
        if (resource != null) {
            try {
                IProject parentProject = resource.getProject();
                if (parentProject.hasNature("org.eclipse.linuxtools.rpm.core.rpmnature")) {
                    if (parentProject.getPersistentProperty(new QualifiedName("org.eclipse.linuxtools.rpm.core", "SPECS")) != null) {
                        return new RPMProject(parentProject, RPMProjectLayout.RPMBUILD);
                    }
                    return new RPMProject(parentProject, RPMProjectLayout.FLAT);
                }
            }
            catch (CoreException e) {
                Activator.logError(Messages.getString("SpecfileEditorRPMBuildHandler.logRPMProjectError"), e);
            }
        }
        return null;
    }
}

