/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaBreakpointListener;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodEntryBreakpoint;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaExceptionBreakpoint;
import org.eclipse.jdt.internal.debug.core.logicalstructures.IJavaStructuresListener;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JavaLogicalStructures;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.jdt.internal.debug.ui.ConditionalBreakpointErrorDialog;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.EvaluationContextManager;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.JavaBreakpointPropertiesAction;
import org.eclipse.jdt.internal.debug.ui.breakpoints.SuspendOnCompilationErrorListener;
import org.eclipse.jdt.internal.debug.ui.breakpoints.SuspendOnUncaughtExceptionListener;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.ScrapbookLauncher;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class JavaDebugOptionsManager
implements IDebugEventSetListener,
IPropertyChangeListener,
IJavaBreakpointListener,
ILaunchListener,
IBreakpointsListener,
IJavaStructuresListener {
    private static JavaDebugOptionsManager fgOptionsManager = null;
    private IJavaExceptionBreakpoint fSuspendOnExceptionBreakpoint = null;
    private IJavaExceptionBreakpoint fSuspendOnErrorBreakpoint = null;
    private static ILabelProvider fLabelProvider = DebugUITools.newDebugModelPresentation();
    private static final int ADDED = 0;
    private static final int REMOVED = 1;
    private static final int CHANGED = 2;
    private String[] fActiveStepFilters = null;
    private static Set<String> fgDisplayOptions = new HashSet<String>();
    private boolean fActivated = false;

    static {
        fgDisplayOptions.add(IJDIPreferencesConstants.PREF_SHOW_CHAR);
        fgDisplayOptions.add(IJDIPreferencesConstants.PREF_SHOW_HEX);
        fgDisplayOptions.add(IJDIPreferencesConstants.PREF_SHOW_UNSIGNED);
    }

    private JavaDebugOptionsManager() {
    }

    public static JavaDebugOptionsManager getDefault() {
        if (fgOptionsManager == null) {
            fgOptionsManager = new JavaDebugOptionsManager();
        }
        return fgOptionsManager;
    }

    public void startup() {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        debugPlugin.getLaunchManager().addLaunchListener((ILaunchListener)this);
        debugPlugin.getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
        EvaluationContextManager.startup();
    }

    public void shutdown() {
        Job.getJobManager().cancel(JavaDebugOptionsManager.class);
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        debugPlugin.removeDebugEventListener((IDebugEventSetListener)this);
        debugPlugin.getLaunchManager().removeLaunchListener((ILaunchListener)this);
        debugPlugin.getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
        if (!JDIDebugUIPlugin.getDefault().isShuttingDown()) {
            JDIDebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        }
        JDIDebugModel.removeJavaBreakpointListener((IJavaBreakpointListener)this);
        JavaLogicalStructures.removeStructuresListener((IJavaStructuresListener)this);
        System.getProperties().remove(JDIDebugUIPlugin.getUniqueIdentifier() + ".debuggerActive");
    }

    protected void initializeProblemHandling() {
        InitJob job = new InitJob();
        job.setSystem(true);
        job.schedule();
    }

    protected void notifyTargets(IBreakpoint breakpoint, int kind) {
        IDebugTarget[] targets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
        int i = 0;
        while (i < targets.length) {
            if (targets[i] instanceof IJavaDebugTarget) {
                IJavaDebugTarget target = (IJavaDebugTarget)targets[i];
                this.notifyTarget(target, breakpoint, kind);
            }
            ++i;
        }
    }

    protected void notifyTargetOfFilters(IJavaDebugTarget target) {
        IPreferenceStore store = JDIDebugUIPlugin.getDefault().getPreferenceStore();
        target.setFilterConstructors(store.getBoolean(IJDIPreferencesConstants.PREF_FILTER_CONSTRUCTORS));
        target.setFilterStaticInitializers(store.getBoolean(IJDIPreferencesConstants.PREF_FILTER_STATIC_INITIALIZERS));
        target.setFilterSynthetics(store.getBoolean(IJDIPreferencesConstants.PREF_FILTER_SYNTHETICS));
        target.setFilterGetters(store.getBoolean(IJDIPreferencesConstants.PREF_FILTER_GETTERS));
        target.setFilterSetters(store.getBoolean(IJDIPreferencesConstants.PREF_FILTER_SETTERS));
        target.setStepThruFilters(store.getBoolean(IJDIPreferencesConstants.PREF_STEP_THRU_FILTERS));
        target.setStepFilters(this.getActiveStepFilters());
    }

    protected void notifyTargetsOfFilters() {
        IDebugTarget[] targets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
        int i = 0;
        while (i < targets.length) {
            if (targets[i] instanceof IJavaDebugTarget) {
                IJavaDebugTarget target = (IJavaDebugTarget)targets[i];
                this.notifyTargetOfFilters(target);
            }
            ++i;
        }
    }

    protected void notifyTarget(IJavaDebugTarget target, IBreakpoint breakpoint, int kind) {
        switch (kind) {
            case 0: {
                target.breakpointAdded(breakpoint);
                break;
            }
            case 1: {
                target.breakpointRemoved(breakpoint, null);
                break;
            }
            case 2: {
                target.breakpointChanged(breakpoint, null);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals(IJDIPreferencesConstants.PREF_SUSPEND_ON_COMPILATION_ERRORS)) {
            IJavaExceptionBreakpoint breakpoint = this.getSuspendOnCompilationErrorBreakpoint();
            if (breakpoint != null) {
                int kind = 1;
                if (this.isSuspendOnCompilationErrors()) {
                    kind = 0;
                }
                this.notifyTargets((IBreakpoint)breakpoint, kind);
            }
        } else if (property.equals(IJDIPreferencesConstants.PREF_SUSPEND_ON_UNCAUGHT_EXCEPTIONS)) {
            IJavaExceptionBreakpoint breakpoint = this.getSuspendOnUncaughtExceptionBreakpoint();
            if (breakpoint != null) {
                int kind = 1;
                if (this.isSuspendOnUncaughtExceptions()) {
                    kind = 0;
                }
                this.notifyTargets((IBreakpoint)breakpoint, kind);
            }
        } else if (fgDisplayOptions.contains(property)) {
            this.variableViewSettingsChanged();
        } else if (this.isUseFilterProperty(property)) {
            this.notifyTargetsOfFilters();
        } else if (this.isFilterListProperty(property)) {
            this.updateActiveFilters();
        }
    }

    private boolean isUseFilterProperty(String property) {
        return property.equals(IJDIPreferencesConstants.PREF_FILTER_CONSTRUCTORS) || property.equals(IJDIPreferencesConstants.PREF_FILTER_STATIC_INITIALIZERS) || property.equals(IJDIPreferencesConstants.PREF_FILTER_GETTERS) || property.equals(IJDIPreferencesConstants.PREF_FILTER_SETTERS) || property.equals(IJDIPreferencesConstants.PREF_FILTER_SYNTHETICS) || property.equals(IJDIPreferencesConstants.PREF_STEP_THRU_FILTERS);
    }

    private boolean isFilterListProperty(String property) {
        return property.equals(IJDIPreferencesConstants.PREF_ACTIVE_FILTERS_LIST) || property.equals(IJDIPreferencesConstants.PREF_INACTIVE_FILTERS_LIST);
    }

    protected void setEnabled(IBreakpoint breakpoint, boolean enabled) {
        try {
            breakpoint.setEnabled(enabled);
            this.notifyTargets(breakpoint, 2);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
    }

    public boolean isSuspendOnCompilationErrors() {
        return JDIDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_SUSPEND_ON_COMPILATION_ERRORS);
    }

    protected boolean isSuspendOnUncaughtExceptions() {
        return JDIDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_SUSPEND_ON_UNCAUGHT_EXCEPTIONS);
    }

    private void setSuspendOnUncaughtExceptionBreakpoint(IJavaExceptionBreakpoint breakpoint) {
        this.fSuspendOnExceptionBreakpoint = breakpoint;
    }

    protected IJavaExceptionBreakpoint getSuspendOnUncaughtExceptionBreakpoint() {
        return this.fSuspendOnExceptionBreakpoint;
    }

    private void setSuspendOnCompilationErrorsBreakpoint(IJavaExceptionBreakpoint breakpoint) {
        this.fSuspendOnErrorBreakpoint = breakpoint;
    }

    protected IJavaExceptionBreakpoint getSuspendOnCompilationErrorBreakpoint() {
        return this.fSuspendOnErrorBreakpoint;
    }

    public static String[] parseList(String listString) {
        ArrayList<String> list = new ArrayList<String>(10);
        StringTokenizer tokenizer = new StringTokenizer(listString, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            list.add(token);
        }
        return list.toArray(new String[list.size()]);
    }

    public static String serializeList(String[] list) {
        if (list == null) {
            return "";
        }
        return String.join((CharSequence)String.valueOf(','), list);
    }

    protected String[] getActiveStepFilters() {
        if (this.fActiveStepFilters == null) {
            this.fActiveStepFilters = JavaDebugOptionsManager.parseList(JDIDebugUIPlugin.getDefault().getPreferenceStore().getString(IJDIPreferencesConstants.PREF_ACTIVE_FILTERS_LIST));
            JDIDebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        }
        return this.fActiveStepFilters;
    }

    protected void updateActiveFilters() {
        this.fActiveStepFilters = JavaDebugOptionsManager.parseList(JDIDebugUIPlugin.getDefault().getPreferenceStore().getString(IJDIPreferencesConstants.PREF_ACTIVE_FILTERS_LIST));
        this.notifyTargetsOfFilters();
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            Object source;
            DebugEvent event = events[i];
            if (event.getKind() == 4 && (source = event.getSource()) instanceof IJavaDebugTarget) {
                IJavaDebugTarget javaTarget = (IJavaDebugTarget)source;
                if (this.isSuspendOnCompilationErrors()) {
                    this.notifyTarget(javaTarget, (IBreakpoint)this.getSuspendOnCompilationErrorBreakpoint(), 0);
                }
                if (this.isSuspendOnUncaughtExceptions()) {
                    ILaunchConfiguration launchConfiguration = javaTarget.getLaunch().getLaunchConfiguration();
                    boolean isSnippetEditor = false;
                    try {
                        isSnippetEditor = launchConfiguration.getAttribute(ScrapbookLauncher.SCRAPBOOK_LAUNCH, null) != null;
                    }
                    catch (CoreException coreException) {}
                    if (!isSnippetEditor) {
                        this.notifyTarget(javaTarget, (IBreakpoint)this.getSuspendOnUncaughtExceptionBreakpoint(), 0);
                    }
                }
                this.notifyTargetOfFilters(javaTarget);
            }
            ++i;
        }
    }

    public void addingBreakpoint(IJavaDebugTarget target, IJavaBreakpoint breakpoint) {
    }

    public int installingBreakpoint(IJavaDebugTarget target, IJavaBreakpoint breakpoint, IJavaType type) {
        return 4;
    }

    public int breakpointHit(IJavaThread thread, IJavaBreakpoint breakpoint) {
        if (thread instanceof JDIThread && breakpoint instanceof IJavaExceptionBreakpoint) {
            try {
                String[] breakpointListeners = breakpoint.getBreakpointListeners();
                if (breakpointListeners.length == 1 && SuspendOnCompilationErrorListener.ID_COMPILATION_ERROR_LISTENER.equals(breakpointListeners[0])) {
                    return 4;
                }
            }
            catch (CoreException coreException) {}
            if (this.shouldSkipSubsequentOccurrence((JDIThread)thread, (IJavaExceptionBreakpoint)breakpoint)) {
                return 2;
            }
        }
        return 4;
    }

    public boolean shouldSkipSubsequentOccurrence(JDIThread thread, IJavaExceptionBreakpoint exceptionBreakpoint) {
        if (exceptionBreakpoint == this.fSuspendOnExceptionBreakpoint) {
            return false;
        }
        IJavaExceptionBreakpoint.SuspendOnRecurrenceStrategy skip = thread.shouldSkipExceptionRecurrence(exceptionBreakpoint);
        if (skip == null) {
            return false;
        }
        if (skip == IJavaExceptionBreakpoint.SuspendOnRecurrenceStrategy.RECURRENCE_UNCONFIGURED) {
            skip = new AskRecurrenceDialog(JDIDebugUIPlugin.getShell()).getAnswer();
        }
        if (skip == null) {
            return false;
        }
        switch (skip) {
            case SKIP_RECURRENCES: {
                return true;
            }
        }
        return false;
    }

    public void breakpointInstalled(IJavaDebugTarget target, IJavaBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IJavaDebugTarget target, IJavaBreakpoint breakpoint) {
    }

    public IMarker getProblem(IJavaStackFrame frame) {
        ISourceLookupResult result;
        Object sourceElement;
        ILaunch launch = frame.getLaunch();
        if (launch != null && (sourceElement = (result = DebugUITools.lookupSource((Object)frame, null)).getSourceElement()) instanceof IResource) {
            try {
                IResource resource = (IResource)sourceElement;
                IMarker[] markers = resource.findMarkers("org.eclipse.jdt.core.problem", true, 2);
                int line = frame.getLineNumber();
                int i = 0;
                while (i < markers.length) {
                    IMarker marker = markers[i];
                    if (marker.getAttribute("lineNumber", -1) == line && marker.getAttribute("severity", -1) == 2) {
                        return marker;
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public void breakpointHasRuntimeException(IJavaLineBreakpoint breakpoint, DebugException exception) {
        IStatus status;
        Throwable wrappedException = exception.getStatus().getException();
        if (wrappedException instanceof InvocationException) {
            InvocationException ie = (InvocationException)wrappedException;
            ObjectReference ref = ie.exception();
            status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 4, ref.referenceType().name(), null);
        } else {
            status = exception.getStatus();
        }
        this.openConditionErrorDialog(breakpoint, DebugUIMessages.JavaDebugOptionsManager_Conditional_breakpoint_encountered_runtime_exception__1, status);
    }

    public void breakpointHasCompilationErrors(IJavaLineBreakpoint breakpoint, Message[] errors) {
        StringBuilder message = new StringBuilder();
        int i = 0;
        int numErrors = errors.length;
        while (i < numErrors) {
            Message error = errors[i];
            message.append(error.getMessage());
            message.append("\n ");
            ++i;
        }
        Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 4, message.toString(), null);
        this.openConditionErrorDialog(breakpoint, DebugUIMessages.JavaDebugOptionsManager_Conditional_breakpoint_has_compilation_error_s___2, (IStatus)status);
    }

    private void openConditionErrorDialog(final IJavaLineBreakpoint breakpoint, String errorMessage, final IStatus status) {
        final Display display = JDIDebugUIPlugin.getStandardDisplay();
        if (display.isDisposed()) {
            return;
        }
        final String message = NLS.bind((String)errorMessage, (Object[])new String[]{fLabelProvider.getText((Object)breakpoint)});
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                Shell shell = JDIDebugUIPlugin.getActiveWorkbenchShell();
                ConditionalBreakpointErrorDialog dialog = new ConditionalBreakpointErrorDialog(shell, message, status);
                int result = dialog.open();
                if (result == 0) {
                    JavaBreakpointPropertiesAction action = new JavaBreakpointPropertiesAction();
                    action.selectionChanged(null, (ISelection)new StructuredSelection((Object)breakpoint));
                    action.run(null);
                }
            }
        });
    }

    private void activate() {
        if (this.fActivated) {
            return;
        }
        this.fActivated = true;
        this.initializeProblemHandling();
        this.notifyTargetsOfFilters();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        JDIDebugModel.addJavaBreakpointListener((IJavaBreakpointListener)this);
        JavaLogicalStructures.addStructuresListener((IJavaStructuresListener)this);
    }

    public void launchAdded(ILaunch launch) {
        this.launchChanged(launch);
    }

    public void launchChanged(ILaunch launch) {
        this.activate();
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
    }

    public void launchRemoved(ILaunch launch) {
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
        ArrayList<IBreakpoint> update = new ArrayList<IBreakpoint>();
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            try {
                if (breakpoint instanceof IJavaBreakpoint && breakpoint.getMarker().getAttribute("message") == null) {
                    update.add(breakpoint);
                }
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.log(e);
            }
            ++i;
        }
        if (!update.isEmpty()) {
            this.updateBreakpointMessages(update.toArray(new IBreakpoint[update.size()]));
        }
    }

    private void updateBreakpointMessages(final IBreakpoint[] breakpoints) {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int i = 0;
                while (i < breakpoints.length) {
                    IBreakpoint breakpoint = breakpoints[i];
                    if (breakpoint instanceof IJavaBreakpoint) {
                        String info = fLabelProvider.getText((Object)breakpoint);
                        String type = DebugUIMessages.JavaDebugOptionsManager_Breakpoint___1;
                        if (breakpoint instanceof IJavaMethodBreakpoint || breakpoint instanceof IJavaMethodEntryBreakpoint) {
                            type = DebugUIMessages.JavaDebugOptionsManager_Method_breakpoint___2;
                        } else if (breakpoint instanceof IJavaWatchpoint) {
                            type = DebugUIMessages.JavaDebugOptionsManager_Watchpoint___3;
                        } else if (breakpoint instanceof IJavaLineBreakpoint) {
                            type = DebugUIMessages.JavaDebugOptionsManager_Line_breakpoint___4;
                        }
                        IMarker marker = breakpoint.getMarker();
                        if (marker.exists()) {
                            marker.setAttribute("message", (Object)(type + info));
                        }
                    }
                    ++i;
                }
            }
        };
        ISchedulingRule modifyWorkspaceRule = JavaDebugOptionsManager.modifyWorkspaceRule();
        ISchedulingRule currentRule = Job.getJobManager().currentRule();
        if (currentRule != null && currentRule.contains(modifyWorkspaceRule)) {
            try {
                ResourcesPlugin.getWorkspace().run(runnable, null, 0, null);
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.log(e);
            }
        } else {
            UpdateBreakpointMessagesJob updateBreakpointMessagesJob = new UpdateBreakpointMessagesJob(modifyWorkspaceRule, (ICoreRunnable)runnable);
            updateBreakpointMessagesJob.schedule();
        }
    }

    private static ISchedulingRule modifyWorkspaceRule() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IResourceRuleFactory rootFactory = workspace.getRuleFactory();
        ISchedulingRule modifyWorkspaceRule = rootFactory.modifyRule((IResource)workspaceRoot);
        return modifyWorkspaceRule;
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        this.updateBreakpointMessages(breakpoints);
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
    }

    public void logicalStructuresChanged() {
        this.variableViewSettingsChanged();
    }

    protected void variableViewSettingsChanged() {
        IJavaStackFrame frame;
        IAdaptable selected = DebugUITools.getDebugContext();
        if (selected != null && (frame = (IJavaStackFrame)selected.getAdapter(IJavaStackFrame.class)) != null) {
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)frame, 16)});
        }
    }

    private static final class AskRecurrenceDialog
    extends MessageDialog {
        private boolean fRememberChoice;
        private IJavaExceptionBreakpoint.SuspendOnRecurrenceStrategy fStrategy;

        private AskRecurrenceDialog(Shell parentShell) {
            super(parentShell, DebugUIMessages.JavaDebugOptionsManager_exceptionRecurrence_dialogTitle, null, DebugUIMessages.JavaDebugOptionsManager_exceptionRecurrence_dialogMessage, 3, 0, new String[]{DebugUIMessages.JavaDebugOptionsManager_skip_buttonLabel, DebugUIMessages.JavaDebugOptionsManager_suspend_buttonLabel});
            parentShell.getDisplay().syncExec(() -> {
                int n = this.open();
            });
        }

        protected Control createCustomArea(Composite parent) {
            Composite panel = new Composite(parent, 0);
            panel.setFont(parent.getFont());
            GridLayout layout = new GridLayout(1, false);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            panel.setLayout((Layout)layout);
            GridData data = new GridData(1808);
            data.verticalAlignment = 3;
            panel.setLayoutData((Object)data);
            Button button = new Button(panel, 32);
            button.setText(DebugUIMessages.JavaDebugOptionsManager_exceptionRecurrence_remember_decision);
            button.setSelection(false);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    fRememberChoice = !fRememberChoice;
                }
            });
            return panel;
        }

        public int open() {
            IEclipsePreferences prefs;
            int ret = super.open();
            switch (ret) {
                case 0: {
                    this.fStrategy = IJavaExceptionBreakpoint.SuspendOnRecurrenceStrategy.SKIP_RECURRENCES;
                    break;
                }
                case 1: {
                    this.fStrategy = IJavaExceptionBreakpoint.SuspendOnRecurrenceStrategy.SUSPEND_ALWAYS;
                }
            }
            if (this.fRememberChoice && (prefs = InstanceScope.INSTANCE.getNode(JDIDebugPlugin.getUniqueIdentifier())) != null) {
                prefs.put(JDIDebugModel.PREF_SUSPEND_ON_RECURRENCE_STRATEGY, this.fStrategy.name());
            }
            return ret;
        }

        public IJavaExceptionBreakpoint.SuspendOnRecurrenceStrategy getAnswer() {
            return this.fStrategy;
        }
    }

    class InitJob
    extends Job {
        public InitJob() {
            super(DebugUIMessages.JavaDebugOptionsManager_0);
        }

        protected IStatus run(IProgressMonitor monitor) {
            IJavaExceptionBreakpoint bp;
            MultiStatus status = new MultiStatus(JDIDebugUIPlugin.getUniqueIdentifier(), 150, "Java debug options failed to initialize", null);
            try {
                bp = JDIDebugModel.createExceptionBreakpoint((IResource)ResourcesPlugin.getWorkspace().getRoot(), (String)"java.lang.Error", (boolean)true, (boolean)true, (boolean)false, (boolean)false, null);
                bp.setPersisted(false);
                bp.addBreakpointListener(SuspendOnCompilationErrorListener.ID_COMPILATION_ERROR_LISTENER);
                JavaDebugOptionsManager.this.setSuspendOnCompilationErrorsBreakpoint(bp);
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
            try {
                bp = JDIDebugModel.createExceptionBreakpoint((IResource)ResourcesPlugin.getWorkspace().getRoot(), (String)"java.lang.Throwable", (boolean)false, (boolean)true, (boolean)false, (boolean)false, null);
                ((JavaExceptionBreakpoint)bp).setSuspendOnSubclasses(true);
                bp.setPersisted(false);
                bp.addBreakpointListener(SuspendOnUncaughtExceptionListener.ID_UNCAUGHT_EXCEPTION_LISTENER);
                JavaDebugOptionsManager.this.setSuspendOnUncaughtExceptionBreakpoint(bp);
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
            if (status.getChildren().length == 0) {
                return Status.OK_STATUS;
            }
            return status;
        }
    }

    private static class UpdateBreakpointMessagesJob
    extends Job {
        private final ISchedulingRule rule;
        private final ICoreRunnable runnable;

        UpdateBreakpointMessagesJob(ISchedulingRule rule, ICoreRunnable runnable) {
            super("Updating breakpoint messages");
            this.rule = rule;
            this.runnable = runnable;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            try {
                ResourcesPlugin.getWorkspace().run(this.runnable, this.rule, 0, monitor);
            }
            catch (CoreException e) {
                String errorMessage = "Failed to update breakpoint messages";
                Status errorStatus = new Status(4, IJavaDebugUIConstants.PLUGIN_ID, errorMessage, (Throwable)e);
                return errorStatus;
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return JavaDebugOptionsManager.class == family;
        }
    }
}

