/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.importexport.internal.wizard;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.importexport.internal.Messages;
import org.eclipse.equinox.internal.p2.importexport.internal.wizard.AbstractPage;
import org.eclipse.equinox.internal.p2.importexport.internal.wizard.ImportFromInstallationWizard;
import org.eclipse.equinox.internal.p2.importexport.internal.wizard.ImportPage;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.ISelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.InstallWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ImportWizard
extends InstallWizard
implements IImportWizard {
    public ImportWizard() {
        this(ProvisioningUI.getDefaultUI(), null, null, null);
    }

    public ImportWizard(ProvisioningUI ui, InstallOperation operation, Collection<IInstallableUnit> initialSelections, LoadMetadataRepositoryJob preloadJob) {
        super(ui, operation, initialSelections, preloadJob);
        IDialogSettings workbenchSettings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(ImportFromInstallationWizard.class)).getDialogSettings();
        String sectionName = "ImportWizard";
        IDialogSettings section = workbenchSettings.getSection(sectionName);
        if (section == null) {
            section = workbenchSettings.addNewSection(sectionName);
        }
        this.setDialogSettings(section);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.ImportWizard_WINDOWTITLE);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)Platform.getBundle((String)"org.eclipse.equinox.p2.ui.importexport").getEntry("icons/wizban/install_wiz.png")));
        this.setNeedsProgressMonitor(true);
    }

    protected ISelectableIUsPage createMainPage(IUElementListRoot input, Object[] selections) {
        return new ImportPage(this.ui, (ProvisioningOperationWizard)this);
    }

    protected ProvisioningContext getProvisioningContext() {
        return ((ImportPage)this.mainPage).getProvisioningContext();
    }

    public void recomputePlan(IRunnableContext runnableContext) {
        this.recomputePlan(runnableContext, true);
    }

    public void recomputePlan(IRunnableContext runnableContext, boolean withRemediation) {
        if (((ImportPage)this.mainPage).hasUnloadedRepo()) {
            try {
                runnableContext.run(true, true, monitor -> {
                    final SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(withRemediation ? 15 : 10));
                    ((ImportPage)this.mainPage).recompute((IProgressMonitor)sub.newChild(8));
                    if (sub.isCanceled()) {
                        throw new InterruptedException();
                    }
                    Display.getDefault().syncExec(() -> {
                        ProvisioningContext context = this.getProvisioningContext();
                        this.initializeResolutionModelElements(this.getOperationSelections());
                        if (this.planSelections.length == 0) {
                            this.operation = new InstallOperation(new ProvisioningSession(AbstractPage.agent), new ArrayList()){

                                protected void computeProfileChangeRequest(MultiStatus status, IProgressMonitor progressMonitor) {
                                    progressMonitor.done();
                                }

                                public IStatus getResolutionResult() {
                                    if (sub.isCanceled()) {
                                        return Status.CANCEL_STATUS;
                                    }
                                    return new Status(4, "org.eclipse.equinox.p2.ui.importexport", Messages.ImportWizard_CannotQuerySelection);
                                }
                            };
                        } else {
                            this.operation = this.getProfileChangeOperation(this.planSelections);
                            this.operation.setProvisioningContext(context);
                        }
                    });
                    if (sub.isCanceled()) {
                        throw new InterruptedException();
                    }
                    if (this.operation.resolveModal((IProgressMonitor)sub.newChild(2)).getSeverity() == 8) {
                        throw new InterruptedException();
                    }
                    if (withRemediation) {
                        IStatus status = this.operation.getResolutionResult();
                        if (this.remediationPage != null && this.shouldRemediate(status)) {
                            this.computeRemediationOperation(this.operation, this.ui, (IProgressMonitor)sub.newChild(5));
                        }
                    }
                    Display.getDefault().asyncExec(() -> ((ImportWizard)this).planChanged());
                });
            }
            catch (InterruptedException interruptedException) {
                this.operation = new InstallOperation(new ProvisioningSession(AbstractPage.agent), new ArrayList()){

                    public IStatus getResolutionResult() {
                        return Status.CANCEL_STATUS;
                    }
                };
            }
            catch (InvocationTargetException e) {
                ProvUI.handleException((Throwable)e.getCause(), null, (int)3);
                this.unableToResolve(null);
            }
        } else {
            super.recomputePlan(runnableContext, withRemediation);
        }
    }

    void unableToResolve(String message) {
        Status couldNotResolveStatus = message != null ? new Status(4, "org.eclipse.equinox.p2.ui.importexport", message, null) : new Status(4, "org.eclipse.equinox.p2.ui.importexport", ProvUIMessages.ProvisioningOperationWizard_UnexpectedFailureToResolve, null);
        StatusManager.getManager().handle((IStatus)couldNotResolveStatus, 1);
    }
}

