/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.common.lock;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.common.lock.CDOLockDelta;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.INotifier;

public abstract class AbstractCDOLockChangeInfo
extends Event
implements CDOLockChangeInfo {
    private static final long serialVersionUID = 1L;

    public AbstractCDOLockChangeInfo(INotifier notifier) {
        super(notifier);
    }

    @Override
    public final Set<CDOLockChangeInfo.Operation> getOperations() {
        HashSet<CDOLockChangeInfo.Operation> result = new HashSet<CDOLockChangeInfo.Operation>();
        CDOLockDelta[] cDOLockDeltaArray = this.getLockDeltas();
        int n = cDOLockDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOLockDelta delta = cDOLockDeltaArray[n2];
            CDOLockDelta.Kind kind = delta.getKind();
            switch (kind) {
                case ADDED: {
                    result.add(CDOLockChangeInfo.Operation.LOCK);
                    break;
                }
                case REMOVED: {
                    result.add(CDOLockChangeInfo.Operation.UNLOCK);
                    break;
                }
                case REMAPPED: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Invalid kind: " + (Object)((Object)kind)));
                }
            }
            ++n2;
        }
        return result;
    }

    @Override
    public final Set<IRWLockManager.LockType> getLockTypes() {
        HashSet<IRWLockManager.LockType> result = new HashSet<IRWLockManager.LockType>();
        CDOLockDelta[] cDOLockDeltaArray = this.getLockDeltas();
        int n = cDOLockDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOLockDelta delta = cDOLockDeltaArray[n2];
            IRWLockManager.LockType type = delta.getType();
            result.add(type);
            ++n2;
        }
        return result;
    }

    @Override
    public final Set<CDOID> getAffectedIDs() {
        HashSet<CDOID> ids = new HashSet<CDOID>();
        CDOLockDelta[] cDOLockDeltaArray = this.getLockDeltas();
        int n = cDOLockDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOLockDelta delta = cDOLockDeltaArray[n2];
            CDOID id = delta.getID();
            ids.add(id);
            ++n2;
        }
        return ids;
    }

    @Override
    @Deprecated
    public final CDOLockChangeInfo.Operation getOperation() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final IRWLockManager.LockType getLockType() {
        throw new UnsupportedOperationException();
    }
}

