/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import org.eclipse.cdt.cmake.core.internal.properties.CMakePropertiesBean;
import org.eclipse.cdt.cmake.core.properties.CMakeGenerator;
import org.eclipse.cdt.cmake.core.properties.ICMakeProperties;
import org.eclipse.cdt.cmake.core.properties.ICMakePropertiesController;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.inspector.TagInspector;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

class CMakePropertiesController
implements ICMakePropertiesController {
    private final Path storageFile;
    private final Runnable cmakeCacheDirtyMarker;
    private String cacheFile;
    private List<String> extraArguments;
    private CMakeGenerator generatorLinux;
    private List<String> extraArgumentsLinux;
    private CMakeGenerator generatorWindows;
    private List<String> extraArgumentsWindows;
    private String buildType;

    CMakePropertiesController(Path storageFile, Runnable cmakeCacheDirtyMarker) {
        this.storageFile = Objects.requireNonNull(storageFile);
        this.cmakeCacheDirtyMarker = Objects.requireNonNull(cmakeCacheDirtyMarker);
    }

    @Override
    public ICMakeProperties load() throws IOException {
        CMakePropertiesBean props = null;
        if (Files.exists(this.storageFile, new LinkOption[0])) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream is = Files.newInputStream(this.storageFile, new OpenOption[0]);){
                ClassLoader classLoader = this.getClass().getClassLoader();
                LoaderOptions loaderoptions = new LoaderOptions();
                TagInspector taginspector = tag -> tag.getClassName().equals(CMakePropertiesBean.class.getName());
                loaderoptions.setTagInspector(taginspector);
                CustomClassLoaderConstructor clConstructor = new CustomClassLoaderConstructor(classLoader, loaderoptions);
                props = (CMakePropertiesBean)new Yaml((BaseConstructor)clConstructor).loadAs(is, CMakePropertiesBean.class);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if (props == null) {
            props = new CMakePropertiesBean();
        }
        this.setupModifyDetection(props);
        return props;
    }

    @Override
    public void save(ICMakeProperties properties) throws IOException {
        if (this.isPropertyModified(properties) || this.isExtraArgumentsPropertyModified(properties)) {
            this.cmakeCacheDirtyMarker.run();
        }
        if (!Files.exists(this.storageFile, new LinkOption[0])) {
            try {
                Files.createFile(this.storageFile, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
        }
        Throwable throwable = null;
        Object var3_5 = null;
        try (OutputStreamWriter wr = new OutputStreamWriter(Files.newOutputStream(this.storageFile, new OpenOption[0]));){
            Representer customRepresenter = new Representer(new DumperOptions());
            customRepresenter.addClassTag(CMakePropertiesBean.class, Tag.MAP);
            new Yaml((BaseConstructor)new Constructor(CMakePropertiesBean.class, new LoaderOptions()), customRepresenter).dump((Object)properties, (Writer)wr);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.setupModifyDetection(properties);
    }

    private boolean isPropertyModified(ICMakeProperties properties) {
        return !Objects.equals(this.buildType, properties.getBuildType()) || !Objects.equals(this.cacheFile, properties.getCacheFile()) || !Objects.equals((Object)this.generatorLinux, (Object)properties.getLinuxOverrides().getGenerator()) || !Objects.equals((Object)this.generatorWindows, (Object)properties.getWindowsOverrides().getGenerator());
    }

    private boolean isExtraArgumentsPropertyModified(ICMakeProperties properties) {
        return this.hasExtraArgumentChanged(this.extraArguments, properties.getExtraArguments()) || this.hasExtraArgumentChanged(this.extraArgumentsLinux, properties.getLinuxOverrides().getExtraArguments()) || this.hasExtraArgumentChanged(this.extraArgumentsWindows, properties.getWindowsOverrides().getExtraArguments());
    }

    private void setupModifyDetection(ICMakeProperties properties) {
        this.buildType = properties.getBuildType();
        this.cacheFile = properties.getCacheFile();
        this.extraArguments = properties.getExtraArguments();
        this.generatorLinux = properties.getLinuxOverrides().getGenerator();
        this.extraArgumentsLinux = properties.getLinuxOverrides().getExtraArguments();
        this.generatorWindows = properties.getWindowsOverrides().getGenerator();
        this.extraArgumentsWindows = properties.getWindowsOverrides().getExtraArguments();
    }

    private boolean hasExtraArgumentChanged(List<String> expected, List<String> actual) {
        String a2;
        String wanted = "CMAKE_TOOLCHAIN_FILE";
        Predicate<String> predContains = a -> a.contains(wanted);
        BinaryOperator keepLast = (first, second) -> second;
        String a1 = expected.stream().filter(predContains).reduce(keepLast).orElse(null);
        return !Objects.equals(a1, a2 = (String)actual.stream().filter(predContains).reduce(keepLast).orElse(null));
    }
}

