/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.refactoring;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.refactoring.DeleteFileChange;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.xml.AbstractDocumentEditContext;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.utils.xml.DocumentModelVisitor;

public class RefactoringUtils {
    public static Change createRenameTypeChange(IType type, String newName, IProgressMonitor pm) throws CoreException {
        int flags = 589826;
        if (!Flags.isPrivate((int)type.getFlags())) {
            flags |= 4;
        }
        RenameJavaElementDescriptor descriptor = new RenameJavaElementDescriptor("org.eclipse.jdt.ui.rename.type");
        descriptor.setProject(type.getJavaProject().getElementName());
        descriptor.setFlags(flags);
        descriptor.setJavaElement((IJavaElement)type);
        descriptor.setNewName(newName);
        descriptor.setUpdateQualifiedNames(false);
        descriptor.setUpdateTextualOccurrences(false);
        descriptor.setUpdateReferences(true);
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        Refactoring refactoring = descriptor.createRefactoring(refactoringStatus);
        CreateChangeOperation createChangeOperation = new CreateChangeOperation(new CheckConditionsOperation(refactoring, 6), 4);
        createChangeOperation.run((IProgressMonitor)new SubProgressMonitor(pm, 6));
        return createChangeOperation.getChange();
    }

    public static Change createDeleteTypeChange(IType type) throws JavaModelException {
        IFile file = (IFile)type.getUnderlyingResource();
        return new DeleteFileChange(file);
    }

    public static void mergeTextChanges(Change targetChange, Change sourceChange) {
        Map<IFile, TextFileChange> sourceFileChanges = RefactoringUtils.getTextFileChanges(targetChange);
        Map<IFile, TextFileChange> targetFileChanges = RefactoringUtils.getTextFileChanges(sourceChange);
        for (Map.Entry<IFile, TextFileChange> entry : sourceFileChanges.entrySet()) {
            IFile file = entry.getKey();
            TextFileChange targetFileChange = targetFileChanges.get(file);
            if (targetFileChange == null) continue;
            TextFileChange sourceFileChange = entry.getValue();
            RefactoringUtils.mergeTextChanges((TextChange)targetFileChange, (TextChange)sourceFileChange);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void mergeTextChange(RefactoringParticipant participant, Change change) {
        Change change2 = change;
        if (change2 instanceof CompositeChange) {
            void compositeChange;
            CompositeChange compositeChange2 = (CompositeChange)change2;
            CompositeChange cfr_ignored_0 = (CompositeChange)change2;
            Change[] changeArray = compositeChange.getChildren();
            int n = changeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Change changeChild = changeArray[n2];
                RefactoringUtils.mergeTextChange(participant, changeChild);
                ++n2;
            }
        } else {
            Change change3 = change;
            if (change3 instanceof TextFileChange) {
                void textFileChange;
                TextFileChange changeChild = (TextFileChange)change3;
                TextFileChange cfr_ignored_1 = (TextFileChange)change3;
                TextChange existingChange = participant.getTextChange((Object)textFileChange.getFile());
                if (existingChange != null) {
                    RefactoringUtils.mergeTextChanges(existingChange, (TextChange)textFileChange);
                }
            }
        }
    }

    private static void mergeTextChanges(TextChange targetTextChange, TextChange sourceTextChange) {
        TextEdit rootEdit = sourceTextChange.getEdit();
        RefactoringUtils.mergeTextEdit(targetTextChange, rootEdit);
        Change parent = sourceTextChange.getParent();
        if (parent instanceof CompositeChange) {
            ((CompositeChange)parent).remove((Change)sourceTextChange);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void mergeTextEdit(TextChange targetTextChange, TextEdit textEdit) {
        TextEdit textEdit2 = textEdit;
        if (textEdit2 instanceof MultiTextEdit) {
            void multiTextEdit;
            MultiTextEdit multiTextEdit2 = (MultiTextEdit)textEdit2;
            MultiTextEdit cfr_ignored_0 = (MultiTextEdit)textEdit2;
            TextEdit[] textEditArray = multiTextEdit.getChildren();
            int n = textEditArray.length;
            int n2 = 0;
            while (n2 < n) {
                TextEdit child = textEditArray[n2];
                RefactoringUtils.mergeTextEdit(targetTextChange, child);
                ++n2;
            }
        } else {
            RefactoringUtils.ensureMultiTextEdit(targetTextChange);
            ReflectionUtils.invokeMethodEx((Object)textEdit, (String)"internalSetParent(org.eclipse.text.edits.TextEdit)", (Object[])new Object[]{null});
            targetTextChange.addEdit(textEdit);
        }
    }

    private static void ensureMultiTextEdit(TextChange textChange) {
        TextEdit textEdit = textChange.getEdit();
        if (!(textEdit instanceof MultiTextEdit)) {
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            multiTextEdit.addChild(textEdit);
            ReflectionUtils.setField((Object)textChange, (String)"fEdit", null);
            textChange.setEdit((TextEdit)multiTextEdit);
        }
    }

    private static Map<IFile, TextFileChange> getTextFileChanges(Change change) {
        HashMap textFileChanges = Maps.newHashMap();
        RefactoringUtils.addTextFileChanges(textFileChanges, change);
        return textFileChanges;
    }

    /*
     * WARNING - void declaration
     */
    private static void addTextFileChanges(Map<IFile, TextFileChange> textFileChanges, Change change) {
        Change change2 = change;
        if (change2 instanceof CompositeChange) {
            void compositeChange;
            CompositeChange compositeChange2 = (CompositeChange)change2;
            CompositeChange cfr_ignored_0 = (CompositeChange)change2;
            Change[] changeArray = compositeChange.getChildren();
            int n = changeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Change child = changeArray[n2];
                RefactoringUtils.addTextFileChanges(textFileChanges, child);
                ++n2;
            }
        } else {
            Change change3 = change;
            if (change3 instanceof TextFileChange) {
                void textFileChange;
                TextFileChange child = (TextFileChange)change3;
                TextFileChange cfr_ignored_1 = (TextFileChange)change3;
                textFileChanges.put(textFileChange.getFile(), (TextFileChange)textFileChange);
            }
        }
    }

    public static Change modifyXML(IFile file, DocumentModelVisitor visitor, AbstractDocumentEditContext context) throws Exception {
        try {
            String oldContents = context.getText();
            DocumentElement root = context.getRoot();
            root.accept(visitor);
            String newContents = context.getText();
            if (!newContents.equals(oldContents)) {
                RangeDifference[] differences;
                MultiTextEdit multiTextEdit = new MultiTextEdit();
                RangeDifference[] rangeDifferenceArray = differences = RangeDifferencer.findDifferences((IRangeComparator)new StringRangeComparator(oldContents), (IRangeComparator)new StringRangeComparator(newContents));
                int n = differences.length;
                int n2 = 0;
                while (n2 < n) {
                    RangeDifference difference = rangeDifferenceArray[n2];
                    int rightStart = difference.rightStart();
                    int rightEnd = difference.rightEnd();
                    String text = newContents.substring(rightStart, rightEnd);
                    int leftStart = difference.leftStart();
                    int leftLength = difference.leftLength();
                    multiTextEdit.addChild((TextEdit)new ReplaceEdit(leftStart, leftLength, text));
                    ++n2;
                }
                TextFileChange change = new TextFileChange("", file);
                change.setEdit((TextEdit)multiTextEdit);
                TextFileChange textFileChange = change;
                return textFileChange;
            }
            return null;
        }
        finally {
            context.disconnect();
        }
    }

    private static class StringRangeComparator
    implements IRangeComparator {
        private final String m_string;

        public StringRangeComparator(String string) {
            this.m_string = string;
            Assert.isTrue((!this.skipRangeComparison(0, 0, null) ? 1 : 0) != 0);
        }

        public int getRangeCount() {
            return this.m_string.length();
        }

        public boolean rangesEqual(int thisIndex, IRangeComparator other, int otherIndex) {
            StringRangeComparator otherComparator = (StringRangeComparator)other;
            return this.m_string.charAt(thisIndex) == otherComparator.m_string.charAt(otherIndex);
        }

        public boolean skipRangeComparison(int length, int maxLength, IRangeComparator other) {
            return false;
        }
    }
}

