/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util;

import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.AssociationUtils;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.InstanceFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.StaticFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.ComponentPresentation;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.description.MorphingTargetDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentPresentationHelper;
import org.eclipse.wb.internal.core.model.util.AbstractMorphingSupport;
import org.eclipse.wb.internal.core.model.variable.AbstractSimpleVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;

public abstract class MorphingSupport<T extends JavaInfo>
extends AbstractMorphingSupport<T> {
    private final AstEditor m_editor;

    protected MorphingSupport(String toolkitClassName, T component) {
        super(toolkitClassName, component);
        this.m_editor = ((JavaInfo)this.m_component).getEditor();
    }

    @Override
    protected IJavaProject getJavaProject() {
        return this.m_editor.getJavaProject();
    }

    @Override
    protected ClassLoader getClassLoader() {
        return EditorState.get(this.m_editor).getEditorLoader();
    }

    @Override
    protected Class<?> getComponentClass() {
        return ((JavaInfo)this.m_component).getDescription().getComponentClass();
    }

    @Override
    protected List<MorphingTargetDescription> getMorphingTargets() {
        return ((JavaInfo)this.m_component).getDescription().getMorphingTargets();
    }

    @Override
    protected String getTargetText(MorphingTargetDescription target) throws Exception {
        return this.getComponentPresentation(target).getName();
    }

    @Override
    protected ImageDescriptor getTargetImageDescriptor(MorphingTargetDescription target) throws Exception {
        ComponentPresentation presentation = this.getComponentPresentation(target);
        return presentation.getIcon();
    }

    private ComponentPresentation getComponentPresentation(MorphingTargetDescription target) throws Exception {
        return ComponentPresentationHelper.getPresentation(this.m_editor, target.getComponentClass().getName(), target.getCreationId());
    }

    public static void contribute(String toolkitClassName, JavaInfo component, IContributionManager manager) throws Exception {
        if (!(component.getVariableSupport() instanceof AbstractSimpleVariableSupport)) {
            return;
        }
        MorphingSupport<JavaInfo> morphingSupport = new MorphingSupport<JavaInfo>(toolkitClassName, component){};
        MorphingSupport.contribute(morphingSupport, manager);
    }

    @Override
    protected String validate(MorphingTargetDescription target) throws Exception {
        HashSet associationSignatures = Sets.newHashSet();
        for (JavaInfo child : ((JavaInfo)this.m_component).getChildrenJava()) {
            if (!(child.getAssociation() instanceof InvocationChildAssociation)) continue;
            InvocationChildAssociation association = (InvocationChildAssociation)child.getAssociation();
            String signature = association.getDescription().getSignature();
            associationSignatures.add(signature);
        }
        Class<?> targetClass = target.getComponentClass();
        ComponentDescription targetDescription = ComponentDescriptionHelper.getDescription(this.m_editor, targetClass);
        for (String associationSignature : associationSignatures) {
            MethodDescription method = targetDescription.getMethod(associationSignature);
            if (method == null) {
                return MessageFormat.format(ModelMessages.MorphingSupport_validateNoAssociationMethod, associationSignature);
            }
            boolean hasChild = false;
            List<ParameterDescription> parameters = method.getParameters();
            for (ParameterDescription parameter : parameters) {
                hasChild |= parameter.isChild();
            }
            if (hasChild) continue;
            return String.valueOf(ModelMessages.MorphingSupport_validateAssociationMethod_1) + associationSignature + ModelMessages.MorphingSupport_validateAssociationMethod_2 + ModelMessages.MorphingSupport_validateAssociationMethod_3 + ModelMessages.MorphingSupport_validateAssociationMethod_4;
        }
        return super.validate(target);
    }

    @Override
    protected void morph(MorphingTargetDescription target) throws Exception {
        if (((JavaInfo)this.m_component).getCreationSupport() instanceof ConstructorCreationSupport || ((JavaInfo)this.m_component).getCreationSupport() instanceof StaticFactoryCreationSupport || ((JavaInfo)this.m_component).getCreationSupport() instanceof InstanceFactoryCreationSupport) {
            super.morph(target);
        }
    }

    @Override
    protected T morph_create(MorphingTargetDescription target) throws Exception {
        ComponentDescription newDescription = ComponentDescriptionHelper.getDescription(this.m_editor, target.getComponentClass());
        ConstructorCreationSupport newCreationSupport = this.getTargetCreationSupport(target);
        return (T)((Object)JavaInfoUtils.createJavaInfo(this.m_editor, newDescription, (CreationSupport)newCreationSupport));
    }

    /*
     * WARNING - void declaration
     */
    private ConstructorCreationSupport getTargetCreationSupport(MorphingTargetDescription target) {
        CreationSupport creation;
        CreationSupport creationSupport;
        if (target.getCreationId() == null && (creationSupport = (creation = ((JavaInfo)this.m_component).getCreationSupport())) instanceof ConstructorCreationSupport) {
            void constructorCreation;
            ConstructorCreationSupport constructorCreationSupport = (ConstructorCreationSupport)creationSupport;
            ConstructorCreationSupport cfr_ignored_0 = (ConstructorCreationSupport)creationSupport;
            String signature = constructorCreation.getDescription().getSignature();
            Class<?> targetClass = target.getComponentClass();
            if (ReflectionUtils.getConstructorBySignature(targetClass, (String)signature) != null) {
                ClassInstanceCreation creationNode = constructorCreation.getCreation();
                String source = this.m_editor.getExternalSource((ASTNode)creationNode, from -> {
                    if (from == creationNode.getType()) {
                        return targetClass.getName();
                    }
                    return null;
                });
                return ConstructorCreationSupport.forSource(source);
            }
        }
        return new ConstructorCreationSupport(target.getCreationId(), false);
    }

    @Override
    protected void morph_replace(T newComponent) throws Exception {
        ((JavaInfo)this.m_component).getBroadcastJava().replaceChildBefore(((JavaInfo)this.m_component).getParentJava(), (JavaInfo)this.m_component, (JavaInfo)((Object)newComponent));
        ((JavaInfo)this.m_component).getParent().replaceChild(this.m_component, newComponent);
    }

    @Override
    protected void morph_properties(T newComponent) throws Exception {
        ComponentDescription newComponentDescription = ((JavaInfo)((Object)newComponent)).getDescription();
        for (ASTNode node : ((JavaInfo)this.m_component).getRelatedNodes()) {
            QualifiedName fieldAccess;
            MethodInvocation invocation;
            String signature;
            if (node.getLocationInParent() == MethodInvocation.EXPRESSION_PROPERTY && newComponentDescription.getMethod(signature = AstNodeUtils.getMethodSignature(invocation = (MethodInvocation)node.getParent())) == null) {
                this.m_editor.removeEnclosingStatement((ASTNode)invocation);
                continue;
            }
            if (node.getLocationInParent() == QualifiedName.QUALIFIER_PROPERTY && (fieldAccess = (QualifiedName)node.getParent()).getLocationInParent() == Assignment.LEFT_HAND_SIDE_PROPERTY) {
                String fieldName = fieldAccess.getName().getIdentifier();
                if (ReflectionUtils.getFieldByName(newComponentDescription.getComponentClass(), (String)fieldName) == null) {
                    this.m_editor.removeEnclosingStatement(node);
                    continue;
                }
            }
            ((JavaInfo)((Object)newComponent)).addRelatedNode(node);
        }
    }

    @Override
    protected void morph_children(T newComponent) throws Exception {
        for (JavaInfo javaChild : ((JavaInfo)this.m_component).getChildrenJava()) {
            newComponent.addChild((ObjectInfo)javaChild);
        }
    }

    @Override
    protected void morph_source(T newComponent) throws Exception {
        ComponentDescription newComponentDescription = ((JavaInfo)((Object)newComponent)).getDescription();
        AbstractSimpleVariableSupport variable = (AbstractSimpleVariableSupport)((JavaInfo)this.m_component).getVariableSupport();
        variable.setType(newComponentDescription.getComponentClass().getName());
        ((JavaInfo)this.m_component).getVariableSupport().moveTo((JavaInfo)((Object)newComponent));
        CreationSupport oldCreationSupport = ((JavaInfo)this.m_component).getCreationSupport();
        CreationSupport newCreationSupport = ((JavaInfo)((Object)newComponent)).getCreationSupport();
        Expression oldCreationExpression = (Expression)oldCreationSupport.getNode();
        StatementTarget statementTarget = new StatementTarget(AstNodeUtils.getEnclosingStatement((ASTNode)oldCreationExpression), true);
        String source = newCreationSupport.add_getSource(null);
        source = AssociationUtils.replaceTemplates(newComponent, source, statementTarget);
        Expression newCreationExpression = this.m_editor.replaceExpression(oldCreationExpression, source);
        newCreationSupport.add_setSourceExpression(newCreationExpression);
        ((JavaInfo)((Object)newComponent)).addRelatedNode((ASTNode)newCreationExpression);
        Association oldAssociation = ((JavaInfo)this.m_component).getAssociation();
        Association newAssociation = oldAssociation.getCopy();
        ((JavaInfo)((Object)newComponent)).setAssociation(newAssociation);
    }

    @Override
    protected void morph_finish(T newComponent) throws Exception {
        ((JavaInfo)this.m_component).getBroadcastJava().replaceChildAfter(((JavaInfo)this.m_component).getParentJava(), (JavaInfo)this.m_component, (JavaInfo)((Object)newComponent));
    }

    public static String validate(String toolkitClassName, JavaInfo component, MorphingTargetDescription target) throws Exception {
        MorphingSupport<JavaInfo> morphingSupport = new MorphingSupport<JavaInfo>(toolkitClassName, component){};
        return morphingSupport.validate(target);
    }

    public static void morph(String toolkitClassName, JavaInfo component, MorphingTargetDescription target) throws Exception {
        MorphingSupport<JavaInfo> morphingSupport = new MorphingSupport<JavaInfo>(toolkitClassName, component){};
        morphingSupport.morph(target);
    }
}

