/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.model.IObjectInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.creation.IImplicitCreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.IComponentDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.description.helpers.DescriptionPropertiesHelper;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.core.utils.state.IDescriptionHelper;
import org.eclipse.wb.internal.core.utils.state.ILayoutRequestValidatorHelper;
import org.eclipse.wb.internal.core.utils.state.IOrderProcessor;
import org.eclipse.wb.internal.core.utils.state.IOtherHelper;
import org.eclipse.wb.internal.core.utils.state.IParametersProvider;
import org.eclipse.wb.internal.core.utils.state.IPasteComponentProcessor;
import org.eclipse.wb.internal.core.utils.state.IPasteRequestProcessor;

public final class GlobalStateJava {
    private static final IParametersProvider m_parametersProvider = new IParametersProvider(){

        public Map<String, String> getParameters(Object object) {
            if (object instanceof JavaInfo) {
                return JavaInfoUtils.getParameters((JavaInfo)((Object)object));
            }
            if (object instanceof ComponentDescription) {
                return ((ComponentDescription)object).getParameters();
            }
            return null;
        }

        public String getParameter(Object object, String name) {
            if (object instanceof JavaInfo) {
                return JavaInfoUtils.getParameter((JavaInfo)((Object)object), name);
            }
            if (object instanceof ComponentDescription) {
                return ((ComponentDescription)object).getParameter(name);
            }
            return null;
        }

        public boolean hasTrueParameter(Object object, String name) {
            if (object instanceof JavaInfo) {
                return JavaInfoUtils.hasTrueParameter((JavaInfo)((Object)object), name);
            }
            return false;
        }
    };
    private static final IDescriptionHelper m_descriptionHelper = new IDescriptionHelper(){

        public PropertyEditor getEditorForType(Class<?> type) throws Exception {
            return DescriptionPropertiesHelper.getEditorForType(type);
        }

        public IComponentDescription getDescription(Object object) {
            if (object instanceof JavaInfo) {
                return ((JavaInfo)((Object)object)).getDescription();
            }
            return null;
        }
    };
    private static final ILayoutRequestValidatorHelper m_validatorHelper = new ILayoutRequestValidatorHelper(){

        public boolean isComponent(Object object) {
            return object instanceof JavaInfo;
        }

        public IComponentDescription getPasteComponentDescription(Object _memento) throws Exception {
            JavaInfoMemento memento = (JavaInfoMemento)_memento;
            JavaInfo activeJava = (JavaInfo)GlobalState.getActiveObject();
            return ComponentDescriptionHelper.getDescription(activeJava.getEditor(), memento.getComponentClassName());
        }

        public Object getPasteComponent(Object _memento) throws Exception {
            JavaInfoMemento memento = (JavaInfoMemento)_memento;
            JavaInfo activeJava = (JavaInfo)GlobalState.getActiveObject();
            return memento.create(activeJava);
        }

        /*
         * WARNING - void declaration
         */
        public boolean canUseParentForChild(Object parent, Object child) throws Exception {
            Object object = parent;
            if (object instanceof JavaInfo) {
                JavaInfo javaInfo = (JavaInfo)((Object)object);
                JavaInfo cfr_ignored_0 = (JavaInfo)((Object)object);
                if (child instanceof JavaInfo) {
                    void parentJava;
                    JavaInfo childJava = (JavaInfo)((Object)child);
                    return childJava.getCreationSupport().canUseParent((JavaInfo)parentJava);
                }
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public boolean canReference(Object object) {
            Object object2 = object;
            if (object2 instanceof JavaInfo) {
                void javaInfo;
                JavaInfo javaInfo2 = (JavaInfo)((Object)object2);
                JavaInfo cfr_ignored_0 = (JavaInfo)((Object)object2);
                return !(javaInfo.getCreationSupport() instanceof IImplicitCreationSupport);
            }
            return false;
        }

        public boolean canReorder(ObjectInfo component) {
            return ((JavaInfo)component).getCreationSupport().canReorder();
        }

        public boolean canReparent(ObjectInfo component) {
            return ((JavaInfo)component).getCreationSupport().canReparent();
        }
    };
    private static final IPasteRequestProcessor m_pasteRequestProcessor = new IPasteRequestProcessor(){

        public Command getPasteCommand(PasteRequest request, final IPasteComponentProcessor componentProcessor) {
            final List<IObjectInfo> components = this.getPastingComponents(request);
            if (components.isEmpty()) {
                return null;
            }
            ObjectInfo hierarchyObject = GlobalState.getActiveObject();
            return new EditCommand(hierarchyObject){

                protected void executeEdit() throws Exception {
                    for (IObjectInfo component : components) {
                        componentProcessor.process((Object)component);
                        JavaInfoMemento.apply((JavaInfo)component.getUnderlyingModel());
                    }
                }
            };
        }

        public List<IObjectInfo> getPastingComponents(PasteRequest request) {
            final List mementos = (List)request.getMemento();
            final ArrayList components = Lists.newArrayList();
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    JavaInfo hierarchyModel = (JavaInfo)GlobalState.getActiveObject();
                    for (JavaInfoMemento memento : mementos) {
                        JavaInfo component = memento.create(hierarchyModel);
                        components.add(component);
                    }
                }
            });
            request.setObjects((List)components);
            return components;
        }
    };
    private static final IOrderProcessor m_orderProcessor = new IOrderProcessor(){

        public void move(Object _component, Object _nextComponent) throws Exception {
            JavaInfo component = (JavaInfo)((Object)_component);
            JavaInfo nextComponent = (JavaInfo)((Object)_nextComponent);
            JavaInfo container = (JavaInfo)component.getParent();
            JavaInfoUtils.move(component, null, container, nextComponent);
        }
    };
    private static final IOtherHelper m_otherHelper = new IOtherHelper(){

        public IJavaProject getJavaProject() {
            JavaInfo javaInfo = (JavaInfo)GlobalState.getActiveObject();
            return javaInfo.getEditor().getJavaProject();
        }

        public Object getObject(ObjectInfo model) {
            if (model instanceof JavaInfo) {
                return ((JavaInfo)model).getObject();
            }
            return null;
        }

        public List<EditorWarning> getWarnings() {
            return this.getState().getWarnings();
        }

        public void addWarning(EditorWarning warning) {
            this.getState().addWarning(warning);
        }

        private EditorState getState() {
            JavaInfo javaInfo = (JavaInfo)GlobalState.getActiveObject();
            return JavaInfoUtils.getState(javaInfo);
        }
    };

    public static void activate(JavaInfo javaInfo) {
        EditorState.setActiveJavaInfo(javaInfo);
        GlobalState.setActiveObject((ObjectInfo)javaInfo);
        if (javaInfo != null) {
            GlobalState.setToolkit((ToolkitDescription)javaInfo.getDescription().getToolkit());
            GlobalState.setClassLoader((ClassLoader)JavaInfoUtils.getClassLoader(javaInfo));
        } else {
            GlobalState.setToolkit(null);
            GlobalState.setClassLoader(null);
        }
        GlobalState.setParametersProvider((IParametersProvider)m_parametersProvider);
        GlobalState.setDescriptionHelper((IDescriptionHelper)m_descriptionHelper);
        GlobalState.setValidatorHelper((ILayoutRequestValidatorHelper)m_validatorHelper);
        GlobalState.setPasteRequestProcessor((IPasteRequestProcessor)m_pasteRequestProcessor);
        GlobalState.setOrderProcessor((IOrderProcessor)m_orderProcessor);
        GlobalState.setOtherHelper((IOtherHelper)m_otherHelper);
    }

    public static void deactivate(JavaInfo javaInfo) {
        if (GlobalState.getActiveObject() == javaInfo) {
            GlobalStateJava.deactivate();
        }
    }

    public static void deactivate() {
        EditorState.setActiveJavaInfo(null);
        GlobalState.setActiveObject(null);
        GlobalState.setToolkit(null);
        GlobalState.setClassLoader(null);
        GlobalState.setParametersProvider(null);
        GlobalState.setDescriptionHelper(null);
        GlobalState.setValidatorHelper(null);
        GlobalState.setPasteRequestProcessor(null);
        GlobalState.setOrderProcessor(null);
        GlobalState.setOtherHelper(null);
    }
}

