/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.console;

import java.io.IOException;
import java.nio.charset.Charset;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;

public class MessageConsoleStream
extends IOConsoleOutputStream {
    private MessageConsole fMessageConsole;

    public MessageConsoleStream(MessageConsole console) {
        this(console, Charset.forName(WorkbenchEncoding.getWorkbenchDefaultEncoding()));
    }

    public MessageConsoleStream(MessageConsole console, Charset charset) {
        super(console, charset);
        this.fMessageConsole = console;
    }

    public void print(String message) {
        try {
            this.write(message);
        }
        catch (IOException e) {
            ConsolePlugin.log(e);
        }
    }

    public void println() {
        try {
            this.write("\n");
        }
        catch (IOException e) {
            ConsolePlugin.log(e);
        }
    }

    public void println(String message) {
        this.print(message + "\n");
    }

    public MessageConsole getConsole() {
        return this.fMessageConsole;
    }
}

