/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.common;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.common.TypedModelConfiguration;
import org.eclipse.qvtd.compiler.internal.common.TypedModelsConfiguration;
import org.eclipse.qvtd.compiler.internal.common.TypedModelsConfigurations;
import org.eclipse.qvtd.pivot.qvtbase.CompoundTargetElement;
import org.eclipse.qvtd.pivot.qvtbase.SimpleTargetElement;
import org.eclipse.qvtd.pivot.qvtbase.Target;
import org.eclipse.qvtd.pivot.qvtbase.TargetElement;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;

public class TargetConfiguration
extends TypedModelsConfiguration {
    private final @NonNull String targetName;

    public static @NonNull TypedModelsConfigurations createTargetConfigurations(String ... targetNames) {
        TypedModelsConfigurations typedModelsConfigurations = new TypedModelsConfigurations();
        String[] stringArray = targetNames;
        int n = targetNames.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull String targetName = stringArray[n2];
            typedModelsConfigurations.add(new TargetConfiguration(targetName));
            ++n2;
        }
        return typedModelsConfigurations;
    }

    public TargetConfiguration(@NonNull String targetName) {
        super(new String[0]);
        this.targetName = targetName;
    }

    protected void addTargetElement(@NonNull SimpleTargetElement simpleTargetElement) {
        TypedModelConfiguration.Mode mode;
        switch (simpleTargetElement.getKind()) {
            case INPUT: {
                mode = TypedModelConfiguration.Mode.INPUT;
                break;
            }
            case OUTPUT: {
                mode = TypedModelConfiguration.Mode.OUTPUT;
                break;
            }
            case VIA: {
                mode = TypedModelConfiguration.Mode.INTERMEDIATE;
                break;
            }
            default: {
                mode = TypedModelConfiguration.Mode.UNUSED;
            }
        }
        this.addTypedModelConfiguration(new TypedModelConfiguration(QVTbaseUtil.getTypedModel((SimpleTargetElement)simpleTargetElement), mode));
    }

    @Override
    public @NonNull String getTargetName() {
        return this.targetName;
    }

    @Override
    public @Nullable String reconcile(@NonNull Transformation transformation) {
        Target target = QVTbaseUtil.getOwnedTarget((Transformation)transformation, (String)this.targetName);
        for (TargetElement targetElement : QVTbaseUtil.getOwnedTargetElements((Target)target)) {
            if (targetElement instanceof CompoundTargetElement) {
                for (SimpleTargetElement simpleTargetElement : QVTbaseUtil.getOwnedTargetElements((CompoundTargetElement)((CompoundTargetElement)targetElement))) {
                    this.addTargetElement(simpleTargetElement);
                }
                continue;
            }
            this.addTargetElement((SimpleTargetElement)targetElement);
        }
        for (TypedModel typedModel : QVTbaseUtil.getModelParameters((Transformation)transformation)) {
            if (typedModel.isIsPrimitive() || typedModel.isIsThis() || typedModel.isIsTrace() || this.basicGetTypedModelConfiguration(typedModel) != null) continue;
            this.addTypedModelConfiguration(new TypedModelConfiguration(typedModel, TypedModelConfiguration.Mode.UNUSED));
        }
        return super.reconcile(transformation);
    }
}

