/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.terminal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.composer.core.ComposerPlugin;
import org.eclipse.php.composer.core.launch.ScriptLauncher;
import org.eclipse.php.composer.core.launch.ScriptNotFoundException;
import org.eclipse.php.composer.core.launch.environment.Environment;
import org.eclipse.php.composer.core.launch.execution.ExecutionResponseListener;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.composer.ui.terminal.Messages;
import org.eclipse.php.composer.ui.terminal.TerminalConsole;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalService;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalServiceOutputStreamMonitorListener;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;

public class ComposerLauncher
extends ScriptLauncher {
    private static final String WINDOWS_END_OF_LINE = "\r\n";
    private IProject project;
    private TerminalConsole terminalConsole;

    public ComposerLauncher(Environment environment, IProject project) throws ScriptNotFoundException {
        super(environment, project);
        this.project = project;
    }

    public void launch(String argument, String ... params) throws IOException, InterruptedException, CoreException {
        ProcessBuilder cmd = this.prepare(argument, params);
        Map<String, String> env = cmd.environment();
        ArrayList<String> strings = new ArrayList<String>(env.size());
        StringBuilder buffer = null;
        for (Map.Entry<String, String> entry : env.entrySet()) {
            buffer = new StringBuilder(entry.getKey());
            buffer.append('=').append(entry.getValue());
            strings.add(buffer.toString());
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("process.environment", strings.toArray());
        properties.put("process.environment.merge", true);
        ITerminalServiceOutputStreamMonitorListener[] outListeners = new ITerminalServiceOutputStreamMonitorListener[]{new ITerminalServiceOutputStreamMonitorListener(){

            public void onContentReadFromStream(byte[] byteBuffer, int bytesRead) {
                for (ExecutionResponseListener handler : ComposerLauncher.this.getListeners()) {
                    handler.executionMessage(new String(byteBuffer, 0, bytesRead));
                }
            }
        }};
        properties.put("stdoutListeners", outListeners);
        if ("win32".equals(Platform.getOS())) {
            builder = new StringBuilder();
            builder.append("@echo off").append(WINDOWS_END_OF_LINE);
            builder.append("chcp 65001").append(WINDOWS_END_OF_LINE);
            builder.append("cls").append(WINDOWS_END_OF_LINE);
            builder.append(this.escapePath(cmd.command().remove(0)));
            cmd.command().stream().forEach(part -> {
                StringBuilder stringBuilder2 = builder.append(' ').append((String)part);
            });
            File file = File.createTempFile("composer_windows_", ".bat");
            file.deleteOnExit();
            try {
                Throwable throwable = null;
                Object var12_14 = null;
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                    writer.write(builder.toString());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException ex) {
                ComposerPlugin.logException((Exception)ex);
            }
            properties.put("process.path", "cmd");
            String args = "/C " + file.getAbsolutePath();
            properties.put("process.args", args);
        } else {
            properties.put("process.path", this.escapePath(cmd.command().remove(0)));
            builder = new StringBuilder();
            cmd.command().stream().forEach(part -> {
                StringBuilder stringBuilder2 = builder.append((String)part).append(' ');
            });
            properties.put("process.args", builder.toString());
        }
        Logger.debug((String)("Setting executor working directory to " + this.project.getLocation().toOSString()));
        properties.put("process.working_dir", this.project.getLocation().toOSString());
        String title = MessageFormat.format(Messages.ComposerConsoleManager_ConsoleLabel, Messages.ComposerConsoleManager_ConsoleName, this.project.getName());
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        final CountDownLatch latch = new CountDownLatch(1);
        this.terminalConsole = new TerminalConsole(title, 0, properties, new ITerminalService.Done(){

            public void done(IStatus status) {
                latch.countDown();
            }
        });
        for (ExecutionResponseListener handler : this.getListeners()) {
            handler.executionStarted();
        }
        consoleManager.addConsoles(new IConsole[]{this.terminalConsole});
        consoleManager.showConsoleView((IConsole)this.terminalConsole);
        latch.await();
        for (ExecutionResponseListener handler : this.getListeners()) {
            handler.executionFinished("", 0);
        }
    }

    public void abort() {
        this.terminalConsole.getTerminalConnector().disconnect();
    }

    private String escapePath(String path) {
        return String.valueOf('\"') + path.replace("\\", "\\\\") + '\"';
    }
}

