/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerImageSearchResult;
import org.eclipse.linuxtools.docker.core.IRegistry;
import org.eclipse.linuxtools.docker.core.IRepositoryTag;
import org.eclipse.linuxtools.docker.core.Messages;
import org.eclipse.linuxtools.internal.docker.core.DockerImageSearchResult;
import org.eclipse.linuxtools.internal.docker.core.ImageSearchResultV1;
import org.eclipse.linuxtools.internal.docker.core.ImageSearchResultV2;
import org.eclipse.linuxtools.internal.docker.core.OAuth2Utils;
import org.eclipse.linuxtools.internal.docker.core.RepositoryTag;
import org.eclipse.linuxtools.internal.docker.core.RepositoryTagV2;
import org.eclipse.osgi.util.NLS;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.mandas.docker.client.ObjectMapperProvider;
import org.mandas.docker.client.messages.ImageSearchResult;

public abstract class AbstractRegistry
implements IRegistry {
    public static final String[] DOCKERHUB_REGISTRY_ALIASES = new String[]{"registry.hub.docker.com", "index.docker.io"};
    private static final ClientConfig DEFAULT_CONFIG = new ClientConfig(new Class[]{ObjectMapperProvider.class, JacksonFeature.class});
    public static final String DOCKERHUB_REGISTRY = "https://index.docker.io";
    private String cachedHTTPServerAddress;
    private Boolean isV2 = null;

    @Override
    public abstract String getServerAddress();

    public abstract String getServerHost();

    public abstract boolean isDockerHubRegistry();

    public abstract boolean isAuthProvided();

    private String getHTTPServerAddress() {
        if (this.cachedHTTPServerAddress != null) {
            return this.cachedHTTPServerAddress;
        }
        if (this.getServerAddress().startsWith("http")) {
            return this.getServerAddress();
        }
        String[] versions = new String[]{"v1", "v2"};
        String[] schemes = new String[]{"http://", "https://"};
        ClientConfig DEFAULT_CONFIG = new ClientConfig(new Class[]{ObjectMapperProvider.class, JacksonFeature.class});
        Client client = ClientBuilder.newClient((Configuration)DEFAULT_CONFIG);
        String[] stringArray = schemes;
        int n = schemes.length;
        int n2 = 0;
        while (n2 < n) {
            String scheme = stringArray[n2];
            String[] stringArray2 = versions;
            int n3 = versions.length;
            int n4 = 0;
            while (n4 < n3) {
                String ver = stringArray2[n4];
                String url = String.valueOf(scheme) + this.getServerAddress();
                WebTarget queryServer = client.target(url).path(ver);
                try {
                    this.enableDockerAuthenticator();
                    Response resp = (Response)queryServer.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).async().method("GET").get();
                    int code = resp.getStatus();
                    if (code >= 200 && code < 300) {
                        this.cachedHTTPServerAddress = url;
                        String string = url;
                        return string;
                    }
                }
                catch (InterruptedException | ExecutionException exception) {
                }
                finally {
                    this.restoreAuthenticator();
                }
                ++n4;
            }
            ++n2;
        }
        return "http://" + this.getServerAddress();
    }

    @Override
    public List<IDockerImageSearchResult> getImages(String term) throws DockerException {
        Client client = ClientBuilder.newClient((Configuration)DEFAULT_CONFIG);
        ArrayList<IDockerImageSearchResult> result = new ArrayList<IDockerImageSearchResult>();
        if (this.isVersion2()) {
            GenericType<ImageSearchResultV2> IMAGE_SEARCH_RESULT_LIST = new GenericType<ImageSearchResultV2>(){};
            ImageSearchResultV2 cisr = null;
            WebTarget queryImagesResource = client.target(this.getHTTPServerAddress()).path("v2").path("_catalog");
            try {
                cisr = (ImageSearchResultV2)queryImagesResource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).async().method("GET", (GenericType)IMAGE_SEARCH_RESULT_LIST).get();
            }
            catch (InterruptedException | ExecutionException e2) {
                throw new DockerException(e2);
            }
            List<ImageSearchResult> tmp = cisr.getRepositories().stream().filter(e -> e.name().contains(term)).toList();
            result.addAll(tmp.stream().map(r -> new DockerImageSearchResult(r.description(), r.official(), r.automated(), r.name(), r.starCount())).toList());
        } else {
            ImageSearchResultV1 pisr = null;
            GenericType<ImageSearchResultV1> IMAGE_SEARCH_RESULT_LIST = new GenericType<ImageSearchResultV1>(){};
            int page = 0;
            try {
                while (pisr == null || pisr.getPage() < pisr.getTotalPages()) {
                    WebTarget queryImagesResource = client.target(this.getHTTPServerAddress()).path("v1").path("search").queryParam("q", new Object[]{term}).queryParam("page", new Object[]{++page});
                    pisr = (ImageSearchResultV1)queryImagesResource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).async().method("GET", (GenericType)IMAGE_SEARCH_RESULT_LIST).get();
                    List<ImageSearchResult> tmp = pisr.getResult();
                    result.addAll(tmp.stream().map(r -> new DockerImageSearchResult(r.description(), r.official(), r.automated(), r.name(), r.starCount())).toList());
                }
            }
            catch (InterruptedException | ExecutionException e3) {
                throw new DockerException(e3);
            }
        }
        return result;
    }

    @Override
    public List<IRepositoryTag> getTags(String repository) throws DockerException {
        Client client = ClientBuilder.newClient((Configuration)DEFAULT_CONFIG);
        try {
            if (this.isVersion2()) {
                return this.retrieveTagsFromRegistryV2(client, repository);
            }
            if (this.isDockerHubRegistry()) {
                return this.retrieveTagsFromDockerHub(client, repository);
            }
            return this.retrieveTagsFromRegistryV1(client, repository);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new DockerException(e);
        }
    }

    private List<IRepositoryTag> retrieveTagsFromDockerHub(Client client, String repository) throws DockerException {
        try {
            String repoName = repository.contains("/") ? repository : "library/" + repository;
            WebTarget queryTagsResource = client.target(this.getHTTPServerAddress()).path("v2").path(repoName).path("tags").path("list");
            Response response = (Response)queryTagsResource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).async().get().get(10L, TimeUnit.SECONDS);
            if (response.getStatus() == 200) {
                return ((RepositoryTagV2)response.readEntity(RepositoryTagV2.class)).getTags();
            }
            if (response.getStatus() != 401) {
                throw new DockerException(NLS.bind((String)Messages.ImageTagsList_failure, (Object)repository, (Object)response.readEntity(String.class)));
            }
            String wwwAuthenticateResponseHeader = response.getHeaderString("Www-Authenticate");
            Map<String, String> authenticateInfo = OAuth2Utils.parseWwwAuthenticateHeader(wwwAuthenticateResponseHeader);
            if (!(authenticateInfo != null && authenticateInfo.containsKey("realm") && authenticateInfo.containsKey("service") && authenticateInfo.containsKey("scope"))) {
                throw new DockerException(NLS.bind((String)Messages.ImageTagsList_failure_invalidWwwAuthenticateFormat, (Object)repository));
            }
            String realm = authenticateInfo.get("realm");
            String service = authenticateInfo.get("service");
            String scope = authenticateInfo.get("scope");
            WebTarget bearerTokenRetrievalTarget = client.target(realm).queryParam("service", new Object[]{service}).queryParam("scope", new Object[]{scope});
            OAuth2Utils.BearerTokenResponse bearerTokenRetrievalResponse = (OAuth2Utils.BearerTokenResponse)bearerTokenRetrievalTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).async().get(OAuth2Utils.BearerTokenResponse.class).get(10L, TimeUnit.SECONDS);
            WebTarget queryTagsResourceWithBearerTokenTarget = client.target(this.getHTTPServerAddress()).path("v2").path(repoName).path("tags").path("list");
            return ((RepositoryTagV2)queryTagsResourceWithBearerTokenTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)("Bearer " + bearerTokenRetrievalResponse.getToken())).async().get(RepositoryTagV2.class).get(10L, TimeUnit.SECONDS)).getTags();
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new DockerException(NLS.bind((String)Messages.ImageTagsList_failure, (Object)repository, (Object)e.getMessage()), e);
        }
    }

    private List<IRepositoryTag> retrieveTagsFromRegistryV1(Client client, String repository) throws InterruptedException, ExecutionException {
        GenericType<Map<String, String>> REPOSITORY_TAGS_RESULT_LIST = new GenericType<Map<String, String>>(){};
        WebTarget queryTagsResource = client.target(this.getHTTPServerAddress()).path("v1").path("repositories").path(repository).path("tags");
        return ((Map)queryTagsResource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).async().method("GET", (GenericType)REPOSITORY_TAGS_RESULT_LIST).get()).entrySet().stream().map(e -> new RepositoryTag((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }

    private List<IRepositoryTag> retrieveTagsFromRegistryV2(Client client, String repository) throws InterruptedException, ExecutionException {
        GenericType<RepositoryTagV2> REPOSITORY_TAGS_RESULT_LIST = new GenericType<RepositoryTagV2>(){};
        WebTarget queryTagsResource = client.target(this.getHTTPServerAddress()).path("v2").path(repository).path("tags").path("list");
        RepositoryTagV2 crts = (RepositoryTagV2)queryTagsResource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).async().method("GET", (GenericType)REPOSITORY_TAGS_RESULT_LIST).get();
        return crts.getTags();
    }

    @Override
    public boolean isVersion2() {
        if (this.isV2 != null) {
            return this.isV2;
        }
        ClientConfig DEFAULT_CONFIG = new ClientConfig(new Class[]{ObjectMapperProvider.class, JacksonFeature.class});
        Client client = ClientBuilder.newClient((Configuration)DEFAULT_CONFIG);
        WebTarget pingApiv2Resource = client.target(this.getHTTPServerAddress()).path("v2");
        try {
            Response response = (Response)pingApiv2Resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).async().get().get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                this.isV2 = true;
                return true;
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
        this.isV2 = false;
        return false;
    }

    protected abstract void enableDockerAuthenticator();

    protected abstract void restoreAuthenticator();
}

