/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.tcl.internal.ui.DefaultTclSemanticHighlightingExtension;
import org.eclipse.dltk.tcl.ui.semantilhighlighting.ISemanticHighlightingExtension;
import org.eclipse.dltk.ui.editor.highlighting.ASTSemanticHighlighter;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlightingRequestor;
import org.eclipse.dltk.ui.editor.highlighting.SemanticHighlighting;

public class TclSemanticPositionUpdater
extends ASTSemanticHighlighter {
    private final ISemanticHighlightingExtension[] extensions;

    public TclSemanticPositionUpdater(ISemanticHighlightingExtension[] extensions) {
        this.extensions = extensions;
    }

    public SemanticHighlighting[] getSemanticHighlightings() {
        ArrayList<SemanticHighlighting> highlightings = new ArrayList<SemanticHighlighting>();
        int i = 0;
        while (i < this.extensions.length) {
            SemanticHighlighting[] hl = this.extensions[i].getHighlightings();
            if (hl != null) {
                highlightings.addAll(Arrays.asList(hl));
            }
            ++i;
        }
        SemanticHighlighting[] ret = new SemanticHighlighting[highlightings.size()];
        int i2 = 0;
        while (i2 < highlightings.size()) {
            ret[i2] = (SemanticHighlighting)highlightings.get(i2);
            ++i2;
        }
        return ret;
    }

    protected String getNature() {
        return "org.eclipse.dltk.tcl.core.nature";
    }

    protected boolean doHighlighting(IModuleSource code) throws Exception {
        ModuleDeclaration declaration = (ModuleDeclaration)this.parseCode(code);
        if (declaration != null) {
            declaration.traverse(new ASTVisitor(){

                public boolean visitGeneral(ASTNode node) throws Exception {
                    int i = 0;
                    while (i < TclSemanticPositionUpdater.this.extensions.length) {
                        TclSemanticPositionUpdater.this.extensions[i].processNode(node, (ISemanticHighlightingRequestor)TclSemanticPositionUpdater.this);
                        ++i;
                    }
                    return true;
                }
            });
            int i = 0;
            while (i < this.extensions.length) {
                if (this.extensions[i] instanceof DefaultTclSemanticHighlightingExtension) {
                    DefaultTclSemanticHighlightingExtension hl = (DefaultTclSemanticHighlightingExtension)this.extensions[i];
                    hl.doOtherHighlighting(code, (ISemanticHighlightingRequestor)this);
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

