/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.validation;

import com.ibm.icu.util.StringTokenizer;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.dtd.core.internal.validation.DTDValidationMessages;
import org.eclipse.wst.dtd.core.internal.validation.ElementRefLocation;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.validation.core.LazyURLInputStream;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationInfo;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class DTDValidator {
    private URIResolver fResolver = null;

    public void setURIResolver(URIResolver uriresolver) {
        this.fResolver = uriresolver;
    }

    public ValidationReport validate(String uri) {
        ValidationInfo valinfo = new ValidationInfo(uri);
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setValidating(true);
            SAXParser parser = parserFactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            MultiHandler dtdHandler = new MultiHandler();
            reader.setProperty("http://xml.org/sax/properties/declaration-handler", dtdHandler);
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", dtdHandler);
            reader.setContentHandler(dtdHandler);
            reader.setDTDHandler(dtdHandler);
            reader.setErrorHandler(new DTDErrorHandler(valinfo));
            reader.setEntityResolver(new DTDEntityResolver(this.fResolver, uri));
            String document = "<!DOCTYPE root SYSTEM \"" + uri + "\"><root/>";
            boolean resolveExternalEntities = InstanceScope.INSTANCE.getNode(XMLCorePlugin.getDefault().getBundle().getSymbolicName()).getBoolean("resolveExternalEntities", false);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", resolveExternalEntities);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", resolveExternalEntities);
            reader.parse(new InputSource(new StringReader(document)));
            Map<String, List<ElementLocation>> elemDecls = dtdHandler.getElementDeclarations();
            Map<String, ElementRefLocation> elemRefs = dtdHandler.getElementReferences();
            this.validateElementReferences(elemDecls, elemRefs, valinfo);
            this.validateDuplicateElementDecls(elemDecls, valinfo);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {}
        return valinfo;
    }

    private void validateDuplicateElementDecls(Map<String, List<ElementLocation>> elemDecls, ValidationInfo valinfo) {
        for (Map.Entry<String, List<ElementLocation>> elem : elemDecls.entrySet()) {
            List<ElementLocation> locations = elem.getValue();
            if (locations.size() <= 1) continue;
            for (ElementLocation elemLoc : locations) {
                valinfo.addError(NLS.bind((String)DTDValidationMessages._ERROR_DUPLICATE_ELEMENT_DECLARATION, (Object)("'" + elem.getKey() + "'")), elemLoc.line, elemLoc.column, elemLoc.uri);
            }
        }
    }

    private void validateElementReferences(Map<String, List<ElementLocation>> elemDecls, Map<String, ElementRefLocation> elemRefs, ValidationInfo valinfo) {
        for (String elemRef : elemRefs.keySet()) {
            if (elemDecls.containsKey(elemRef)) continue;
            ElementRefLocation elemLoc = elemRefs.get(elemRef);
            do {
                valinfo.addError(NLS.bind((String)DTDValidationMessages._ERROR_REF_ELEMENT_UNDEFINED, (Object)("'" + elemRef + "'")), elemLoc.getLine(), elemLoc.getColumn(), elemLoc.getURI());
            } while ((elemLoc = elemLoc.getNext()) != null);
        }
    }

    class DTDEntityResolver
    implements EntityResolver {
        private String fBaseLocation = null;
        private URIResolver fURIResolver = null;

        public DTDEntityResolver(URIResolver uriresolver, String baselocation) {
            this.fURIResolver = uriresolver;
            if (this.fURIResolver == null) {
                this.fURIResolver = URIResolverPlugin.createResolver();
            }
            this.fBaseLocation = baselocation;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            String location = null;
            location = this.fBaseLocation.equals(systemId) ? systemId : this.fURIResolver.resolve(this.fBaseLocation, publicId, systemId);
            InputSource is = null;
            if (location != null && !location.equals("")) {
                String physical = this.fURIResolver.resolvePhysicalLocation(this.fBaseLocation, publicId, location);
                is = new InputSource(location);
                is.setByteStream((InputStream)new LazyURLInputStream(physical));
            }
            return is;
        }
    }

    class DTDErrorHandler
    implements ErrorHandler {
        private final int ERROR = 0;
        private final ValidationInfo fValidationInfo;
        private final int WARNING = 1;

        public DTDErrorHandler(ValidationInfo valinfo) {
            this.fValidationInfo = valinfo;
        }

        protected void addValidationMessage(SAXParseException exception, int severity) {
            if (exception.getSystemId() != null) {
                if (severity == 1) {
                    this.fValidationInfo.addWarning(exception.getLocalizedMessage(), exception.getLineNumber(), exception.getColumnNumber(), exception.getSystemId());
                } else {
                    this.fValidationInfo.addError(exception.getLocalizedMessage(), exception.getLineNumber(), exception.getColumnNumber(), exception.getSystemId());
                }
            }
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.addValidationMessage(exception, 0);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.addValidationMessage(exception, 0);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.addValidationMessage(exception, 1);
        }
    }

    class ElementLocation {
        int column = -1;
        int line = -1;
        String uri;

        ElementLocation(int column, int line, String uri) {
            this.column = column;
            this.line = line;
            this.uri = uri;
        }
    }

    class MultiHandler
    extends DefaultHandler
    implements DTDHandler,
    ContentHandler,
    LexicalHandler,
    DeclHandler {
        private static final String ELEMENT_MODIFIERS = "*+?";
        private static final String MODEL_DELIMITERS = ",()| ";
        private Map<String, List<ElementLocation>> fElemDecls = new HashMap<String, List<ElementLocation>>();
        private Map<String, ElementRefLocation> fElemRefs = new HashMap<String, ElementRefLocation>();
        private List<String> fIgnoreElemModel = new ArrayList<String>();
        private List<String> fIgnoreElemRefs = new ArrayList<String>();
        private Locator fLocator = null;

        public MultiHandler() {
            this.fIgnoreElemRefs.add("#PCDATA");
            this.fIgnoreElemModel.add("ANY");
            this.fIgnoreElemModel.add("EMPTY");
        }

        @Override
        public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
        }

        @Override
        public void comment(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        @Override
        public void elementDecl(String name, String model) throws SAXException {
            int line = this.fLocator.getLineNumber();
            int column = this.fLocator.getColumnNumber();
            String uri = this.fLocator.getSystemId();
            List<ElementLocation> locations = this.fElemDecls.get(name);
            if (locations == null) {
                locations = new ArrayList<ElementLocation>();
                this.fElemDecls.put(name, locations);
            }
            locations.add(new ElementLocation(column, line, uri));
            if (this.fIgnoreElemModel.contains(model)) {
                return;
            }
            StringTokenizer strtok = new StringTokenizer(model, MODEL_DELIMITERS);
            while (strtok.hasMoreTokens()) {
                int tokenlength;
                String token = strtok.nextToken();
                if (ELEMENT_MODIFIERS.indexOf(token.charAt((tokenlength = token.length()) - 1)) != -1 && (token = token.substring(0, tokenlength - 1)).length() == 0 || this.fIgnoreElemRefs.contains(token)) continue;
                ElementRefLocation elemLoc = this.fElemRefs.get(token);
                ElementRefLocation tokenLoc = new ElementRefLocation(line, column, uri, elemLoc);
                this.fElemRefs.put(token, tokenLoc);
            }
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void endEntity(String arg0) throws SAXException {
        }

        @Override
        public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        }

        public Map<String, List<ElementLocation>> getElementDeclarations() {
            return this.fElemDecls;
        }

        public Map<String, ElementRefLocation> getElementReferences() {
            return this.fElemRefs;
        }

        @Override
        public void internalEntityDecl(String name, String value) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            super.setDocumentLocator(locator);
            this.fLocator = locator;
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }
    }
}

