/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout.grid;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.util.surround.ISurroundProcessor;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swt.model.layout.grid.GridDataInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridLayoutSurroundSupport;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;

public final class GridLayoutSurroundProcessor
implements ISurroundProcessor<CompositeInfo, ControlInfo> {
    public static final Object INSTANCE = new GridLayoutSurroundProcessor();

    private GridLayoutSurroundProcessor() {
    }

    public boolean filter(CompositeInfo sourceContainer, CompositeInfo targetContainer) throws Exception {
        String targetClassName = targetContainer.getDescription().getComponentClass().getName();
        boolean isComposite = targetClassName.equals("org.eclipse.swt.widgets.Composite");
        boolean isGroup = targetClassName.equals("org.eclipse.swt.widgets.Group");
        return sourceContainer.hasLayout() && sourceContainer.getLayout() instanceof GridLayoutInfo && (isComposite || isGroup);
    }

    public void move(CompositeInfo sourceContainer, CompositeInfo targetContainer, List<ControlInfo> components) throws Exception {
        GridLayoutInfo targetLayout = (GridLayoutInfo)JavaInfoUtils.createJavaInfo((AstEditor)targetContainer.getEditor(), (String)"org.eclipse.swt.layout.GridLayout", (CreationSupport)new ConstructorCreationSupport());
        targetContainer.setLayout(targetLayout);
        Rectangle targetBounds = (Rectangle)targetContainer.getArbitraryValue("SurroundSupport_CELLS");
        Point locationOffset = targetBounds.getLocation().getNegated();
        targetLayout.prepareCell(targetBounds.width - 1, false, targetBounds.height - 1, false);
        for (ControlInfo component : components) {
            GridDataInfo gridData = GridLayoutInfo.getGridData(component);
            int horizontalAlignment = gridData.getHorizontalAlignment();
            int verticalAlignment = gridData.getVerticalAlignment();
            Rectangle cells = GridLayoutSurroundSupport.getCells(component);
            cells = cells.getTranslated(locationOffset);
            targetLayout.command_ADD(component, cells.x, false, cells.y, false);
            targetLayout.command_setCells(component, cells, false);
            gridData = GridLayoutInfo.getGridData(component);
            gridData.setHorizontalAlignment(horizontalAlignment);
            gridData.setVerticalAlignment(verticalAlignment);
        }
    }
}

