/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.variable;

import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.variable.FieldUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LocalUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LocalVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.check.Assert;

public final class LocalReuseVariableSupport
extends LocalVariableSupport {
    public LocalReuseVariableSupport(JavaInfo javaInfo, SimpleName variable) {
        super(javaInfo, variable);
    }

    public String toString() {
        return "local-reused: " + this.getName();
    }

    @Override
    public void setName(String newName) throws Exception {
        this.convertLocalToField();
        this.m_javaInfo.getVariableSupport().setName(newName);
    }

    @Override
    public String getReferenceExpression(NodeTarget target) throws Exception {
        this.assertJavaInfoCreatedAt(target);
        if (this.isVisibleAtTarget(target)) {
            return this.getName();
        }
        this.convertLocalToField();
        return this.m_javaInfo.getVariableSupport().getReferenceExpression(target);
    }

    @Override
    public void convertLocalToField() throws Exception {
        if (this.m_declaration.getName() == this.m_variable) {
            this.splitVariable();
        }
        String fieldName = this.addUniqueField(this.isStaticContext(), null);
        this.replaceComponentReferences(fieldName);
        this.m_javaInfo.setVariableSupport(new FieldUniqueVariableSupport(this.m_javaInfo, this.m_variable));
    }

    @Override
    public void setType(String newTypeName) throws Exception {
        if (this.m_declaration.getName() == this.m_variable) {
            this.splitVariable();
        }
        Assert.isTrue((this.m_variable.getLocationInParent() == Assignment.LEFT_HAND_SIDE_PROPERTY && this.m_variable.getParent().getLocationInParent() == ExpressionStatement.EXPRESSION_PROPERTY ? 1 : 0) != 0, (String)("Variable should be part of Assignment in ExpressionStatement, for " + AstNodeUtils.getEnclosingStatement((ASTNode)this.m_variable)));
        Assignment oldAssignment = (Assignment)this.m_variable.getParent();
        ExpressionStatement oldStatement = (ExpressionStatement)AstNodeUtils.getEnclosingStatement((ASTNode)oldAssignment);
        AstEditor editor = this.m_javaInfo.getEditor();
        AST ast = this.m_variable.getAST();
        int position = oldStatement.getStartPosition();
        String source = "";
        Type newType = editor.getParser().parseQualifiedType(position, newTypeName);
        source = String.valueOf(source) + newTypeName + " ";
        String identifier = AstNodeUtils.getVariableName((ASTNode)this.m_variable);
        identifier = editor.getUniqueVariableName(position, identifier, null);
        this.replaceComponentReferences(identifier);
        SimpleName newVariable = editor.getParser().parseVariable(position + source.length(), identifier, null, AstNodeUtils.getTypeBinding(newType), false, 0);
        source = String.valueOf(source) + identifier;
        source = String.valueOf(source) + " = ";
        Expression newInitializer = oldAssignment.getRightHandSide();
        oldAssignment.setRightHandSide((Expression)ast.newSimpleName("__bar__"));
        String initializerSource = editor.getSource((ASTNode)newInitializer);
        AstNodeUtils.moveNode((ASTNode)newInitializer, position + source.length());
        source = String.valueOf(source) + initializerSource;
        VariableDeclarationFragment newFragment = ast.newVariableDeclarationFragment();
        newFragment.setName(newVariable);
        newFragment.setInitializer(newInitializer);
        AstNodeUtils.setSourceRange((ASTNode)newFragment, (ASTNode)newVariable, (ASTNode)newInitializer);
        VariableDeclarationStatement newStatement = ast.newVariableDeclarationStatement(newFragment);
        newStatement.setType(newType);
        AstNodeUtils.setSourceRange((ASTNode)newStatement, (ASTNode)newType, (ASTNode)newFragment, 1);
        source = String.valueOf(source) + ";";
        List<Statement> statements = DomGenerics.statements((Block)oldStatement.getParent());
        int index = statements.indexOf(oldStatement);
        statements.remove(index);
        editor.replaceSubstring((ASTNode)oldStatement, source);
        statements.add(index, (Statement)newStatement);
        editor.resolveImports((ASTNode)newStatement);
        this.m_javaInfo.setVariableSupport(new LocalUniqueVariableSupport(this.m_javaInfo, newVariable));
    }

    private void splitVariable() throws Exception {
        AstEditor editor = this.m_javaInfo.getEditor();
        VariableDeclaration oldFragment = this.m_declaration;
        VariableDeclarationStatement oldStatement = this.getDeclarationStatement();
        int position = oldStatement.getStartPosition();
        String source = "";
        Type oldType = oldStatement.getType();
        Type newType = editor.getParser().parseType(position, oldType);
        source = String.valueOf(source) + editor.getSource((ASTNode)oldType) + " ";
        String identifier = AstNodeUtils.getVariableName((ASTNode)this.m_variable);
        SimpleName newVariable = editor.getParser().parseVariable(position + source.length(), identifier, null, AstNodeUtils.getTypeBinding(newType), false, 0);
        source = String.valueOf(source) + identifier;
        VariableDeclarationFragment newFragment = this.m_variable.getAST().newVariableDeclarationFragment();
        newFragment.setName(newVariable);
        AstNodeUtils.copySourceRange((ASTNode)newFragment, (ASTNode)newVariable);
        VariableDeclarationStatement newStatement = this.m_variable.getAST().newVariableDeclarationStatement(newFragment);
        newStatement.setType(newType);
        AstNodeUtils.setSourceRange((ASTNode)newStatement, (ASTNode)newType, (ASTNode)newFragment, 1);
        source = String.valueOf(source) + ";";
        String prefix = editor.getWhitespaceToLeft(position, false);
        source = String.valueOf(source) + editor.getGeneration().getEndOfLine() + prefix;
        editor.replaceSubstring(position, 0, source);
        List<Statement> statements = DomGenerics.statements((Block)oldStatement.getParent());
        int index = statements.indexOf(oldStatement);
        statements.add(index, (Statement)newStatement);
        this.replaceDeclarationWithAssignment(editor, oldFragment);
        this.rememberDeclaration();
    }
}

