/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.debug.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.rcptt.core.scenario.impl.ContextImpl;
import org.eclipse.rcptt.debug.BreakpointResource;
import org.eclipse.rcptt.debug.DebugContext;
import org.eclipse.rcptt.debug.DebugPackage;
import org.eclipse.rcptt.debug.Launch;
import org.eclipse.rcptt.debug.LaunchType;

public class DebugContextImpl
extends ContextImpl
implements DebugContext {
    protected static final boolean NO_LAUNCHES_EDEFAULT = true;
    protected boolean noLaunches = true;
    protected static final boolean NO_BREAKPOINTS_EDEFAULT = true;
    protected boolean noBreakpoints = true;
    protected static final boolean NO_LAUNCH_SHORTCUTS_EDEFAULT = false;
    protected boolean noLaunchShortcuts = false;
    protected static final String LAUNCH_SHORTCUT_EXCEPTIONS_EDEFAULT = null;
    protected String launchShortcutExceptions = LAUNCH_SHORTCUT_EXCEPTIONS_EDEFAULT;
    protected static final String LAUNCH_EXCEPTIONS_EDEFAULT = null;
    protected String launchExceptions = LAUNCH_EXCEPTIONS_EDEFAULT;
    protected EList<BreakpointResource> breakpointResources;
    protected EList<Launch> launches;
    protected EList<LaunchType> launchTypes;

    protected DebugContextImpl() {
    }

    protected EClass eStaticClass() {
        return DebugPackage.Literals.DEBUG_CONTEXT;
    }

    @Override
    public boolean isNoLaunches() {
        return this.noLaunches;
    }

    @Override
    public void setNoLaunches(boolean newNoLaunches) {
        boolean oldNoLaunches = this.noLaunches;
        this.noLaunches = newNoLaunches;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldNoLaunches, this.noLaunches));
        }
    }

    @Override
    public boolean isNoBreakpoints() {
        return this.noBreakpoints;
    }

    @Override
    public void setNoBreakpoints(boolean newNoBreakpoints) {
        boolean oldNoBreakpoints = this.noBreakpoints;
        this.noBreakpoints = newNoBreakpoints;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, oldNoBreakpoints, this.noBreakpoints));
        }
    }

    @Override
    public boolean isNoLaunchShortcuts() {
        return this.noLaunchShortcuts;
    }

    @Override
    public void setNoLaunchShortcuts(boolean newNoLaunchShortcuts) {
        boolean oldNoLaunchShortcuts = this.noLaunchShortcuts;
        this.noLaunchShortcuts = newNoLaunchShortcuts;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldNoLaunchShortcuts, this.noLaunchShortcuts));
        }
    }

    @Override
    public String getLaunchShortcutExceptions() {
        return this.launchShortcutExceptions;
    }

    @Override
    public void setLaunchShortcutExceptions(String newLaunchShortcutExceptions) {
        String oldLaunchShortcutExceptions = this.launchShortcutExceptions;
        this.launchShortcutExceptions = newLaunchShortcutExceptions;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldLaunchShortcutExceptions, (Object)this.launchShortcutExceptions));
        }
    }

    @Override
    public String getLaunchExceptions() {
        return this.launchExceptions;
    }

    @Override
    public void setLaunchExceptions(String newLaunchExceptions) {
        String oldLaunchExceptions = this.launchExceptions;
        this.launchExceptions = newLaunchExceptions;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldLaunchExceptions, (Object)this.launchExceptions));
        }
    }

    @Override
    public EList<BreakpointResource> getBreakpointResources() {
        if (this.breakpointResources == null) {
            this.breakpointResources = new EObjectContainmentEList(BreakpointResource.class, (InternalEObject)this, 11);
        }
        return this.breakpointResources;
    }

    @Override
    public EList<Launch> getLaunches() {
        if (this.launches == null) {
            this.launches = new EObjectContainmentEList(Launch.class, (InternalEObject)this, 12);
        }
        return this.launches;
    }

    @Override
    public EList<LaunchType> getLaunchTypes() {
        if (this.launchTypes == null) {
            this.launchTypes = new EObjectContainmentEList(LaunchType.class, (InternalEObject)this, 13);
        }
        return this.launchTypes;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 11: {
                return ((InternalEList)this.getBreakpointResources()).basicRemove((Object)otherEnd, msgs);
            }
            case 12: {
                return ((InternalEList)this.getLaunches()).basicRemove((Object)otherEnd, msgs);
            }
            case 13: {
                return ((InternalEList)this.getLaunchTypes()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 6: {
                return this.isNoLaunches();
            }
            case 7: {
                return this.isNoBreakpoints();
            }
            case 8: {
                return this.isNoLaunchShortcuts();
            }
            case 9: {
                return this.getLaunchShortcutExceptions();
            }
            case 10: {
                return this.getLaunchExceptions();
            }
            case 11: {
                return this.getBreakpointResources();
            }
            case 12: {
                return this.getLaunches();
            }
            case 13: {
                return this.getLaunchTypes();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 6: {
                this.setNoLaunches((Boolean)newValue);
                return;
            }
            case 7: {
                this.setNoBreakpoints((Boolean)newValue);
                return;
            }
            case 8: {
                this.setNoLaunchShortcuts((Boolean)newValue);
                return;
            }
            case 9: {
                this.setLaunchShortcutExceptions((String)newValue);
                return;
            }
            case 10: {
                this.setLaunchExceptions((String)newValue);
                return;
            }
            case 11: {
                this.getBreakpointResources().clear();
                this.getBreakpointResources().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.getLaunches().clear();
                this.getLaunches().addAll((Collection)newValue);
                return;
            }
            case 13: {
                this.getLaunchTypes().clear();
                this.getLaunchTypes().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 6: {
                this.setNoLaunches(true);
                return;
            }
            case 7: {
                this.setNoBreakpoints(true);
                return;
            }
            case 8: {
                this.setNoLaunchShortcuts(false);
                return;
            }
            case 9: {
                this.setLaunchShortcutExceptions(LAUNCH_SHORTCUT_EXCEPTIONS_EDEFAULT);
                return;
            }
            case 10: {
                this.setLaunchExceptions(LAUNCH_EXCEPTIONS_EDEFAULT);
                return;
            }
            case 11: {
                this.getBreakpointResources().clear();
                return;
            }
            case 12: {
                this.getLaunches().clear();
                return;
            }
            case 13: {
                this.getLaunchTypes().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 6: {
                return !this.noLaunches;
            }
            case 7: {
                return !this.noBreakpoints;
            }
            case 8: {
                return this.noLaunchShortcuts;
            }
            case 9: {
                return LAUNCH_SHORTCUT_EXCEPTIONS_EDEFAULT == null ? this.launchShortcutExceptions != null : !LAUNCH_SHORTCUT_EXCEPTIONS_EDEFAULT.equals(this.launchShortcutExceptions);
            }
            case 10: {
                return LAUNCH_EXCEPTIONS_EDEFAULT == null ? this.launchExceptions != null : !LAUNCH_EXCEPTIONS_EDEFAULT.equals(this.launchExceptions);
            }
            case 11: {
                return this.breakpointResources != null && !this.breakpointResources.isEmpty();
            }
            case 12: {
                return this.launches != null && !this.launches.isEmpty();
            }
            case 13: {
                return this.launchTypes != null && !this.launchTypes.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (noLaunches: ");
        result.append(this.noLaunches);
        result.append(", noBreakpoints: ");
        result.append(this.noBreakpoints);
        result.append(", noLaunchShortcuts: ");
        result.append(this.noLaunchShortcuts);
        result.append(", launchShortcutExceptions: ");
        result.append(this.launchShortcutExceptions);
        result.append(", launchExceptions: ");
        result.append(this.launchExceptions);
        result.append(')');
        return result.toString();
    }
}

