/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.aif;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeEnum;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValueEnum;
import org.eclipse.ptp.internal.debug.core.pdi.aif.ValueIntegral;
import org.eclipse.ptp.internal.debug.core.pdi.model.aif.AIFFactory;

public class AIFValueEnum
extends ValueIntegral
implements IAIFValueEnum {
    private int fValue = 0;

    public AIFValueEnum(IAIFTypeEnum type, AIFFactory.SimpleByteBuffer buffer) {
        super(type);
        this.parse(buffer);
    }

    @Override
    protected void parse(AIFFactory.SimpleByteBuffer buffer) {
        byte[] dst = new byte[this.getType().sizeof()];
        int i = 0;
        while (i < dst.length) {
            dst[i] = buffer.get();
            ++i;
        }
        ByteBuffer buf = ByteBuffer.wrap(dst, 0, dst.length);
        try {
            this.fValue = buf.getInt();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        this.setSize(this.getType().sizeof());
    }

    @Override
    public int intValue() {
        return this.fValue;
    }

    @Override
    public String getValueString() throws AIFException {
        Integer[] values = ((IAIFTypeEnum)this.getType()).getValues();
        int i = 0;
        while (i < values.length) {
            if (values[i].intValue() == this.intValue()) {
                return ((IAIFTypeEnum)this.getType()).getNames()[i];
            }
            ++i;
        }
        return "";
    }
}

