/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.language;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.internal.core.language.IPHPVariablesInitializer;
import org.eclipse.php.internal.core.language.PHPVariablesInitializerPHP_5;
import org.eclipse.php.internal.core.language.PHPVariablesInitializerPHP_5_4;

public class PHPVariables {
    public static int GLOBAL = 1;
    public static int SUPER_GLOBAL = 4;
    private static Map<PHPVersion, PHPVariables> instances = new HashMap<PHPVersion, PHPVariables>();
    private Map<Integer, String[]> variables = new HashMap<Integer, String[]>();

    private PHPVariables(IPHPVariablesInitializer initializer) {
        LinkedList<String> tmp = new LinkedList<String>();
        initializer.initializeGlobals(tmp);
        this.variables.put(GLOBAL, tmp.toArray(new String[tmp.size()]));
        tmp.clear();
        initializer.initializeSuperGlobals(tmp);
        this.variables.put(SUPER_GLOBAL, tmp.toArray(new String[tmp.size()]));
    }

    public static boolean isVariable(@Nullable String name, PHPVersion phpVersion) {
        String[] variables;
        if (name == null) {
            return false;
        }
        String[] stringArray = variables = PHPVariables.getVariables(phpVersion);
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            String variable = stringArray[n2];
            if (variable.equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String[] getVariables(PHPVersion phpVersion) {
        return PHPVariables.getVariables(phpVersion, GLOBAL | SUPER_GLOBAL);
    }

    public static String[] getVariables(PHPVersion phpVersion, int type) {
        return PHPVariables.getInstance(phpVersion).getByType(type);
    }

    public String[] getByType(int type) {
        LinkedList<String> result = new LinkedList<String>();
        for (Map.Entry<Integer, String[]> item : this.variables.entrySet()) {
            if (item.getKey() == type) {
                return (String[])item.getValue().clone();
            }
            if ((type & item.getKey()) == 0) continue;
            result.addAll(Arrays.asList(item.getValue()));
        }
        return result.toArray(new String[result.size()]);
    }

    private static PHPVariables getInstance(PHPVersion phpVersion) {
        if (!instances.containsKey((Object)phpVersion)) {
            instances.put(phpVersion, new PHPVariables(switch (phpVersion) {
                case PHPVersion.PHP5_4, PHPVersion.PHP5_5, PHPVersion.PHP5_6, PHPVersion.PHP7_0, PHPVersion.PHP7_1, PHPVersion.PHP7_2, PHPVersion.PHP7_3, PHPVersion.PHP7_4, PHPVersion.PHP8_0, PHPVersion.PHP8_1, PHPVersion.PHP8_2 -> new PHPVariablesInitializerPHP_5_4();
                default -> new PHPVariablesInitializerPHP_5();
            }));
        }
        return instances.get((Object)phpVersion);
    }
}

