/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.internal.evaluation.ExecutorInternal;
import org.eclipse.ocl.pivot.internal.manager.PivotExecutorManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;

public class ThreadLocalExecutor {
    private static final @NonNull String TAG_MANAGER = "manager";
    private static final @NonNull String ATT_CLASS = "class";
    public static final @NonNull TracingOption THREAD_LOCAL_ENVIRONMENT_FACTORY = new TracingOption("org.eclipse.ocl.pivot", "environmentFactory/threadLocal");
    private static final @NonNull ThreadLocal<@Nullable ThreadLocalExecutor> INSTANCE = new ThreadLocal();
    private static @Nullable ThreadLocalExecutor CREATOR = null;
    private static final Logger logger = Logger.getLogger(ThreadLocalExecutor.class);
    private boolean concurrentEnvironmentFactories = false;
    private @Nullable EnvironmentFactoryInternal environmentFactory = null;
    private @Nullable Executor executor = null;
    private boolean usesFinalizer = false;

    public static void attachEnvironmentFactory(@NonNull EnvironmentFactoryInternal environmentFactory) {
        ThreadLocalExecutor threadLocalExecutor = ThreadLocalExecutor.get();
        threadLocalExecutor.localAttachEnvironmentFactory(environmentFactory);
    }

    public static @Nullable EnvironmentFactoryInternal basicGetEnvironmentFactory() {
        ThreadLocalExecutor threadLocalExecutor = INSTANCE.get();
        if (threadLocalExecutor == null) {
            return null;
        }
        return threadLocalExecutor.localBasicGetEnvironmentFactory();
    }

    public static @Nullable Executor basicGetExecutor() {
        ThreadLocalExecutor threadLocalExecutor = INSTANCE.get();
        if (threadLocalExecutor == null) {
            return null;
        }
        return threadLocalExecutor.localBasicGetExecutor();
    }

    protected static @NonNull ThreadLocalExecutor createThreadLocalExecutor() {
        ThreadLocalExecutor CREATOR2 = CREATOR;
        if (CREATOR2 == null) {
            ThreadLocalExecutor readExtension = ThreadLocalExecutor.readExtension();
            CREATOR2 = readExtension != null ? readExtension : new ThreadLocalExecutor();
            CREATOR = CREATOR2;
        }
        return CREATOR2.createInstance();
    }

    public static void detachEnvironmentFactory(@NonNull EnvironmentFactory environmentFactory) {
        ThreadLocalExecutor threadLocalExecutor = INSTANCE.get();
        if (threadLocalExecutor != null) {
            threadLocalExecutor.localDetachEnvironmentFactory(environmentFactory);
        }
    }

    protected static @NonNull ThreadLocalExecutor get() {
        ThreadLocalExecutor threadLocalExecutor = INSTANCE.get();
        if (threadLocalExecutor == null) {
            threadLocalExecutor = ThreadLocalExecutor.createThreadLocalExecutor();
            INSTANCE.set(threadLocalExecutor);
        }
        return threadLocalExecutor;
    }

    public static @NonNull EnvironmentFactoryInternal getEnvironmentFactory() {
        ThreadLocalExecutor threadLocalExecutor = ThreadLocalExecutor.get();
        return ClassUtil.nonNullState(threadLocalExecutor.localBasicGetEnvironmentFactory());
    }

    private static @Nullable ThreadLocalExecutor readExtension() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return null;
        }
        String maxClassName = null;
        IConfigurationElement maxElement = null;
        IExtensionPoint point = extensionRegistry.getExtensionPoint("org.eclipse.ocl.pivot", "thread_local");
        if (point != null) {
            IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                String className = null;
                String tagName = element.getName();
                if (TAG_MANAGER.equals(tagName)) {
                    className = element.getAttribute(ATT_CLASS);
                }
                if (className != null) {
                    if (maxClassName == null) {
                        maxClassName = className;
                        maxElement = element;
                    } else if (maxClassName.length() < className.length()) {
                        maxClassName = className;
                        maxElement = element;
                    } else if (maxClassName.length() == className.length() && className.compareTo(maxClassName) < 0) {
                        maxClassName = className;
                        maxElement = element;
                    }
                }
                ++n2;
            }
            if (maxElement != null) {
                try {
                    return (ThreadLocalExecutor)maxElement.createExecutableExtension(ATT_CLASS);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static void reset() {
        ThreadLocalExecutor threadLocalExecutor = INSTANCE.get();
        if (threadLocalExecutor != null) {
            threadLocalExecutor.localReset();
        }
    }

    public static void resetEnvironmentFactory() {
        ThreadLocalExecutor threadLocalExecutor = INSTANCE.get();
        if (threadLocalExecutor != null) {
            threadLocalExecutor.localRemoveEnvironmentFactory();
        }
    }

    public static void setExecutor(@Nullable Executor executor) {
        ThreadLocalExecutor threadLocalExecutor = ThreadLocalExecutor.get();
        threadLocalExecutor.localSetExecutor(executor);
    }

    public static void setUsesFinalizer() {
        ThreadLocalExecutor threadLocalExecutor = INSTANCE.get();
        if (threadLocalExecutor != null) {
            threadLocalExecutor.usesFinalizer = true;
        }
    }

    public static @NonNull String toDebugString() {
        ThreadLocalExecutor threadLocalExecutor = INSTANCE.get();
        return threadLocalExecutor != null ? threadLocalExecutor.toString() : "*** FINALIZED ***";
    }

    public static boolean usesFinalizer() {
        ThreadLocalExecutor threadLocalExecutor = INSTANCE.get();
        return threadLocalExecutor != null && threadLocalExecutor.usesFinalizer;
    }

    @Deprecated
    public static boolean waitForGC() throws InterruptedException {
        ThreadLocalExecutor threadLocalExecutor = INSTANCE.get();
        return threadLocalExecutor != null && threadLocalExecutor.localWaitForGC();
    }

    protected @NonNull ThreadLocalExecutor createInstance() {
        return new ThreadLocalExecutor();
    }

    protected void finalize() throws Throwable {
        if (THREAD_LOCAL_ENVIRONMENT_FACTORY.isActive()) {
            THREAD_LOCAL_ENVIRONMENT_FACTORY.println("[" + Thread.currentThread().getName() + "] Finalize " + this.toString());
        }
        this.localReset();
    }

    protected @NonNull String getThreadName() {
        return "[" + Thread.currentThread().getName() + "]";
    }

    protected void localAttachEnvironmentFactory(@NonNull EnvironmentFactoryInternal newEnvironmentFactory) {
        if (!this.concurrentEnvironmentFactories && !newEnvironmentFactory.isDisposed()) {
            EnvironmentFactoryInternal oldEnvironmentFactory = this.environmentFactory;
            if (oldEnvironmentFactory == null) {
                this.setEnvironmentFactory(newEnvironmentFactory);
            } else if (oldEnvironmentFactory.isDisposed()) {
                this.setEnvironmentFactory(newEnvironmentFactory);
            } else if (oldEnvironmentFactory != newEnvironmentFactory) {
                this.setEnvironmentFactory(null);
                this.executor = null;
                this.concurrentEnvironmentFactories = true;
                String message = "Concurrent EnvironmentFactory instances inhibit local thread Executor passing.\n\tSee https://wiki.eclipse.org/OCL/FAQ#Concurrent_EnvironmentFactory_instances";
                logger.warn((Object)message);
            }
        } else assert (this.executor == null);
        if (THREAD_LOCAL_ENVIRONMENT_FACTORY.isActive()) {
            THREAD_LOCAL_ENVIRONMENT_FACTORY.println(String.valueOf(this.getThreadName()) + " Attach " + this.toString());
        }
    }

    protected @Nullable EnvironmentFactoryInternal localBasicGetEnvironmentFactory() {
        if (this.concurrentEnvironmentFactories) assert (this.environmentFactory == null);
        return this.environmentFactory != null && !this.environmentFactory.isDisposed() ? this.environmentFactory : null;
    }

    private @Nullable Executor localBasicGetExecutor() {
        if (this.concurrentEnvironmentFactories) assert (this.executor == null);
        EnvironmentFactoryInternal environmentFactory2 = this.environmentFactory;
        return environmentFactory2 == null || !environmentFactory2.isDisposed() ? this.executor : null;
    }

    protected void localDetachEnvironmentFactory(@NonNull EnvironmentFactory environmentFactory) {
        if (this.environmentFactory == environmentFactory) {
            if (!this.concurrentEnvironmentFactories) {
                this.setEnvironmentFactory(null);
            }
            if (THREAD_LOCAL_ENVIRONMENT_FACTORY.isActive()) {
                THREAD_LOCAL_ENVIRONMENT_FACTORY.println(String.valueOf(this.getThreadName()) + " Detach " + this.toString());
            }
        }
    }

    private void localRemoveEnvironmentFactory() {
        if (!this.concurrentEnvironmentFactories) {
            this.setEnvironmentFactory(null);
        }
        if (THREAD_LOCAL_ENVIRONMENT_FACTORY.isActive()) {
            THREAD_LOCAL_ENVIRONMENT_FACTORY.println(String.valueOf(this.getThreadName()) + " Remove " + this.toString());
        }
    }

    protected synchronized void localReset() {
        this.setEnvironmentFactory(null);
        this.executor = null;
        this.concurrentEnvironmentFactories = false;
        this.usesFinalizer = false;
        if (THREAD_LOCAL_ENVIRONMENT_FACTORY.isActive()) {
            THREAD_LOCAL_ENVIRONMENT_FACTORY.println(String.valueOf(this.getThreadName()) + " Reset " + this.toString());
        }
    }

    private void localSetExecutor(@Nullable Executor executor) {
        if (executor != null) {
            if (!this.concurrentEnvironmentFactories) {
                this.executor = executor;
            }
            if (executor instanceof PivotExecutorManager) {
                this.localAttachEnvironmentFactory((EnvironmentFactoryInternal)((PivotExecutorManager)executor).getEnvironmentFactory());
            }
            if (THREAD_LOCAL_ENVIRONMENT_FACTORY.isActive()) {
                THREAD_LOCAL_ENVIRONMENT_FACTORY.println(String.valueOf(this.getThreadName()) + " Set " + this.toString());
            }
        } else {
            this.executor = null;
            if (THREAD_LOCAL_ENVIRONMENT_FACTORY.isActive()) {
                THREAD_LOCAL_ENVIRONMENT_FACTORY.println(String.valueOf(this.getThreadName()) + " Reset " + this.toString());
            }
        }
    }

    protected void setEnvironmentFactory(@Nullable EnvironmentFactoryInternal newEnvironmentFactory) {
        EnvironmentFactoryInternal oldEnvironmentFactory = this.environmentFactory;
        if (newEnvironmentFactory != oldEnvironmentFactory) {
            if (oldEnvironmentFactory != null && !oldEnvironmentFactory.isDisposed()) {
                oldEnvironmentFactory.detach(this);
                this.environmentFactory = null;
                if (this.usesFinalizer) {
                    System.gc();
                    this.usesFinalizer = false;
                }
            }
            if (newEnvironmentFactory != null && !newEnvironmentFactory.isDisposed()) {
                this.environmentFactory = newEnvironmentFactory;
                newEnvironmentFactory.attach(this);
            }
            this.executor = null;
        }
    }

    public @NonNull String toString() {
        if (!this.concurrentEnvironmentFactories) {
            StringBuilder s = new StringBuilder();
            s.append(this.environmentFactory != null ? NameUtil.debugSimpleName(this.environmentFactory) : "no-environmentFactory");
            s.append(" ");
            Executor executor = this.executor;
            if (executor != null) {
                s.append(NameUtil.debugSimpleName(executor));
                ExecutorInternal interpretedExecutor = executor.basicGetInterpretedExecutor();
                if (interpretedExecutor != null && interpretedExecutor != executor) {
                    s.append("+");
                    s.append(NameUtil.debugSimpleName(interpretedExecutor));
                }
            } else {
                s.append("no-executor");
            }
            return s.toString();
        }
        return "**** CONCURRENT ENVIRONMENT FACTORIES ****";
    }

    @Deprecated
    public boolean localWaitForGC() throws InterruptedException {
        if (this.concurrentEnvironmentFactories) {
            return false;
        }
        EnvironmentFactoryInternal environmentFactory2 = this.environmentFactory;
        if (environmentFactory2 == null) {
            return true;
        }
        int i = 0;
        while (i < 10) {
            environmentFactory2.detachRedundantThreadLocal();
            System.gc();
            System.runFinalization();
            if (environmentFactory2.isDisposed()) {
                return true;
            }
            Thread.sleep(10L);
            ++i;
        }
        return false;
    }
}

