/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.core.pr;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GsonUtils;
import org.eclipse.egit.github.core.service.IssueService;
import org.eclipse.egit.github.core.service.PullRequestService;
import org.eclipse.mylyn.internal.github.core.GitHub;
import org.eclipse.mylyn.internal.github.core.GitHubTaskDataHandler;
import org.eclipse.mylyn.internal.github.core.issue.IssueConnector;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestAttribute;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestComposite;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestConnector;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestOperation;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class PullRequestTaskDataHandler
extends GitHubTaskDataHandler {
    private static final String DATA_VERSION = "1.1";

    public PullRequestTaskDataHandler(PullRequestConnector connector) {
    }

    public TaskData createTaskData(TaskRepository repository, IProgressMonitor monitor, IRepositoryIdProvider repo, PullRequestComposite prComp) {
        PullRequest pr = prComp.getRequest();
        String key = Integer.toString(pr.getNumber());
        TaskData data = new TaskData(this.getAttributeMapper(repository), "githubPullRequests", repository.getRepositoryUrl(), key);
        data.setVersion(DATA_VERSION);
        this.createOperations(data, pr);
        this.createAttribute(data, PullRequestAttribute.KEY.getMetadata(), key);
        this.createAttribute(data, PullRequestAttribute.TITLE.getMetadata(), pr.getTitle());
        this.createAttribute(data, PullRequestAttribute.BODY.getMetadata(), pr.getBody());
        this.createAttribute(data, PullRequestAttribute.STATUS.getMetadata(), pr.getState());
        this.createAttribute(data, PullRequestAttribute.CREATION_DATE.getMetadata(), pr.getCreatedAt());
        this.createAttribute(data, PullRequestAttribute.MODIFICATION_DATE.getMetadata(), pr.getUpdatedAt());
        this.createAttribute(data, PullRequestAttribute.CLOSED_DATE.getMetadata(), pr.getClosedAt());
        User reporter = pr.getUser();
        this.createAttribute(data, PullRequestAttribute.REPORTER.getMetadata(), reporter, repository);
        String reporterGravatar = reporter != null ? reporter.getAvatarUrl() : null;
        this.createAttribute(data, PullRequestAttribute.REPORTER_GRAVATAR.getMetadata(), reporterGravatar);
        this.createAttribute(data, PullRequestAttribute.COMMENT_NEW.getMetadata());
        this.createAttribute(data, PullRequestAttribute.MODEL.getMetadata(), GsonUtils.toJson((Object)prComp));
        return data;
    }

    private void createOperations(TaskData data, PullRequest pr) {
        this.createOperationAttribute(data);
        if (data.isNew()) {
            return;
        }
        if (pr.isMerged()) {
            return;
        }
        String state = pr.getState();
        if (state != null) {
            this.addOperation(data, pr, PullRequestOperation.LEAVE, true);
            if (state.equals("open")) {
                this.addOperation(data, pr, PullRequestOperation.CLOSE, false);
            } else if (state.equals("closed")) {
                this.addOperation(data, pr, PullRequestOperation.REOPEN, false);
            }
        }
    }

    private void addOperation(TaskData data, PullRequest pr, PullRequestOperation operation, boolean isDefault) {
        String id = operation.getId();
        String label = this.createOperationLabel(pr, operation);
        this.addOperation(data, id, label, isDefault);
    }

    private String createOperationLabel(PullRequest pr, PullRequestOperation operation) {
        return operation == PullRequestOperation.LEAVE ? String.valueOf(operation.getLabel()) + pr.getState() : operation.getLabel();
    }

    public TaskData createTaskData(TaskRepository repository, IProgressMonitor monitor, IRepositoryIdProvider repo, PullRequestComposite pr, List<Comment> comments) {
        TaskData taskData = this.createTaskData(repository, monitor, repo, pr);
        taskData.setPartial(false);
        this.addComments(taskData.getRoot(), comments, repository);
        return taskData;
    }

    private PullRequest createPullRequest(TaskData taskData) {
        PullRequest pr = new PullRequest();
        if (!taskData.isNew()) {
            pr.setNumber(Integer.parseInt(taskData.getTaskId()));
        }
        pr.setBody(this.getAttributeValue(taskData, PullRequestAttribute.BODY.getMetadata()));
        pr.setTitle(this.getAttributeValue(taskData, PullRequestAttribute.TITLE.getMetadata()));
        return pr;
    }

    public boolean initializeTaskData(TaskRepository repository, TaskData data, ITaskMapping initializationData, IProgressMonitor monitor) throws CoreException {
        data.setVersion(DATA_VERSION);
        PullRequestAttribute[] pullRequestAttributeArray = PullRequestAttribute.values();
        int n = pullRequestAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PullRequestAttribute attr = pullRequestAttributeArray[n2];
            if (attr.getMetadata().isInitTask()) {
                this.createAttribute(data, attr.getMetadata(), (String)null);
            }
            ++n2;
        }
        return true;
    }

    public RepositoryResponse postTaskData(TaskRepository repository, TaskData taskData, Set<TaskAttribute> oldAttributes, IProgressMonitor monitor) throws CoreException {
        String taskId = taskData.getTaskId();
        PullRequest pr = this.createPullRequest(taskData);
        RepositoryId repo = PullRequestConnector.getRepository(repository.getRepositoryUrl());
        try {
            GitHubClient client = IssueConnector.createClient(repository);
            boolean collaborator = this.isCollaborator(client, repo);
            PullRequestService prService = new PullRequestService(client);
            IssueService issueService = new IssueService(client);
            if (taskData.isNew()) {
                pr.setState("open");
                pr = prService.createPullRequest((IRepositoryIdProvider)repo, pr);
                taskId = Integer.toString(pr.getNumber());
            } else {
                String comment = this.getAttributeValue(taskData, PullRequestAttribute.COMMENT_NEW.getMetadata());
                if (comment != null && comment.length() > 0) {
                    issueService.createComment(repo.getOwner(), repo.getName(), taskId, comment);
                }
                boolean reporter = this.attributeMatchesUser(client, PullRequestAttribute.REPORTER.getMetadata(), taskData);
                if (collaborator || reporter) {
                    TaskAttribute operationAttribute = taskData.getRoot().getAttribute("task.common.operation");
                    if (operationAttribute != null) {
                        PullRequestOperation operation = PullRequestOperation.fromId(operationAttribute.getValue());
                        if (operation == PullRequestOperation.REOPEN) {
                            pr.setState("open");
                        } else if (operation == PullRequestOperation.CLOSE) {
                            pr.setState("closed");
                        }
                    }
                    prService.editPullRequest((IRepositoryIdProvider)repo, pr);
                }
            }
            return new RepositoryResponse(taskData.isNew() ? RepositoryResponse.ResponseKind.TASK_CREATED : RepositoryResponse.ResponseKind.TASK_UPDATED, taskId);
        }
        catch (IOException e) {
            throw new CoreException(GitHub.createWrappedStatus(e));
        }
    }
}

