/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.IQVTReconcilingListener;

public class ProblemUpdater
implements IQVTReconcilingListener {
    private IAnnotationModel fAnnotationModel;

    ProblemUpdater(IAnnotationModel annotationModel) {
        if (annotationModel == null) {
            throw new IllegalArgumentException();
        }
        this.fAnnotationModel = annotationModel;
    }

    @Override
    public void reconciled(CompiledUnit unit, IProgressMonitor monitor) {
        if (unit == null) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            return;
        }
        this.reportProblems(unit, monitor);
    }

    @Override
    public void aboutToBeReconciled() {
    }

    private void reportProblems(CompiledUnit unit, IProgressMonitor monitor) {
        ArrayList<Annotation> annotationsToRemove = new ArrayList<Annotation>();
        Iterator iter = this.fAnnotationModel.getAnnotationIterator();
        while (iter.hasNext()) {
            Annotation annotation = (Annotation)iter.next();
            String annotationType = annotation.getType();
            if (!"org.eclipse.m2m.qvt.oml.error".equals(annotationType) && !"org.eclipse.m2m.qvt.oml.warning".equals(annotationType)) continue;
            annotationsToRemove.add(annotation);
        }
        if (monitor.isCanceled()) {
            return;
        }
        HashMap<Annotation, Position> annotationsToAdd = new HashMap<Annotation, Position>();
        for (QvtMessage qvtMessage : unit.getProblems()) {
            if (!ProblemUpdater.checkProblem(qvtMessage)) continue;
            annotationsToAdd.put(this.createProblemAnnotation(qvtMessage), this.createProblemPosition(qvtMessage));
        }
        if (monitor.isCanceled()) {
            return;
        }
        if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension iAnnotationModelExtension = (IAnnotationModelExtension)this.fAnnotationModel;
            iAnnotationModelExtension.replaceAnnotations(annotationsToRemove.toArray(new Annotation[annotationsToRemove.size()]), annotationsToAdd);
        } else {
            for (Annotation annotation : annotationsToRemove) {
                this.fAnnotationModel.removeAnnotation(annotation);
            }
            for (Map.Entry entry : annotationsToAdd.entrySet()) {
                this.fAnnotationModel.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
            }
        }
    }

    private static boolean checkProblem(QvtMessage problem) {
        return problem != null && problem.getOffset() >= 0 && problem.getLength() >= 0;
    }

    private Annotation createProblemAnnotation(QvtMessage problem) {
        return new Annotation(this.getAnnotationType(problem), true, problem.getMessage());
    }

    private String getAnnotationType(QvtMessage message) {
        switch (message.getSeverity()) {
            case 4: {
                return "org.eclipse.m2m.qvt.oml.error";
            }
            case 2: {
                return "org.eclipse.m2m.qvt.oml.warning";
            }
        }
        throw new IllegalArgumentException();
    }

    private Position createProblemPosition(QvtMessage problem) {
        return new Position(problem.getOffset(), problem.getLength());
    }
}

