package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link VolumeList}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableVolumeList.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableVolumeList implements VolumeList {
  private final @Nullable List<Volume> volumes;
  private final @Nullable List<String> warnings;

  private ImmutableVolumeList(
      @Nullable List<Volume> volumes,
      @Nullable List<String> warnings) {
    this.volumes = volumes;
    this.warnings = warnings;
  }

  /**
   * @return The value of the {@code volumes} attribute
   */
  @JsonProperty("Volumes")
  @Override
  public @Nullable List<Volume> volumes() {
    return volumes;
  }

  /**
   * @return The value of the {@code warnings} attribute
   */
  @JsonProperty("Warnings")
  @Override
  public @Nullable List<String> warnings() {
    return warnings;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link VolumeList#volumes() volumes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableVolumeList withVolumes(@Nullable Volume... elements) {
    if (elements == null) {
      return new ImmutableVolumeList(null, this.warnings);
    }
    @Nullable List<Volume> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableVolumeList(newValue, this.warnings);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link VolumeList#volumes() volumes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of volumes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableVolumeList withVolumes(@Nullable Iterable<? extends Volume> elements) {
    if (this.volumes == elements) return this;
    @Nullable List<Volume> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableVolumeList(newValue, this.warnings);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link VolumeList#warnings() warnings}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableVolumeList withWarnings(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableVolumeList(this.volumes, null);
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableVolumeList(this.volumes, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link VolumeList#warnings() warnings}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of warnings elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableVolumeList withWarnings(@Nullable Iterable<String> elements) {
    if (this.warnings == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableVolumeList(this.volumes, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableVolumeList} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableVolumeList
        && equalTo((ImmutableVolumeList) another);
  }

  private boolean equalTo(ImmutableVolumeList another) {
    return Objects.equals(volumes, another.volumes)
        && Objects.equals(warnings, another.warnings);
  }

  /**
   * Computes a hash code from attributes: {@code volumes}, {@code warnings}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(volumes);
    h += (h << 5) + Objects.hashCode(warnings);
    return h;
  }

  /**
   * Prints the immutable value {@code VolumeList} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "VolumeList{"
        + "volumes=" + volumes
        + ", warnings=" + warnings
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link VolumeList} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable VolumeList instance
   */
  public static ImmutableVolumeList copyOf(VolumeList instance) {
    if (instance instanceof ImmutableVolumeList) {
      return (ImmutableVolumeList) instance;
    }
    return ImmutableVolumeList.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableVolumeList ImmutableVolumeList}.
   * <pre>
   * ImmutableVolumeList.builder()
   *    .volumes(List&amp;lt;org.mandas.docker.client.messages.Volume&amp;gt; | null) // nullable {@link VolumeList#volumes() volumes}
   *    .warnings(List&amp;lt;String&amp;gt; | null) // nullable {@link VolumeList#warnings() warnings}
   *    .build();
   * </pre>
   * @return A new ImmutableVolumeList builder
   */
  public static ImmutableVolumeList.Builder builder() {
    return new ImmutableVolumeList.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableVolumeList ImmutableVolumeList}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder {
    private List<Volume> volumes = null;
    private List<String> warnings = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code VolumeList} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(VolumeList instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable List<Volume> volumesValue = instance.volumes();
      if (volumesValue != null) {
        addAllVolumes(volumesValue);
      }
      @Nullable List<String> warningsValue = instance.warnings();
      if (warningsValue != null) {
        addAllWarnings(warningsValue);
      }
      return this;
    }

    /**
     * Adds one element to {@link VolumeList#volumes() volumes} list.
     * @param element A volumes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder volume(Volume element) {
      if (this.volumes == null) {
        this.volumes = new ArrayList<Volume>();
      }
      this.volumes.add(Objects.requireNonNull(element, "volumes element"));
      return this;
    }

    /**
     * Adds elements to {@link VolumeList#volumes() volumes} list.
     * @param elements An array of volumes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder volumes(Volume... elements) {
      if (this.volumes == null) {
        this.volumes = new ArrayList<Volume>();
      }
      for (Volume element : elements) {
        this.volumes.add(Objects.requireNonNull(element, "volumes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link VolumeList#volumes() volumes} list.
     * @param elements An iterable of volumes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Volumes")
    public final Builder volumes(@Nullable Iterable<? extends Volume> elements) {
      if (elements == null) {
        this.volumes = null;
        return this;
      }
      this.volumes = new ArrayList<Volume>();
      return addAllVolumes(elements);
    }

    /**
     * Adds elements to {@link VolumeList#volumes() volumes} list.
     * @param elements An iterable of volumes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllVolumes(Iterable<? extends Volume> elements) {
      Objects.requireNonNull(elements, "volumes element");
      if (this.volumes == null) {
        this.volumes = new ArrayList<Volume>();
      }
      for (Volume element : elements) {
        this.volumes.add(Objects.requireNonNull(element, "volumes element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link VolumeList#warnings() warnings} list.
     * @param element A warnings element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder warning(String element) {
      if (this.warnings == null) {
        this.warnings = new ArrayList<String>();
      }
      this.warnings.add(Objects.requireNonNull(element, "warnings element"));
      return this;
    }

    /**
     * Adds elements to {@link VolumeList#warnings() warnings} list.
     * @param elements An array of warnings elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder warnings(String... elements) {
      if (this.warnings == null) {
        this.warnings = new ArrayList<String>();
      }
      for (String element : elements) {
        this.warnings.add(Objects.requireNonNull(element, "warnings element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link VolumeList#warnings() warnings} list.
     * @param elements An iterable of warnings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Warnings")
    public final Builder warnings(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.warnings = null;
        return this;
      }
      this.warnings = new ArrayList<String>();
      return addAllWarnings(elements);
    }

    /**
     * Adds elements to {@link VolumeList#warnings() warnings} list.
     * @param elements An iterable of warnings elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllWarnings(Iterable<String> elements) {
      Objects.requireNonNull(elements, "warnings element");
      if (this.warnings == null) {
        this.warnings = new ArrayList<String>();
      }
      for (String element : elements) {
        this.warnings.add(Objects.requireNonNull(element, "warnings element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableVolumeList ImmutableVolumeList}.
     * @return An immutable instance of VolumeList
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableVolumeList build() {
      return new ImmutableVolumeList(
          volumes == null ? null : createUnmodifiableList(true, volumes),
          warnings == null ? null : createUnmodifiableList(true, warnings));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
