/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.xtext.ui.editor.model.DocumentTokenSourceAccess;
import org.eclipse.xtext.ui.editor.model.ILexerTokenRegion;
import org.eclipse.xtext.ui.editor.model.Regions;
import org.eclipse.xtext.ui.editor.model.XtextDocument;

public class PresentationDamager
implements IPresentationDamager {
    @Inject
    protected DocumentTokenSourceAccess tokenSourceAccess = new DocumentTokenSourceAccess();

    public void setDocument(IDocument document) {
    }

    public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
        IRegion lastDamage = this.tokenSourceAccess.getLastDamage(e.getDocument());
        if (lastDamage == null || !this.isEventMatchingLastDamage(e, lastDamage)) {
            IRegion result = this.computeIntersection(partition, e, e.getDocument());
            return result;
        }
        if (!TextUtilities.overlaps((IRegion)partition, (IRegion)lastDamage) && lastDamage.getOffset() < e.getDocument().getLength()) {
            if (documentPartitioningChanged) {
                return partition;
            }
            return lastDamage;
        }
        int offset = Math.max(lastDamage.getOffset(), partition.getOffset());
        int endOffset = Math.min(lastDamage.getOffset() + lastDamage.getLength(), partition.getOffset() + partition.getLength());
        Region result = new Region(offset, endOffset - offset);
        return result;
    }

    protected IRegion computeIntersection(ITypedRegion partition, DocumentEvent e, IDocument document) {
        if (document instanceof XtextDocument) {
            return this.computeInterSection(partition, e, (XtextDocument)document);
        }
        return this.doComputeIntersection(partition, e, document);
    }

    @Deprecated
    protected IRegion computeInterSection(ITypedRegion partition, DocumentEvent e, XtextDocument document) {
        return this.doComputeIntersection(partition, e, document);
    }

    private IRegion doComputeIntersection(ITypedRegion partition, DocumentEvent e, IDocument document) {
        Iterable tokensInPartition = Iterables.filter(this.tokenSourceAccess.getTokens(document, false), Regions.overlaps(partition.getOffset(), partition.getLength()));
        Iterator tokens = Iterables.filter((Iterable)tokensInPartition, Regions.overlaps(e.getOffset(), e.getLength())).iterator();
        if (tokens.hasNext()) {
            ILexerTokenRegion first;
            ILexerTokenRegion last = first = (ILexerTokenRegion)tokens.next();
            while (tokens.hasNext()) {
                last = (ILexerTokenRegion)tokens.next();
            }
            return new Region(first.getOffset(), last.getOffset() + last.getLength() - first.getOffset());
        }
        return partition;
    }

    protected boolean isEventMatchingLastDamage(DocumentEvent e, IRegion lastDamage) {
        int eventStart = e.getOffset();
        int eventEnd = eventStart + e.getText().length();
        int damageStart = lastDamage.getOffset();
        int damageEnd = damageStart + lastDamage.getLength();
        boolean result = damageStart <= eventStart && damageEnd >= eventEnd;
        return result;
    }
}

